/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.mitre.caasd.commons.fileutil.FileUtils;

public class PropertyUtils {
    public static Properties loadProperties(String pathToTextFile) {
        Preconditions.checkNotNull((Object)pathToTextFile, (Object)"The path to a properties file cannot be null");
        return PropertyUtils.loadProperties(new File(pathToTextFile));
    }

    public static Properties loadProperties(File propertiesFile) {
        Preconditions.checkNotNull((Object)propertiesFile, (Object)"The input propertiesFile cannot be null");
        Preconditions.checkArgument((boolean)propertiesFile.exists(), (Object)("The file: " + propertiesFile.getName() + " does not exist"));
        try {
            return FileUtils.getProperties(propertiesFile);
        }
        catch (IOException ex) {
            throw new PropertyLoadingException("Problem loading Properties file: " + propertiesFile.getAbsolutePath() + "\n" + ex.getMessage(), ex);
        }
    }

    public static ImmutableMap<String, String> asImmutableMap(Properties props) {
        Preconditions.checkNotNull((Object)props, (Object)"The input properties cannot be null");
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            builder.put((Object)key.trim(), (Object)value.trim());
        }
        return builder.build();
    }

    public static Properties parseProperties(String allProperties) {
        Preconditions.checkNotNull((Object)allProperties, (Object)"Cannot parse a null input String");
        Properties props = new Properties();
        try {
            props.load(new StringReader(allProperties));
        }
        catch (IOException ioe) {
            throw new PropertyLoadingException("Problem parsing properties from: " + allProperties, ioe);
        }
        return props;
    }

    public static void verifyPropertyIsSet(Properties props, String requiredPropertyKey) {
        PropertyUtils.getString(requiredPropertyKey, props);
    }

    public static void verifyPropertiesAreSet(Properties props, String ... requiredPropertyKeys) {
        for (String key : requiredPropertyKeys) {
            PropertyUtils.getString(key, props);
        }
    }

    public static void verifyPropertiesAreSet(Properties props, Collection<String> requiredPropertyKeys) {
        for (String key : requiredPropertyKeys) {
            PropertyUtils.getString(key, props);
        }
    }

    public static String getString(String propertyKey, Properties properties) {
        Preconditions.checkNotNull((Object)propertyKey);
        Preconditions.checkNotNull((Object)properties);
        String value = properties.getProperty(propertyKey);
        if (value != null) {
            return value.trim();
        }
        throw new MissingPropertyException(propertyKey);
    }

    public static byte getByte(String propertyKey, Properties properties) {
        return Byte.parseByte(PropertyUtils.getString(propertyKey, properties));
    }

    public static short getShort(String propertyKey, Properties properties) {
        return Short.parseShort(PropertyUtils.getString(propertyKey, properties));
    }

    public static int getInt(String propertyKey, Properties properties) {
        return Integer.parseInt(PropertyUtils.getString(propertyKey, properties));
    }

    public static long getLong(String propertyKey, Properties properties) {
        return Long.parseLong(PropertyUtils.getString(propertyKey, properties));
    }

    public static float getFloat(String propertyKey, Properties properties) {
        return Float.parseFloat(PropertyUtils.getString(propertyKey, properties));
    }

    public static double getDouble(String propertyKey, Properties properties) {
        return Double.parseDouble(PropertyUtils.getString(propertyKey, properties));
    }

    public static boolean getBoolean(String propertyKey, Properties properties) {
        Preconditions.checkNotNull((Object)propertyKey);
        Preconditions.checkNotNull((Object)properties);
        return Boolean.parseBoolean(PropertyUtils.getString(propertyKey, properties));
    }

    public static Optional<String> getOptionalString(String propertyKey, Properties properties) {
        String value = properties.getProperty(propertyKey);
        if (value != null) {
            return Optional.of(value.trim());
        }
        return Optional.empty();
    }

    public static String getOptionalString(String propertyKey, Properties properties, String defaultValue) {
        String value = properties.getProperty(propertyKey);
        if (value != null) {
            return value.trim();
        }
        return defaultValue;
    }

    public static byte getOptionalByte(String propertyKey, Properties properties, byte defaultValue) {
        Optional<String> prop = PropertyUtils.getOptionalString(propertyKey, properties);
        return prop.isPresent() ? Byte.parseByte(prop.get()) : defaultValue;
    }

    public static short getOptionalShort(String propertyKey, Properties properties, short defaultValue) {
        Optional<String> prop = PropertyUtils.getOptionalString(propertyKey, properties);
        return prop.isPresent() ? Short.parseShort(prop.get()) : defaultValue;
    }

    public static int getOptionalInt(String propertyKey, Properties properties, int defaultValue) {
        Optional<String> prop = PropertyUtils.getOptionalString(propertyKey, properties);
        return prop.isPresent() ? Integer.parseInt(prop.get()) : defaultValue;
    }

    public static long getOptionalLong(String propertyKey, Properties properties, long defaultValue) {
        Optional<String> prop = PropertyUtils.getOptionalString(propertyKey, properties);
        return prop.isPresent() ? Long.parseLong(prop.get()) : defaultValue;
    }

    public static float getOptionalFloat(String propertyKey, Properties properties, float defaultValue) {
        Optional<String> prop = PropertyUtils.getOptionalString(propertyKey, properties);
        return prop.isPresent() ? Float.parseFloat(prop.get()) : defaultValue;
    }

    public static double getOptionalDouble(String propertyKey, Properties properties, double defaultValue) {
        Optional<String> prop = PropertyUtils.getOptionalString(propertyKey, properties);
        return prop.isPresent() ? Double.parseDouble(prop.get()) : defaultValue;
    }

    public static boolean getOptionalBoolean(String propertyKey, Properties properties, boolean defaultValue) {
        Optional<String> prop = PropertyUtils.getOptionalString(propertyKey, properties);
        return prop.isPresent() ? Boolean.parseBoolean(prop.get()) : defaultValue;
    }

    public static List<String> tokenizeAndValidate(String csvLine, Collection<String> validTokens) {
        Preconditions.checkNotNull(validTokens);
        csvLine = csvLine.trim();
        if (csvLine.isEmpty()) {
            return Lists.newArrayList();
        }
        Object[] splits = csvLine.split(",");
        for (int i = 0; i < splits.length; ++i) {
            splits[i] = ((String)splits[i]).trim();
            Preconditions.checkArgument((boolean)validTokens.contains(splits[i]), (Object)("Invalid token: " + (String)splits[i] + " found in: " + csvLine));
        }
        return Lists.newArrayList((Object[])splits);
    }

    public static class PropertyLoadingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        PropertyLoadingException(String message, Exception cause) {
            super(message, cause);
        }
    }

    public static class MissingPropertyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MissingPropertyException(String nameOfMissingProperty) {
            super("The property " + nameOfMissingProperty + " is missing");
        }
    }
}

