/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.mitre.caasd.commons.fileutil.FileUtils;
import org.mitre.caasd.commons.util.DemotedException;
import org.mitre.caasd.commons.util.ExceptionHandler;
import org.mitre.caasd.commons.util.Exceptions;

public class SequentialFileWriter
implements ExceptionHandler {
    private final AtomicInteger fileCounter = new AtomicInteger(0);
    private final String targetDirectory;

    public SequentialFileWriter() {
        this(System.getProperty("user.dir"));
    }

    public SequentialFileWriter(String directory) {
        Preconditions.checkNotNull((Object)directory);
        this.targetDirectory = directory.endsWith(File.separator) ? directory : directory + File.separator;
    }

    public void write(String filePrefix, String message) {
        File newFile = this.createNumberedFile(filePrefix);
        this.appendSilently(newFile, message);
    }

    @Override
    public void warn(String message) {
        File warningFile = this.createNumberedFile("warning");
        String completeMessage = this.authorWarningMessage(message);
        this.appendSilently(warningFile, completeMessage);
        System.out.println("\n\n**** WARNING WRITTEN TO :: " + warningFile.getName() + " ****\n\n");
    }

    @Override
    public void handle(String message, Exception traceMe) {
        File errorFile = this.createNumberedFile("error");
        String completeMessage = this.authorErrorMessage(message, traceMe);
        this.appendSilently(errorFile, completeMessage);
        System.out.println("\n\n**** STACK TRACE WRITTEN TO :: " + errorFile.getName() + " ****\n\n");
    }

    private File createNumberedFile(String prefix) {
        FileUtils.makeDirIfMissing(this.targetDirectory);
        int fileNumber = this.fileCounter.getAndIncrement();
        String fileName = prefix + "_" + fileNumber + ".txt";
        return new File(this.targetDirectory + fileName);
    }

    private void appendSilently(File targetFile, String content) {
        try {
            FileUtils.appendToFile(targetFile, content);
        }
        catch (Exception ioe) {
            throw DemotedException.demote(ioe);
        }
    }

    private String authorWarningMessage(String message) {
        String msg = Objects.nonNull(message) ? message : "NO WARNING MESSAGE";
        return SequentialFileWriter.timestampStr() + "\n" + msg + "\n";
    }

    private String authorErrorMessage(String message, Throwable traceMe) {
        String msg = Objects.nonNull(message) ? message : "NO ERROR MESSAGE";
        return SequentialFileWriter.timestampStr() + "\n" + (msg + "\n") + (Exceptions.stackTraceOf(traceMe) + "\n");
    }

    private static String timestampStr() {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.US).withZone(ZoneId.systemDefault());
        return "Time: " + formatter.format(Instant.now());
    }
}

