/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class SupplierChain<T>
implements Supplier<T> {
    private final List<Supplier<? super T>> suppliers;
    private Supplier<? super T> highestPriorityWorkingSupplier;

    public SupplierChain(List<Supplier<? super T>> listOfSuppliers) {
        this.suppliers = Lists.newArrayList(listOfSuppliers);
    }

    @SafeVarargs
    public static <T> SupplierChain<T> of(Supplier<? super T> ... suppliers) {
        return new SupplierChain<T>(Lists.newArrayList((Object[])suppliers));
    }

    @Override
    public T get() {
        if (Objects.nonNull(this.highestPriorityWorkingSupplier)) {
            return this.highestPriorityWorkingSupplier.get();
        }
        ArrayList exceptionMessages = Lists.newArrayList();
        for (Supplier<T> aSupplier : this.suppliers) {
            try {
                T result = aSupplier.get();
                if (!Objects.nonNull(result)) continue;
                this.highestPriorityWorkingSupplier = aSupplier;
                return result;
            }
            catch (Exception ex) {
                String message = String.valueOf(aSupplier) + ": " + ex.getMessage();
                exceptionMessages.add(message);
            }
        }
        throw new IllegalStateException("No Supplier in the SupplierChain provided a non-null result: " + String.valueOf(exceptionMessages));
    }
}

