/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.caasd.commons.util;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.mitre.caasd.commons.util.PropertyUtils;
import org.mitre.caasd.commons.util.SupplierChain;

public class Suppliers {
    public static SupplierChain<String> stringSupplierChain(String propertyKey, File flatFile) {
        return SupplierChain.of(Suppliers.environmentVarSupplier(propertyKey), Suppliers.systemPropertySupplier(propertyKey), Suppliers.fileBasedSupplier(flatFile, propertyKey));
    }

    public static Supplier<String> environmentVarSupplier(String key) {
        return new EnvironmentVarSupplier(key);
    }

    public static Supplier<String> systemPropertySupplier(String key) {
        return new SystemPropertiesSupplier(key);
    }

    public static Supplier<String> fileBasedSupplier(File f, String key) {
        return new FileBasedSupplier(f, key);
    }

    public static class EnvironmentVarSupplier
    implements Supplier<String> {
        private final String propertyKey;
        private boolean queryWasRun;
        private String propertyValue;

        public EnvironmentVarSupplier(String key) {
            Objects.requireNonNull(key, "The System property search key cannot be null");
            this.propertyKey = key;
            this.queryWasRun = false;
            this.propertyValue = null;
        }

        @Override
        public String get() {
            if (this.queryWasRun) {
                return this.propertyValue;
            }
            String val = System.getenv(this.propertyKey);
            this.queryWasRun = true;
            this.propertyValue = Objects.nonNull(val) ? val.trim() : null;
            return this.propertyValue;
        }
    }

    public static class SystemPropertiesSupplier
    implements Supplier<String> {
        private final String propertyKey;
        private boolean queryWasRun;
        private String propertyValue;

        public SystemPropertiesSupplier(String key) {
            Objects.requireNonNull(key, "The System property search key cannot be null");
            this.propertyKey = key;
            this.queryWasRun = false;
            this.propertyValue = null;
        }

        @Override
        public String get() {
            if (this.queryWasRun) {
                return this.propertyValue;
            }
            String val = System.getProperty(this.propertyKey);
            this.queryWasRun = true;
            this.propertyValue = Objects.nonNull(val) ? val.trim() : null;
            return this.propertyValue;
        }
    }

    public static class FileBasedSupplier
    implements Supplier<String> {
        private final File sourceFile;
        private final String propertyKey;
        private boolean queryWasRun;
        private String propertyValue;

        public FileBasedSupplier(File sourceFile, String key) {
            Objects.requireNonNull(key);
            this.sourceFile = sourceFile;
            this.propertyKey = key;
            this.queryWasRun = false;
            this.propertyValue = null;
        }

        @Override
        public String get() {
            if (this.queryWasRun) {
                return this.propertyValue;
            }
            Properties props = PropertyUtils.loadProperties(this.sourceFile);
            Optional<String> optValue = PropertyUtils.getOptionalString(this.propertyKey, props);
            this.queryWasRun = true;
            this.propertyValue = optValue.isPresent() ? optValue.get().trim() : null;
            return this.propertyValue;
        }
    }
}

