/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jose.jwk;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mitre.jose.jwk.ECKeyMaker;
import org.mitre.jose.jwk.OKPKeyMaker;
import org.mitre.jose.jwk.OctetSequenceKeyMaker;
import org.mitre.jose.jwk.RSAKeyMaker;

public class Launcher {
    private static Options options;
    private static List<Curve> ecCurves;
    private static List<Curve> okpCurves;

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        options = new Options();
        options.addOption("t", true, "Key Type, one of: " + KeyType.RSA.getValue() + ", " + KeyType.OCT.getValue() + ", " + KeyType.EC.getValue() + ", " + KeyType.OKP.getValue());
        options.addOption("s", true, "Key Size in bits, required for RSA and oct key types. Must be an integer divisible by 8");
        options.addOption("u", true, "Usage, one of: enc, sig (optional)");
        options.addOption("a", true, "Algorithm (optional)");
        options.addOption("i", true, "Key ID (optional), one will be generated if not defined");
        options.addOption("I", false, "Don't generate a Key ID if none defined");
        options.addOption("p", false, "Display public key separately");
        options.addOption("c", true, "Key Curve, required for EC or OKP key type. Must be one of " + Joiner.on((String)", ").join(ecCurves) + " for EC keys or one of " + Joiner.on((String)", ").join(okpCurves) + " for OKP keys.");
        options.addOption("S", false, "Wrap the generated key in a KeySet");
        options.addOption("o", true, "Write output to file (will append to existing KeySet if -S is used), No Display of Key Material");
        PosixParser parser = new PosixParser();
        try {
            Curve keyCurve;
            Integer keySize;
            CommandLine cmd = parser.parse(options, args);
            String kty = cmd.getOptionValue("t");
            String size = cmd.getOptionValue("s");
            String use = cmd.getOptionValue("u");
            String alg = cmd.getOptionValue("a");
            String kid = cmd.getOptionValue("i");
            String crv = cmd.getOptionValue("c");
            boolean keySet = cmd.hasOption("S");
            boolean pubKey = cmd.hasOption("p");
            boolean doNotGenerateKid = cmd.hasOption("I");
            String outFile = cmd.getOptionValue("o");
            if (kty == null) {
                Launcher.printUsageAndExit("Key type must be supplied.");
            }
            KeyType keyType = KeyType.parse((String)kty);
            KeyUse keyUse = null;
            if (use != null) {
                if (use.equals("sig")) {
                    keyUse = KeyUse.SIGNATURE;
                } else if (use.equals("enc")) {
                    keyUse = KeyUse.ENCRYPTION;
                } else {
                    Launcher.printUsageAndExit("Invalid key usage, must be 'sig' or 'enc', got " + use);
                }
            }
            if (Strings.isNullOrEmpty((String)kid)) {
                kid = doNotGenerateKid ? null : Launcher.generateKid(keyUse);
            }
            JWSAlgorithm keyAlg = null;
            if (!Strings.isNullOrEmpty((String)alg)) {
                keyAlg = JWSAlgorithm.parse((String)alg);
            }
            RSAKey jwk = null;
            if (keyType.equals((Object)KeyType.RSA)) {
                if (Strings.isNullOrEmpty((String)size)) {
                    Launcher.printUsageAndExit("Key size (in bits) is required for key type " + keyType);
                }
                if ((keySize = Integer.decode(size)) % 8 != 0) {
                    Launcher.printUsageAndExit("Key size (in bits) must be divisible by 8, got " + keySize);
                }
                jwk = RSAKeyMaker.make(keySize, keyUse, (Algorithm)keyAlg, kid);
            } else if (keyType.equals((Object)KeyType.OCT)) {
                if (Strings.isNullOrEmpty((String)size)) {
                    Launcher.printUsageAndExit("Key size (in bits) is required for key type " + keyType);
                }
                if ((keySize = Integer.decode(size)) % 8 != 0) {
                    Launcher.printUsageAndExit("Key size (in bits) must be divisible by 8, got " + keySize);
                }
                jwk = OctetSequenceKeyMaker.make(keySize, keyUse, (Algorithm)keyAlg, kid);
            } else if (keyType.equals((Object)KeyType.EC)) {
                if (Strings.isNullOrEmpty((String)crv)) {
                    Launcher.printUsageAndExit("Curve is required for key type " + keyType);
                }
                if (!ecCurves.contains(keyCurve = Curve.parse((String)crv))) {
                    Launcher.printUsageAndExit("Curve " + crv + " is not valid for key type " + keyType);
                }
                jwk = ECKeyMaker.make(keyCurve, keyUse, (Algorithm)keyAlg, kid);
            } else if (keyType.equals((Object)KeyType.OKP)) {
                if (Strings.isNullOrEmpty((String)crv)) {
                    Launcher.printUsageAndExit("Curve is required for key type " + keyType);
                }
                if (!okpCurves.contains(keyCurve = Curve.parse((String)crv))) {
                    Launcher.printUsageAndExit("Curve " + crv + " is not valid for key type " + keyType);
                }
                jwk = OKPKeyMaker.make(keyCurve, keyUse, (Algorithm)keyAlg, kid);
            } else {
                Launcher.printUsageAndExit("Unknown key type: " + keyType);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (outFile == null) {
                System.out.println("Full key:");
                Launcher.printKey(keySet, (JWK)jwk, gson);
                if (pubKey) {
                    System.out.println();
                    JWK pub = jwk.toPublicJWK();
                    if (pub != null) {
                        System.out.println("Public key:");
                        Launcher.printKey(keySet, pub, gson);
                    } else {
                        System.out.println("No public key.");
                    }
                }
            } else {
                Launcher.writeKeyToFile(keySet, outFile, (JWK)jwk, gson);
            }
        }
        catch (NumberFormatException e) {
            Launcher.printUsageAndExit("Invalid key size: " + e.getMessage());
        }
        catch (ParseException e) {
            Launcher.printUsageAndExit("Failed to parse arguments: " + e.getMessage());
        }
        catch (java.text.ParseException e) {
            Launcher.printUsageAndExit("Could not parse existing KeySet: " + e.getMessage());
        }
        catch (IOException e) {
            Launcher.printUsageAndExit("Could not read existing KeySet: " + e.getMessage());
        }
    }

    private static String generateKid(KeyUse keyUse) {
        String prefix = keyUse == null ? "" : keyUse.identifier();
        return prefix + System.currentTimeMillis() / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeKeyToFile(boolean keySet, String outFile, JWK jwk, Gson gson) throws IOException, java.text.ParseException {
        JsonElement json;
        File output = new File(outFile);
        if (keySet) {
            List existingKeys = output.exists() ? JWKSet.load((File)output).getKeys() : Collections.emptyList();
            ArrayList<JWK> jwkList = new ArrayList<JWK>(existingKeys);
            jwkList.add(jwk);
            JWKSet jwkSet = new JWKSet(jwkList);
            json = new JsonParser().parse(jwkSet.toJSONObject(false).toJSONString());
        } else {
            json = new JsonParser().parse(jwk.toJSONString());
        }
        try (Writer os = null;){
            os = new BufferedWriter(new FileWriter(output));
            os.write(gson.toJson(json));
        }
    }

    private static void printKey(boolean keySet, JWK jwk, Gson gson) {
        if (keySet) {
            JWKSet jwkSet = new JWKSet(jwk);
            JsonElement json = new JsonParser().parse(jwkSet.toJSONObject(false).toJSONString());
            System.out.println(gson.toJson(json));
        } else {
            JsonElement json = new JsonParser().parse(jwk.toJSONString());
            System.out.println(gson.toJson(json));
        }
    }

    private static void printUsageAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        ImmutableList optionOrder = ImmutableList.of((Object)"t", (Object)"s", (Object)"c", (Object)"u", (Object)"a", (Object)"i", (Object)"I", (Object)"p", (Object)"S", (Object)"o");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator((arg_0, arg_1) -> Launcher.lambda$printUsageAndExit$0((List)optionOrder, arg_0, arg_1));
        formatter.printHelp("java -jar json-web-key-generator.jar -t <keyType> [options]", options);
        System.exit(1);
    }

    private static /* synthetic */ int lambda$printUsageAndExit$0(List optionOrder, Object o1, Object o2) {
        return optionOrder.indexOf(((Option)o1).getOpt()) - optionOrder.indexOf(((Option)o2).getOpt());
    }

    static {
        ecCurves = Arrays.asList(Curve.P_256, Curve.SECP256K1, Curve.P_384, Curve.P_521);
        okpCurves = Arrays.asList(Curve.Ed25519, Curve.Ed448, Curve.X25519, Curve.X448);
    }
}

