/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.util.Base64URL;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;

public class OKPKeyMaker {
    public static JWK make(Curve keyCurve, KeyUse keyUse, Algorithm keyAlg, String kid) {
        try {
            ASN1Sequence privPrim;
            byte[] d;
            KeyPair keyPair = null;
            if (keyCurve.equals((Object)Curve.Ed25519)) {
                keyPair = KeyPairGenerator.getInstance("Ed25519").generateKeyPair();
            } else if (keyCurve.equals((Object)Curve.Ed448)) {
                keyPair = KeyPairGenerator.getInstance("Ed448").generateKeyPair();
            } else if (keyCurve.equals((Object)Curve.X25519)) {
                keyPair = KeyPairGenerator.getInstance("X25519").generateKeyPair();
            } else if (keyCurve.equals((Object)Curve.X448)) {
                keyPair = KeyPairGenerator.getInstance("X448").generateKeyPair();
            }
            if (keyPair == null) {
                return null;
            }
            ASN1Sequence pubPrim = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])keyPair.getPublic().getEncoded());
            byte[] x = ((ASN1BitString)pubPrim.getObjectAt(1)).getOctets();
            if (x.length < (d = ((ASN1OctetString)(privPrim = (ASN1Sequence)ASN1Sequence.fromByteArray((byte[])keyPair.getPrivate().getEncoded())).getObjectAt(2)).getOctets()).length) {
                d = ((ASN1OctetString)ASN1OctetString.fromByteArray((byte[])d)).getOctets();
            }
            OctetKeyPair jwk = new OctetKeyPair.Builder(keyCurve, Base64URL.encode((byte[])x)).d(Base64URL.encode((byte[])d)).keyUse(keyUse).algorithm(keyAlg).keyID(kid).build();
            return jwk;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

