/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyUse;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import org.mitre.jose.jwk.KeyIdGenerator;

public class ECKeyMaker {
    public static ECKey make(Curve crv, KeyUse keyUse, Algorithm keyAlg, KeyIdGenerator kid) {
        try {
            ECParameterSpec ecSpec = crv.toECParameterSpec();
            KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
            generator.initialize(ecSpec);
            KeyPair kp = generator.generateKeyPair();
            ECPublicKey pub = (ECPublicKey)kp.getPublic();
            ECPrivateKey priv = (ECPrivateKey)kp.getPrivate();
            ECKey ecKey = new ECKey.Builder(crv, pub).privateKey(priv).keyID(kid.generate(keyUse, pub.getEncoded())).algorithm(keyAlg).keyUse(keyUse).build();
            return ecKey;
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

