/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import org.mitre.jose.jwk.KeyIdGenerator;

public class RSAKeyMaker {
    public static RSAKey make(Integer keySize, KeyUse keyUse, Algorithm keyAlg, KeyIdGenerator kid) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(keySize);
            KeyPair kp = generator.generateKeyPair();
            RSAPublicKey pub = (RSAPublicKey)kp.getPublic();
            RSAPrivateCrtKey priv = (RSAPrivateCrtKey)kp.getPrivate();
            RSAKey rsaKey = new RSAKey.Builder(pub).privateKey(priv).keyUse(keyUse).algorithm(keyAlg).keyID(kid.generate(keyUse, pub.getEncoded())).build();
            return rsaKey;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

