/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.introspectingfilter.service.impl;

import com.google.common.base.Strings;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import org.mitre.oauth2.introspectingfilter.service.IntrospectionConfigurationService;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.client.service.ClientConfigurationService;
import org.mitre.openid.connect.client.service.ServerConfigurationService;
import org.mitre.openid.connect.config.ServerConfiguration;

public class JWTParsingIntrospectionConfigurationService
implements IntrospectionConfigurationService {
    private ServerConfigurationService serverConfigurationService;
    private ClientConfigurationService clientConfigurationService;

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setClientConfigurationService(ClientConfigurationService clientConfigurationService) {
        this.clientConfigurationService = clientConfigurationService;
    }

    private String getIssuer(String accessToken) {
        try {
            JWT jwt = JWTParser.parse((String)accessToken);
            String issuer = jwt.getJWTClaimsSet().getIssuer();
            return issuer;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse JWT", e);
        }
    }

    @Override
    public String getIntrospectionUrl(String accessToken) {
        String issuer = this.getIssuer(accessToken);
        if (!Strings.isNullOrEmpty((String)issuer)) {
            ServerConfiguration server = this.serverConfigurationService.getServerConfiguration(issuer);
            if (server != null) {
                if (!Strings.isNullOrEmpty((String)server.getIntrospectionEndpointUri())) {
                    return server.getIntrospectionEndpointUri();
                }
                throw new IllegalArgumentException("Server does not have Introspection Endpoint defined");
            }
            throw new IllegalArgumentException("Could not find server configuration for issuer " + issuer);
        }
        throw new IllegalArgumentException("No issuer claim found in JWT");
    }

    @Override
    public RegisteredClient getClientConfiguration(String accessToken) {
        String issuer = this.getIssuer(accessToken);
        if (!Strings.isNullOrEmpty((String)issuer)) {
            ServerConfiguration server = this.serverConfigurationService.getServerConfiguration(issuer);
            if (server != null) {
                RegisteredClient client = this.clientConfigurationService.getClientConfiguration(server);
                if (client != null) {
                    return client;
                }
                throw new IllegalArgumentException("Could not find client configuration for issuer " + issuer);
            }
            throw new IllegalArgumentException("Could not find server configuration for issuer " + issuer);
        }
        throw new IllegalArgumentException("No issuer claim found in JWT");
    }
}

