/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.data;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPageOperationTemplate<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPageOperationTemplate.class);
    private static int DEFAULT_MAX_PAGES = 1000;
    private static long DEFAULT_MAX_TIME_MILLIS = 600000L;
    private int maxPages;
    private long maxTime;
    private boolean swallowExceptions = true;
    private String operationName = "";

    public AbstractPageOperationTemplate(String operationName) {
        this(DEFAULT_MAX_PAGES, DEFAULT_MAX_TIME_MILLIS, operationName);
    }

    public AbstractPageOperationTemplate(int maxPages, long maxTime, String operationName) {
        this.maxPages = maxPages;
        this.maxTime = maxTime;
        this.operationName = operationName;
    }

    public void execute() {
        Collection<T> page;
        logger.debug("[" + this.getOperationName() + "] Starting execution of paged operation. maximum time: " + this.maxTime + ", maximum pages: " + this.maxPages);
        long startTime = System.currentTimeMillis();
        long executionTime = 0L;
        int exceptionsSwallowedCount = 0;
        int operationsCompleted = 0;
        HashSet<String> exceptionsSwallowedClasses = new HashSet<String>();
        for (int i = 0; i < this.maxPages && executionTime < this.maxTime && (page = this.fetchPage()) != null && page.size() != 0; ++i) {
            for (T item : page) {
                try {
                    this.doOperation(item);
                    ++operationsCompleted;
                }
                catch (Exception e) {
                    if (this.swallowExceptions) {
                        ++exceptionsSwallowedCount;
                        exceptionsSwallowedClasses.add(e.getClass().getName());
                        logger.debug("Swallowing exception " + e.getMessage(), (Throwable)e);
                        continue;
                    }
                    logger.debug("Rethrowing exception " + e.getMessage());
                    throw e;
                }
            }
            executionTime = System.currentTimeMillis() - startTime;
        }
        this.finalReport(operationsCompleted, exceptionsSwallowedCount, exceptionsSwallowedClasses);
    }

    public abstract Collection<T> fetchPage();

    protected abstract void doOperation(T var1);

    protected void finalReport(int operationsCompleted, int exceptionsSwallowedCount, Set<String> exceptionsSwallowedClasses) {
        if (operationsCompleted > 0 || exceptionsSwallowedCount > 0) {
            logger.info("[" + this.getOperationName() + "] Paged operation run: completed " + operationsCompleted + "; swallowed " + exceptionsSwallowedCount + " exceptions");
        }
        for (String className : exceptionsSwallowedClasses) {
            logger.warn("[" + this.getOperationName() + "] Paged operation swallowed at least one exception of type " + className);
        }
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public void setMaxPages(int maxPages) {
        this.maxPages = maxPages;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public boolean isSwallowExceptions() {
        return this.swallowExceptions;
    }

    public void setSwallowExceptions(boolean swallowExceptions) {
        this.swallowExceptions = swallowExceptions;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }
}

