/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jwt.signer.service.impl;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.util.Base64URL;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.DefaultJWTSigningAndValidationService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SymmetricKeyJWTValidatorCacheService {
    private static final Logger logger = LoggerFactory.getLogger(SymmetricKeyJWTValidatorCacheService.class);
    private LoadingCache<String, JWTSigningAndValidationService> validators = CacheBuilder.newBuilder().expireAfterAccess(24L, TimeUnit.HOURS).maximumSize(100L).build((CacheLoader)new SymmetricValidatorBuilder());

    public JWTSigningAndValidationService getSymmetricValidtor(ClientDetailsEntity client) {
        if (client == null) {
            logger.error("Couldn't create symmetric validator for null client");
            return null;
        }
        if (Strings.isNullOrEmpty((String)client.getClientSecret())) {
            logger.error("Couldn't create symmetric validator for client " + client.getClientId() + " without a client secret");
            return null;
        }
        try {
            return (JWTSigningAndValidationService)this.validators.get((Object)client.getClientSecret());
        }
        catch (UncheckedExecutionException ue) {
            logger.error("Problem loading client validator", (Throwable)ue);
            return null;
        }
        catch (ExecutionException e) {
            logger.error("Problem loading client validator", (Throwable)e);
            return null;
        }
    }

    public class SymmetricValidatorBuilder
    extends CacheLoader<String, JWTSigningAndValidationService> {
        public JWTSigningAndValidationService load(String key) throws Exception {
            try {
                String id = "SYMMETRIC-KEY";
                OctetSequenceKey jwk = new OctetSequenceKey.Builder(Base64URL.encode((String)key)).keyUse(KeyUse.SIGNATURE).keyID(id).build();
                ImmutableMap keys = ImmutableMap.of((Object)id, (Object)jwk);
                DefaultJWTSigningAndValidationService service = new DefaultJWTSigningAndValidationService((Map<String, JWK>)keys);
                return service;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                logger.error("Couldn't create symmetric validator for client", (Throwable)e);
                throw new IllegalArgumentException("Couldn't create symmetric validator for client");
            }
        }
    }
}

