// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: databricks_artifacts.proto

package com.databricks.api.proto.mlflow;

public final class DatabricksArtifacts {
  private DatabricksArtifacts() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * The type of a given artifact access credential
   * </pre>
   *
   * Protobuf enum {@code mlflow.ArtifactCredentialType}
   */
  public enum ArtifactCredentialType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The credential is an Azure Shared Access Signature URI. For more information, see
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview
     * </pre>
     *
     * <code>AZURE_SAS_URI = 1;</code>
     */
    AZURE_SAS_URI(1),
    /**
     * <pre>
     * The credential is an AWS Presigned URL. For more information, see
     * https://docs.aws.amazon.com/AmazonS3/latest/dev/ShareObjectPreSignedURL.html
     * </pre>
     *
     * <code>AWS_PRESIGNED_URL = 2;</code>
     */
    AWS_PRESIGNED_URL(2),
    /**
     * <pre>
     * The credential is a GCP Signed URL. For more information, see
     * https://cloud.google.com/storage/docs/access-control/signed-urls
     * </pre>
     *
     * <code>GCP_SIGNED_URL = 3;</code>
     */
    GCP_SIGNED_URL(3),
    /**
     * <pre>
     * The credential is an Azure Shared Access Signature URI for ADLS.  For more
     * information see
     * https://docs.microsoft.com/en-us/rest/api/storageservices/data-lake-storage-gen2
     * and
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview
     * </pre>
     *
     * <code>AZURE_ADLS_GEN2_SAS_URI = 4;</code>
     */
    AZURE_ADLS_GEN2_SAS_URI(4),
    ;

    /**
     * <pre>
     * The credential is an Azure Shared Access Signature URI. For more information, see
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview
     * </pre>
     *
     * <code>AZURE_SAS_URI = 1;</code>
     */
    public static final int AZURE_SAS_URI_VALUE = 1;
    /**
     * <pre>
     * The credential is an AWS Presigned URL. For more information, see
     * https://docs.aws.amazon.com/AmazonS3/latest/dev/ShareObjectPreSignedURL.html
     * </pre>
     *
     * <code>AWS_PRESIGNED_URL = 2;</code>
     */
    public static final int AWS_PRESIGNED_URL_VALUE = 2;
    /**
     * <pre>
     * The credential is a GCP Signed URL. For more information, see
     * https://cloud.google.com/storage/docs/access-control/signed-urls
     * </pre>
     *
     * <code>GCP_SIGNED_URL = 3;</code>
     */
    public static final int GCP_SIGNED_URL_VALUE = 3;
    /**
     * <pre>
     * The credential is an Azure Shared Access Signature URI for ADLS.  For more
     * information see
     * https://docs.microsoft.com/en-us/rest/api/storageservices/data-lake-storage-gen2
     * and
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview
     * </pre>
     *
     * <code>AZURE_ADLS_GEN2_SAS_URI = 4;</code>
     */
    public static final int AZURE_ADLS_GEN2_SAS_URI_VALUE = 4;


    public final int getNumber() {
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ArtifactCredentialType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ArtifactCredentialType forNumber(int value) {
      switch (value) {
        case 1: return AZURE_SAS_URI;
        case 2: return AWS_PRESIGNED_URL;
        case 3: return GCP_SIGNED_URL;
        case 4: return AZURE_ADLS_GEN2_SAS_URI;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ArtifactCredentialType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ArtifactCredentialType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ArtifactCredentialType>() {
            public ArtifactCredentialType findValueByNumber(int number) {
              return ArtifactCredentialType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.getDescriptor().getEnumTypes().get(0);
    }

    private static final ArtifactCredentialType[] VALUES = values();

    public static ArtifactCredentialType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ArtifactCredentialType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:mlflow.ArtifactCredentialType)
  }

  public interface ArtifactCredentialInfoOrBuilder extends
      // @@protoc_insertion_point(interface_extends:mlflow.ArtifactCredentialInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     * @return Whether the runId field is set.
     */
    boolean hasRunId();
    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     * @return The runId.
     */
    java.lang.String getRunId();
    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     * @return The bytes for runId.
     */
    com.google.protobuf.ByteString
        getRunIdBytes();

    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The path.
     */
    java.lang.String getPath();
    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString
        getPathBytes();

    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     * @return Whether the signedUri field is set.
     */
    boolean hasSignedUri();
    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     * @return The signedUri.
     */
    java.lang.String getSignedUri();
    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     * @return The bytes for signedUri.
     */
    com.google.protobuf.ByteString
        getSignedUriBytes();

    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> 
        getHeadersList();
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getHeaders(int index);
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    int getHeadersCount();
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder> 
        getHeadersOrBuilderList();
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder getHeadersOrBuilder(
        int index);

    /**
     * <pre>
     * The type of the signed credential URI (e.g., an AWS presigned URL
     * or an Azure Shared Access Signature URI)
     * </pre>
     *
     * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <pre>
     * The type of the signed credential URI (e.g., an AWS presigned URL
     * or an Azure Shared Access Signature URI)
     * </pre>
     *
     * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
     * @return The type.
     */
    com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType getType();
  }
  /**
   * Protobuf type {@code mlflow.ArtifactCredentialInfo}
   */
  public static final class ArtifactCredentialInfo extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:mlflow.ArtifactCredentialInfo)
      ArtifactCredentialInfoOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ArtifactCredentialInfo.newBuilder() to construct.
    private ArtifactCredentialInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ArtifactCredentialInfo() {
      runId_ = "";
      path_ = "";
      signedUri_ = "";
      headers_ = java.util.Collections.emptyList();
      type_ = 1;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ArtifactCredentialInfo();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ArtifactCredentialInfo(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              runId_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              path_ = bs;
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              signedUri_ = bs;
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                headers_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader>();
                mutable_bitField0_ |= 0x00000008;
              }
              headers_.add(
                  input.readMessage(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.PARSER, extensionRegistry));
              break;
            }
            case 40: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType value = com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(5, rawValue);
              } else {
                bitField0_ |= 0x00000008;
                type_ = rawValue;
              }
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000008) != 0)) {
          headers_ = java.util.Collections.unmodifiableList(headers_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder.class);
    }

    public interface HttpHeaderOrBuilder extends
        // @@protoc_insertion_point(interface_extends:mlflow.ArtifactCredentialInfo.HttpHeader)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @return Whether the name field is set.
       */
      boolean hasName();
      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @return The name.
       */
      java.lang.String getName();
      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString
          getNameBytes();

      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       * @return The value.
       */
      java.lang.String getValue();
      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       * @return The bytes for value.
       */
      com.google.protobuf.ByteString
          getValueBytes();
    }
    /**
     * Protobuf type {@code mlflow.ArtifactCredentialInfo.HttpHeader}
     */
    public static final class HttpHeader extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:mlflow.ArtifactCredentialInfo.HttpHeader)
        HttpHeaderOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use HttpHeader.newBuilder() to construct.
      private HttpHeader(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private HttpHeader() {
        name_ = "";
        value_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new HttpHeader();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private HttpHeader(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                name_ = bs;
                break;
              }
              case 18: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                value_ = bs;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder.class);
      }

      private int bitField0_;
      public static final int NAME_FIELD_NUMBER = 1;
      private volatile java.lang.Object name_;
      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @return Whether the name field is set.
       */
      @java.lang.Override
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private volatile java.lang.Object value_;
      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       * @return The value.
       */
      @java.lang.Override
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            value_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       * @return The bytes for value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader)) {
          return super.equals(obj);
        }
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader) obj;

        if (hasName() != other.hasName()) return false;
        if (hasName()) {
          if (!getName()
              .equals(other.getName())) return false;
        }
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasName()) {
          hash = (37 * hash) + NAME_FIELD_NUMBER;
          hash = (53 * hash) + getName().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code mlflow.ArtifactCredentialInfo.HttpHeader}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:mlflow.ArtifactCredentialInfo.HttpHeader)
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder.class);
        }

        // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          name_ = "";
          bitField0_ = (bitField0_ & ~0x00000001);
          value_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getDefaultInstanceForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.getDefaultInstance();
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader build() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader buildPartial() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            to_bitField0_ |= 0x00000001;
          }
          result.name_ = name_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000002;
          }
          result.value_ = value_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader) {
            return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader other) {
          if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.getDefaultInstance()) return this;
          if (other.hasName()) {
            bitField0_ |= 0x00000001;
            name_ = other.name_;
            onChanged();
          }
          if (other.hasValue()) {
            bitField0_ |= 0x00000002;
            value_ = other.value_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.lang.Object name_ = "";
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         * @return Whether the name field is set.
         */
        public boolean hasName() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              name_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString
            getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          name_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearName() {
          bitField0_ = (bitField0_ & ~0x00000001);
          name_ = getDefaultInstance().getName();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          name_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object value_ = "";
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         * @return The value.
         */
        public java.lang.String getValue() {
          java.lang.Object ref = value_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              value_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         * @return The bytes for value.
         */
        public com.google.protobuf.ByteString
            getValueBytes() {
          java.lang.Object ref = value_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            value_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          value_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = getDefaultInstance().getValue();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         * @param value The bytes for value to set.
         * @return This builder for chaining.
         */
        public Builder setValueBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          value_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:mlflow.ArtifactCredentialInfo.HttpHeader)
      }

      // @@protoc_insertion_point(class_scope:mlflow.ArtifactCredentialInfo.HttpHeader)
      private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader();
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<HttpHeader>
          PARSER = new com.google.protobuf.AbstractParser<HttpHeader>() {
        @java.lang.Override
        public HttpHeader parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new HttpHeader(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<HttpHeader> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<HttpHeader> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int RUN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object runId_;
    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     * @return Whether the runId field is set.
     */
    @java.lang.Override
    public boolean hasRunId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     * @return The runId.
     */
    @java.lang.Override
    public java.lang.String getRunId() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          runId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     * @return The bytes for runId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getRunIdBytes() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        runId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private volatile java.lang.Object path_;
    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          path_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SIGNED_URI_FIELD_NUMBER = 3;
    private volatile java.lang.Object signedUri_;
    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     * @return Whether the signedUri field is set.
     */
    @java.lang.Override
    public boolean hasSignedUri() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     * @return The signedUri.
     */
    @java.lang.Override
    public java.lang.String getSignedUri() {
      java.lang.Object ref = signedUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          signedUri_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     * @return The bytes for signedUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getSignedUriBytes() {
      java.lang.Object ref = signedUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        signedUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HEADERS_FIELD_NUMBER = 4;
    private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> headers_;
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    @java.lang.Override
    public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> getHeadersList() {
      return headers_;
    }
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder> 
        getHeadersOrBuilderList() {
      return headers_;
    }
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    @java.lang.Override
    public int getHeadersCount() {
      return headers_.size();
    }
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getHeaders(int index) {
      return headers_.get(index);
    }
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder getHeadersOrBuilder(
        int index) {
      return headers_.get(index);
    }

    public static final int TYPE_FIELD_NUMBER = 5;
    private int type_;
    /**
     * <pre>
     * The type of the signed credential URI (e.g., an AWS presigned URL
     * or an Azure Shared Access Signature URI)
     * </pre>
     *
     * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override public boolean hasType() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * The type of the signed credential URI (e.g., an AWS presigned URL
     * or an Azure Shared Access Signature URI)
     * </pre>
     *
     * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
     * @return The type.
     */
    @java.lang.Override public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType getType() {
      @SuppressWarnings("deprecation")
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType result = com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType.valueOf(type_);
      return result == null ? com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType.AZURE_SAS_URI : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, runId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, signedUri_);
      }
      for (int i = 0; i < headers_.size(); i++) {
        output.writeMessage(4, headers_.get(i));
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeEnum(5, type_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, runId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, path_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, signedUri_);
      }
      for (int i = 0; i < headers_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, headers_.get(i));
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(5, type_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo)) {
        return super.equals(obj);
      }
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo) obj;

      if (hasRunId() != other.hasRunId()) return false;
      if (hasRunId()) {
        if (!getRunId()
            .equals(other.getRunId())) return false;
      }
      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (hasSignedUri() != other.hasSignedUri()) return false;
      if (hasSignedUri()) {
        if (!getSignedUri()
            .equals(other.getSignedUri())) return false;
      }
      if (!getHeadersList()
          .equals(other.getHeadersList())) return false;
      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (type_ != other.type_) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRunId()) {
        hash = (37 * hash) + RUN_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRunId().hashCode();
      }
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      if (hasSignedUri()) {
        hash = (37 * hash) + SIGNED_URI_FIELD_NUMBER;
        hash = (53 * hash) + getSignedUri().hashCode();
      }
      if (getHeadersCount() > 0) {
        hash = (37 * hash) + HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + getHeadersList().hashCode();
      }
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code mlflow.ArtifactCredentialInfo}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:mlflow.ArtifactCredentialInfo)
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder.class);
      }

      // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getHeadersFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        runId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        signedUri_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        if (headersBuilder_ == null) {
          headers_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          headersBuilder_.clear();
        }
        type_ = 1;
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_descriptor;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getDefaultInstanceForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo build() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo buildPartial() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.runId_ = runId_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.path_ = path_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.signedUri_ = signedUri_;
        if (headersBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            headers_ = java.util.Collections.unmodifiableList(headers_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.headers_ = headers_;
        } else {
          result.headers_ = headersBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          to_bitField0_ |= 0x00000008;
        }
        result.type_ = type_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo) {
          return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo other) {
        if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance()) return this;
        if (other.hasRunId()) {
          bitField0_ |= 0x00000001;
          runId_ = other.runId_;
          onChanged();
        }
        if (other.hasPath()) {
          bitField0_ |= 0x00000002;
          path_ = other.path_;
          onChanged();
        }
        if (other.hasSignedUri()) {
          bitField0_ |= 0x00000004;
          signedUri_ = other.signedUri_;
          onChanged();
        }
        if (headersBuilder_ == null) {
          if (!other.headers_.isEmpty()) {
            if (headers_.isEmpty()) {
              headers_ = other.headers_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureHeadersIsMutable();
              headers_.addAll(other.headers_);
            }
            onChanged();
          }
        } else {
          if (!other.headers_.isEmpty()) {
            if (headersBuilder_.isEmpty()) {
              headersBuilder_.dispose();
              headersBuilder_ = null;
              headers_ = other.headers_;
              bitField0_ = (bitField0_ & ~0x00000008);
              headersBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getHeadersFieldBuilder() : null;
            } else {
              headersBuilder_.addAllMessages(other.headers_);
            }
          }
        }
        if (other.hasType()) {
          setType(other.getType());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object runId_ = "";
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       * @return Whether the runId field is set.
       */
      public boolean hasRunId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       * @return The runId.
       */
      public java.lang.String getRunId() {
        java.lang.Object ref = runId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            runId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       * @return The bytes for runId.
       */
      public com.google.protobuf.ByteString
          getRunIdBytes() {
        java.lang.Object ref = runId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          runId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       * @param value The runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearRunId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        runId_ = getDefaultInstance().getRunId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       * @param value The bytes for runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            path_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString
          getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        path_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        bitField0_ = (bitField0_ & ~0x00000002);
        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        path_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object signedUri_ = "";
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       * @return Whether the signedUri field is set.
       */
      public boolean hasSignedUri() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       * @return The signedUri.
       */
      public java.lang.String getSignedUri() {
        java.lang.Object ref = signedUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            signedUri_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       * @return The bytes for signedUri.
       */
      public com.google.protobuf.ByteString
          getSignedUriBytes() {
        java.lang.Object ref = signedUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          signedUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       * @param value The signedUri to set.
       * @return This builder for chaining.
       */
      public Builder setSignedUri(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        signedUri_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearSignedUri() {
        bitField0_ = (bitField0_ & ~0x00000004);
        signedUri_ = getDefaultInstance().getSignedUri();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       * @param value The bytes for signedUri to set.
       * @return This builder for chaining.
       */
      public Builder setSignedUriBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        signedUri_ = value;
        onChanged();
        return this;
      }

      private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> headers_ =
        java.util.Collections.emptyList();
      private void ensureHeadersIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          headers_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader>(headers_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder> headersBuilder_;

      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> getHeadersList() {
        if (headersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(headers_);
        } else {
          return headersBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public int getHeadersCount() {
        if (headersBuilder_ == null) {
          return headers_.size();
        } else {
          return headersBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getHeaders(int index) {
        if (headersBuilder_ == null) {
          return headers_.get(index);
        } else {
          return headersBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder setHeaders(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader value) {
        if (headersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHeadersIsMutable();
          headers_.set(index, value);
          onChanged();
        } else {
          headersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder setHeaders(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder builderForValue) {
        if (headersBuilder_ == null) {
          ensureHeadersIsMutable();
          headers_.set(index, builderForValue.build());
          onChanged();
        } else {
          headersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder addHeaders(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader value) {
        if (headersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHeadersIsMutable();
          headers_.add(value);
          onChanged();
        } else {
          headersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder addHeaders(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader value) {
        if (headersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHeadersIsMutable();
          headers_.add(index, value);
          onChanged();
        } else {
          headersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder addHeaders(
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder builderForValue) {
        if (headersBuilder_ == null) {
          ensureHeadersIsMutable();
          headers_.add(builderForValue.build());
          onChanged();
        } else {
          headersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder addHeaders(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder builderForValue) {
        if (headersBuilder_ == null) {
          ensureHeadersIsMutable();
          headers_.add(index, builderForValue.build());
          onChanged();
        } else {
          headersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder addAllHeaders(
          java.lang.Iterable<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> values) {
        if (headersBuilder_ == null) {
          ensureHeadersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, headers_);
          onChanged();
        } else {
          headersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder clearHeaders() {
        if (headersBuilder_ == null) {
          headers_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          headersBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder removeHeaders(int index) {
        if (headersBuilder_ == null) {
          ensureHeadersIsMutable();
          headers_.remove(index);
          onChanged();
        } else {
          headersBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder getHeadersBuilder(
          int index) {
        return getHeadersFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder getHeadersOrBuilder(
          int index) {
        if (headersBuilder_ == null) {
          return headers_.get(index);  } else {
          return headersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder> 
           getHeadersOrBuilderList() {
        if (headersBuilder_ != null) {
          return headersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(headers_);
        }
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder addHeadersBuilder() {
        return getHeadersFieldBuilder().addBuilder(
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.getDefaultInstance());
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder addHeadersBuilder(
          int index) {
        return getHeadersFieldBuilder().addBuilder(
            index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.getDefaultInstance());
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder> 
           getHeadersBuilderList() {
        return getHeadersFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder> 
          getHeadersFieldBuilder() {
        if (headersBuilder_ == null) {
          headersBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder>(
                  headers_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          headers_ = null;
        }
        return headersBuilder_;
      }

      private int type_ = 1;
      /**
       * <pre>
       * The type of the signed credential URI (e.g., an AWS presigned URL
       * or an Azure Shared Access Signature URI)
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override public boolean hasType() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * The type of the signed credential URI (e.g., an AWS presigned URL
       * or an Azure Shared Access Signature URI)
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
       * @return The type.
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType getType() {
        @SuppressWarnings("deprecation")
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType result = com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType.valueOf(type_);
        return result == null ? com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType.AZURE_SAS_URI : result;
      }
      /**
       * <pre>
       * The type of the signed credential URI (e.g., an AWS presigned URL
       * or an Azure Shared Access Signature URI)
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The type of the signed credential URI (e.g., an AWS presigned URL
       * or an Azure Shared Access Signature URI)
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000010);
        type_ = 1;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:mlflow.ArtifactCredentialInfo)
    }

    // @@protoc_insertion_point(class_scope:mlflow.ArtifactCredentialInfo)
    private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo();
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<ArtifactCredentialInfo>
        PARSER = new com.google.protobuf.AbstractParser<ArtifactCredentialInfo>() {
      @java.lang.Override
      public ArtifactCredentialInfo parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ArtifactCredentialInfo(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ArtifactCredentialInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ArtifactCredentialInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetCredentialsForReadOrBuilder extends
      // @@protoc_insertion_point(interface_extends:mlflow.GetCredentialsForRead)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return Whether the runId field is set.
     */
    boolean hasRunId();
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The runId.
     */
    java.lang.String getRunId();
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for runId.
     */
    com.google.protobuf.ByteString
        getRunIdBytes();

    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @return A list containing the path.
     */
    java.util.List<java.lang.String>
        getPathList();
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @return The count of path.
     */
    int getPathCount();
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @param index The index of the element to return.
     * @return The path at the given index.
     */
    java.lang.String getPath(int index);
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the path at the given index.
     */
    com.google.protobuf.ByteString
        getPathBytes(int index);

    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return Whether the pageToken field is set.
     */
    boolean hasPageToken();
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return The pageToken.
     */
    java.lang.String getPageToken();
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return The bytes for pageToken.
     */
    com.google.protobuf.ByteString
        getPageTokenBytes();
  }
  /**
   * Protobuf type {@code mlflow.GetCredentialsForRead}
   */
  public static final class GetCredentialsForRead extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:mlflow.GetCredentialsForRead)
      GetCredentialsForReadOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetCredentialsForRead.newBuilder() to construct.
    private GetCredentialsForRead(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetCredentialsForRead() {
      runId_ = "";
      path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      pageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetCredentialsForRead();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private GetCredentialsForRead(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              runId_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                path_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              path_.add(bs);
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              pageToken_ = bs;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          path_ = path_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Builder.class);
    }

    public interface ResponseOrBuilder extends
        // @@protoc_insertion_point(interface_extends:mlflow.GetCredentialsForRead.Response)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> 
          getCredentialInfosList();
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index);
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      int getCredentialInfosCount();
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
          getCredentialInfosOrBuilderList();
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
          int index);

      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return Whether the nextPageToken field is set.
       */
      boolean hasNextPageToken();
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return The nextPageToken.
       */
      java.lang.String getNextPageToken();
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return The bytes for nextPageToken.
       */
      com.google.protobuf.ByteString
          getNextPageTokenBytes();
    }
    /**
     * Protobuf type {@code mlflow.GetCredentialsForRead.Response}
     */
    public static final class Response extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:mlflow.GetCredentialsForRead.Response)
        ResponseOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Response.newBuilder() to construct.
      private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Response() {
        credentialInfos_ = java.util.Collections.emptyList();
        nextPageToken_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Response();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Response(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18: {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  credentialInfos_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo>();
                  mutable_bitField0_ |= 0x00000001;
                }
                credentialInfos_.add(
                    input.readMessage(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.PARSER, extensionRegistry));
                break;
              }
              case 26: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                nextPageToken_ = bs;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            credentialInfos_ = java.util.Collections.unmodifiableList(credentialInfos_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_Response_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.Builder.class);
      }

      private int bitField0_;
      public static final int CREDENTIAL_INFOS_FIELD_NUMBER = 2;
      private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> credentialInfos_;
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      @java.lang.Override
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> getCredentialInfosList() {
        return credentialInfos_;
      }
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
          getCredentialInfosOrBuilderList() {
        return credentialInfos_;
      }
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      @java.lang.Override
      public int getCredentialInfosCount() {
        return credentialInfos_.size();
      }
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index) {
        return credentialInfos_.get(index);
      }
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
          int index) {
        return credentialInfos_.get(index);
      }

      public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;
      private volatile java.lang.Object nextPageToken_;
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return Whether the nextPageToken field is set.
       */
      @java.lang.Override
      public boolean hasNextPageToken() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return The nextPageToken.
       */
      @java.lang.Override
      public java.lang.String getNextPageToken() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            nextPageToken_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return The bytes for nextPageToken.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getNextPageTokenBytes() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          nextPageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        for (int i = 0; i < credentialInfos_.size(); i++) {
          output.writeMessage(2, credentialInfos_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < credentialInfos_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, credentialInfos_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response)) {
          return super.equals(obj);
        }
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response) obj;

        if (!getCredentialInfosList()
            .equals(other.getCredentialInfosList())) return false;
        if (hasNextPageToken() != other.hasNextPageToken()) return false;
        if (hasNextPageToken()) {
          if (!getNextPageToken()
              .equals(other.getNextPageToken())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getCredentialInfosCount() > 0) {
          hash = (37 * hash) + CREDENTIAL_INFOS_FIELD_NUMBER;
          hash = (53 * hash) + getCredentialInfosList().hashCode();
        }
        if (hasNextPageToken()) {
          hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
          hash = (53 * hash) + getNextPageToken().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code mlflow.GetCredentialsForRead.Response}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:mlflow.GetCredentialsForRead.Response)
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.ResponseOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_Response_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_Response_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.Builder.class);
        }

        // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getCredentialInfosFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (credentialInfosBuilder_ == null) {
            credentialInfos_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            credentialInfosBuilder_.clear();
          }
          nextPageToken_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_Response_descriptor;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response getDefaultInstanceForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.getDefaultInstance();
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response build() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response buildPartial() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (credentialInfosBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              credentialInfos_ = java.util.Collections.unmodifiableList(credentialInfos_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.credentialInfos_ = credentialInfos_;
          } else {
            result.credentialInfos_ = credentialInfosBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000001;
          }
          result.nextPageToken_ = nextPageToken_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response) {
            return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response other) {
          if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.getDefaultInstance()) return this;
          if (credentialInfosBuilder_ == null) {
            if (!other.credentialInfos_.isEmpty()) {
              if (credentialInfos_.isEmpty()) {
                credentialInfos_ = other.credentialInfos_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureCredentialInfosIsMutable();
                credentialInfos_.addAll(other.credentialInfos_);
              }
              onChanged();
            }
          } else {
            if (!other.credentialInfos_.isEmpty()) {
              if (credentialInfosBuilder_.isEmpty()) {
                credentialInfosBuilder_.dispose();
                credentialInfosBuilder_ = null;
                credentialInfos_ = other.credentialInfos_;
                bitField0_ = (bitField0_ & ~0x00000001);
                credentialInfosBuilder_ = 
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getCredentialInfosFieldBuilder() : null;
              } else {
                credentialInfosBuilder_.addAllMessages(other.credentialInfos_);
              }
            }
          }
          if (other.hasNextPageToken()) {
            bitField0_ |= 0x00000002;
            nextPageToken_ = other.nextPageToken_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> credentialInfos_ =
          java.util.Collections.emptyList();
        private void ensureCredentialInfosIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            credentialInfos_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo>(credentialInfos_);
            bitField0_ |= 0x00000001;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> credentialInfosBuilder_;

        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> getCredentialInfosList() {
          if (credentialInfosBuilder_ == null) {
            return java.util.Collections.unmodifiableList(credentialInfos_);
          } else {
            return credentialInfosBuilder_.getMessageList();
          }
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public int getCredentialInfosCount() {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.size();
          } else {
            return credentialInfosBuilder_.getCount();
          }
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index) {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.get(index);
          } else {
            return credentialInfosBuilder_.getMessage(index);
          }
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder setCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.set(index, value);
            onChanged();
          } else {
            credentialInfosBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder setCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.set(index, builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(value);
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(index, value);
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(index, builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addAllCredentialInfos(
            java.lang.Iterable<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> values) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, credentialInfos_);
            onChanged();
          } else {
            credentialInfosBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder clearCredentialInfos() {
          if (credentialInfosBuilder_ == null) {
            credentialInfos_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            credentialInfosBuilder_.clear();
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder removeCredentialInfos(int index) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.remove(index);
            onChanged();
          } else {
            credentialInfosBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder getCredentialInfosBuilder(
            int index) {
          return getCredentialInfosFieldBuilder().getBuilder(index);
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
            int index) {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.get(index);  } else {
            return credentialInfosBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
             getCredentialInfosOrBuilderList() {
          if (credentialInfosBuilder_ != null) {
            return credentialInfosBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(credentialInfos_);
          }
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder addCredentialInfosBuilder() {
          return getCredentialInfosFieldBuilder().addBuilder(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance());
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder addCredentialInfosBuilder(
            int index) {
          return getCredentialInfosFieldBuilder().addBuilder(
              index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance());
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder> 
             getCredentialInfosBuilderList() {
          return getCredentialInfosFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
            getCredentialInfosFieldBuilder() {
          if (credentialInfosBuilder_ == null) {
            credentialInfosBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder>(
                    credentialInfos_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            credentialInfos_ = null;
          }
          return credentialInfosBuilder_;
        }

        private java.lang.Object nextPageToken_ = "";
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @return Whether the nextPageToken field is set.
         */
        public boolean hasNextPageToken() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @return The nextPageToken.
         */
        public java.lang.String getNextPageToken() {
          java.lang.Object ref = nextPageToken_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              nextPageToken_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @return The bytes for nextPageToken.
         */
        public com.google.protobuf.ByteString
            getNextPageTokenBytes() {
          java.lang.Object ref = nextPageToken_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            nextPageToken_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @param value The nextPageToken to set.
         * @return This builder for chaining.
         */
        public Builder setNextPageToken(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          nextPageToken_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearNextPageToken() {
          bitField0_ = (bitField0_ & ~0x00000002);
          nextPageToken_ = getDefaultInstance().getNextPageToken();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @param value The bytes for nextPageToken to set.
         * @return This builder for chaining.
         */
        public Builder setNextPageTokenBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          nextPageToken_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:mlflow.GetCredentialsForRead.Response)
      }

      // @@protoc_insertion_point(class_scope:mlflow.GetCredentialsForRead.Response)
      private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response();
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Response>
          PARSER = new com.google.protobuf.AbstractParser<Response>() {
        @java.lang.Override
        public Response parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Response(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Response> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Response> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int RUN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object runId_;
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return Whether the runId field is set.
     */
    @java.lang.Override
    public boolean hasRunId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The runId.
     */
    @java.lang.Override
    public java.lang.String getRunId() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          runId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for runId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getRunIdBytes() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        runId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList path_;
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @return A list containing the path.
     */
    public com.google.protobuf.ProtocolStringList
        getPathList() {
      return path_;
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @return The count of path.
     */
    public int getPathCount() {
      return path_.size();
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @param index The index of the element to return.
     * @return The path at the given index.
     */
    public java.lang.String getPath(int index) {
      return path_.get(index);
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the path at the given index.
     */
    public com.google.protobuf.ByteString
        getPathBytes(int index) {
      return path_.getByteString(index);
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 3;
    private volatile java.lang.Object pageToken_;
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return Whether the pageToken field is set.
     */
    @java.lang.Override
    public boolean hasPageToken() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return The pageToken.
     */
    @java.lang.Override
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          pageToken_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return The bytes for pageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, runId_);
      }
      for (int i = 0; i < path_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_.getRaw(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, runId_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < path_.size(); i++) {
          dataSize += computeStringSizeNoTag(path_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPathList().size();
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead)) {
        return super.equals(obj);
      }
      com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead) obj;

      if (hasRunId() != other.hasRunId()) return false;
      if (hasRunId()) {
        if (!getRunId()
            .equals(other.getRunId())) return false;
      }
      if (!getPathList()
          .equals(other.getPathList())) return false;
      if (hasPageToken() != other.hasPageToken()) return false;
      if (hasPageToken()) {
        if (!getPageToken()
            .equals(other.getPageToken())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRunId()) {
        hash = (37 * hash) + RUN_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRunId().hashCode();
      }
      if (getPathCount() > 0) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPathList().hashCode();
      }
      if (hasPageToken()) {
        hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getPageToken().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code mlflow.GetCredentialsForRead}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:mlflow.GetCredentialsForRead)
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForReadOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Builder.class);
      }

      // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        runId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        pageToken_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_descriptor;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead getDefaultInstanceForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.getDefaultInstance();
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead build() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead buildPartial() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.runId_ = runId_;
        if (((bitField0_ & 0x00000002) != 0)) {
          path_ = path_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.path_ = path_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.pageToken_ = pageToken_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead) {
          return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead other) {
        if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.getDefaultInstance()) return this;
        if (other.hasRunId()) {
          bitField0_ |= 0x00000001;
          runId_ = other.runId_;
          onChanged();
        }
        if (!other.path_.isEmpty()) {
          if (path_.isEmpty()) {
            path_ = other.path_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePathIsMutable();
            path_.addAll(other.path_);
          }
          onChanged();
        }
        if (other.hasPageToken()) {
          bitField0_ |= 0x00000004;
          pageToken_ = other.pageToken_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object runId_ = "";
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return Whether the runId field is set.
       */
      public boolean hasRunId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return The runId.
       */
      public java.lang.String getRunId() {
        java.lang.Object ref = runId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            runId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return The bytes for runId.
       */
      public com.google.protobuf.ByteString
          getRunIdBytes() {
        java.lang.Object ref = runId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          runId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @param value The runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearRunId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        runId_ = getDefaultInstance().getRunId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @param value The bytes for runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensurePathIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          path_ = new com.google.protobuf.LazyStringArrayList(path_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @return A list containing the path.
       */
      public com.google.protobuf.ProtocolStringList
          getPathList() {
        return path_.getUnmodifiableView();
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @return The count of path.
       */
      public int getPathCount() {
        return path_.size();
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param index The index of the element to return.
       * @return The path at the given index.
       */
      public java.lang.String getPath(int index) {
        return path_.get(index);
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param index The index of the value to return.
       * @return The bytes of the path at the given index.
       */
      public com.google.protobuf.ByteString
          getPathBytes(int index) {
        return path_.getByteString(index);
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param index The index to set the value at.
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param value The path to add.
       * @return This builder for chaining.
       */
      public Builder addPath(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param values The path to add.
       * @return This builder for chaining.
       */
      public Builder addAllPath(
          java.lang.Iterable<java.lang.String> values) {
        ensurePathIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, path_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param value The bytes of the path to add.
       * @return This builder for chaining.
       */
      public Builder addPathBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object pageToken_ = "";
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @return Whether the pageToken field is set.
       */
      public boolean hasPageToken() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @return The pageToken.
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            pageToken_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @return The bytes for pageToken.
       */
      public com.google.protobuf.ByteString
          getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @param value The pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageToken(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        pageToken_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearPageToken() {
        bitField0_ = (bitField0_ & ~0x00000004);
        pageToken_ = getDefaultInstance().getPageToken();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @param value The bytes for pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageTokenBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        pageToken_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:mlflow.GetCredentialsForRead)
    }

    // @@protoc_insertion_point(class_scope:mlflow.GetCredentialsForRead)
    private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead();
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetCredentialsForRead>
        PARSER = new com.google.protobuf.AbstractParser<GetCredentialsForRead>() {
      @java.lang.Override
      public GetCredentialsForRead parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetCredentialsForRead(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<GetCredentialsForRead> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetCredentialsForRead> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetCredentialsForWriteOrBuilder extends
      // @@protoc_insertion_point(interface_extends:mlflow.GetCredentialsForWrite)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return Whether the runId field is set.
     */
    boolean hasRunId();
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The runId.
     */
    java.lang.String getRunId();
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for runId.
     */
    com.google.protobuf.ByteString
        getRunIdBytes();

    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @return A list containing the path.
     */
    java.util.List<java.lang.String>
        getPathList();
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @return The count of path.
     */
    int getPathCount();
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @param index The index of the element to return.
     * @return The path at the given index.
     */
    java.lang.String getPath(int index);
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the path at the given index.
     */
    com.google.protobuf.ByteString
        getPathBytes(int index);

    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return Whether the pageToken field is set.
     */
    boolean hasPageToken();
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return The pageToken.
     */
    java.lang.String getPageToken();
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return The bytes for pageToken.
     */
    com.google.protobuf.ByteString
        getPageTokenBytes();
  }
  /**
   * Protobuf type {@code mlflow.GetCredentialsForWrite}
   */
  public static final class GetCredentialsForWrite extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:mlflow.GetCredentialsForWrite)
      GetCredentialsForWriteOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetCredentialsForWrite.newBuilder() to construct.
    private GetCredentialsForWrite(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetCredentialsForWrite() {
      runId_ = "";
      path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      pageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetCredentialsForWrite();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private GetCredentialsForWrite(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              runId_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                path_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              path_.add(bs);
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              pageToken_ = bs;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          path_ = path_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Builder.class);
    }

    public interface ResponseOrBuilder extends
        // @@protoc_insertion_point(interface_extends:mlflow.GetCredentialsForWrite.Response)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> 
          getCredentialInfosList();
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index);
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      int getCredentialInfosCount();
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
          getCredentialInfosOrBuilderList();
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
          int index);

      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return Whether the nextPageToken field is set.
       */
      boolean hasNextPageToken();
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return The nextPageToken.
       */
      java.lang.String getNextPageToken();
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return The bytes for nextPageToken.
       */
      com.google.protobuf.ByteString
          getNextPageTokenBytes();
    }
    /**
     * Protobuf type {@code mlflow.GetCredentialsForWrite.Response}
     */
    public static final class Response extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:mlflow.GetCredentialsForWrite.Response)
        ResponseOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Response.newBuilder() to construct.
      private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Response() {
        credentialInfos_ = java.util.Collections.emptyList();
        nextPageToken_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Response();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Response(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18: {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  credentialInfos_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo>();
                  mutable_bitField0_ |= 0x00000001;
                }
                credentialInfos_.add(
                    input.readMessage(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.PARSER, extensionRegistry));
                break;
              }
              case 26: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                nextPageToken_ = bs;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) != 0)) {
            credentialInfos_ = java.util.Collections.unmodifiableList(credentialInfos_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_Response_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.Builder.class);
      }

      private int bitField0_;
      public static final int CREDENTIAL_INFOS_FIELD_NUMBER = 2;
      private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> credentialInfos_;
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      @java.lang.Override
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> getCredentialInfosList() {
        return credentialInfos_;
      }
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
          getCredentialInfosOrBuilderList() {
        return credentialInfos_;
      }
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      @java.lang.Override
      public int getCredentialInfosCount() {
        return credentialInfos_.size();
      }
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index) {
        return credentialInfos_.get(index);
      }
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
          int index) {
        return credentialInfos_.get(index);
      }

      public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;
      private volatile java.lang.Object nextPageToken_;
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return Whether the nextPageToken field is set.
       */
      @java.lang.Override
      public boolean hasNextPageToken() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return The nextPageToken.
       */
      @java.lang.Override
      public java.lang.String getNextPageToken() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            nextPageToken_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       * @return The bytes for nextPageToken.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getNextPageTokenBytes() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          nextPageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        for (int i = 0; i < credentialInfos_.size(); i++) {
          output.writeMessage(2, credentialInfos_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < credentialInfos_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, credentialInfos_.get(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response)) {
          return super.equals(obj);
        }
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response) obj;

        if (!getCredentialInfosList()
            .equals(other.getCredentialInfosList())) return false;
        if (hasNextPageToken() != other.hasNextPageToken()) return false;
        if (hasNextPageToken()) {
          if (!getNextPageToken()
              .equals(other.getNextPageToken())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getCredentialInfosCount() > 0) {
          hash = (37 * hash) + CREDENTIAL_INFOS_FIELD_NUMBER;
          hash = (53 * hash) + getCredentialInfosList().hashCode();
        }
        if (hasNextPageToken()) {
          hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
          hash = (53 * hash) + getNextPageToken().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code mlflow.GetCredentialsForWrite.Response}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:mlflow.GetCredentialsForWrite.Response)
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.ResponseOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_Response_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_Response_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.Builder.class);
        }

        // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getCredentialInfosFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (credentialInfosBuilder_ == null) {
            credentialInfos_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            credentialInfosBuilder_.clear();
          }
          nextPageToken_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_Response_descriptor;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response getDefaultInstanceForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.getDefaultInstance();
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response build() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response buildPartial() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (credentialInfosBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              credentialInfos_ = java.util.Collections.unmodifiableList(credentialInfos_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.credentialInfos_ = credentialInfos_;
          } else {
            result.credentialInfos_ = credentialInfosBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000001;
          }
          result.nextPageToken_ = nextPageToken_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response) {
            return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response other) {
          if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.getDefaultInstance()) return this;
          if (credentialInfosBuilder_ == null) {
            if (!other.credentialInfos_.isEmpty()) {
              if (credentialInfos_.isEmpty()) {
                credentialInfos_ = other.credentialInfos_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureCredentialInfosIsMutable();
                credentialInfos_.addAll(other.credentialInfos_);
              }
              onChanged();
            }
          } else {
            if (!other.credentialInfos_.isEmpty()) {
              if (credentialInfosBuilder_.isEmpty()) {
                credentialInfosBuilder_.dispose();
                credentialInfosBuilder_ = null;
                credentialInfos_ = other.credentialInfos_;
                bitField0_ = (bitField0_ & ~0x00000001);
                credentialInfosBuilder_ = 
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getCredentialInfosFieldBuilder() : null;
              } else {
                credentialInfosBuilder_.addAllMessages(other.credentialInfos_);
              }
            }
          }
          if (other.hasNextPageToken()) {
            bitField0_ |= 0x00000002;
            nextPageToken_ = other.nextPageToken_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> credentialInfos_ =
          java.util.Collections.emptyList();
        private void ensureCredentialInfosIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            credentialInfos_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo>(credentialInfos_);
            bitField0_ |= 0x00000001;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> credentialInfosBuilder_;

        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> getCredentialInfosList() {
          if (credentialInfosBuilder_ == null) {
            return java.util.Collections.unmodifiableList(credentialInfos_);
          } else {
            return credentialInfosBuilder_.getMessageList();
          }
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public int getCredentialInfosCount() {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.size();
          } else {
            return credentialInfosBuilder_.getCount();
          }
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index) {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.get(index);
          } else {
            return credentialInfosBuilder_.getMessage(index);
          }
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder setCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.set(index, value);
            onChanged();
          } else {
            credentialInfosBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder setCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.set(index, builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(value);
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(index, value);
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(index, builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addAllCredentialInfos(
            java.lang.Iterable<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> values) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, credentialInfos_);
            onChanged();
          } else {
            credentialInfosBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder clearCredentialInfos() {
          if (credentialInfosBuilder_ == null) {
            credentialInfos_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            credentialInfosBuilder_.clear();
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder removeCredentialInfos(int index) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.remove(index);
            onChanged();
          } else {
            credentialInfosBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder getCredentialInfosBuilder(
            int index) {
          return getCredentialInfosFieldBuilder().getBuilder(index);
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
            int index) {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.get(index);  } else {
            return credentialInfosBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
             getCredentialInfosOrBuilderList() {
          if (credentialInfosBuilder_ != null) {
            return credentialInfosBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(credentialInfos_);
          }
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder addCredentialInfosBuilder() {
          return getCredentialInfosFieldBuilder().addBuilder(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance());
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder addCredentialInfosBuilder(
            int index) {
          return getCredentialInfosFieldBuilder().addBuilder(
              index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance());
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder> 
             getCredentialInfosBuilderList() {
          return getCredentialInfosFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
            getCredentialInfosFieldBuilder() {
          if (credentialInfosBuilder_ == null) {
            credentialInfosBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder>(
                    credentialInfos_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            credentialInfos_ = null;
          }
          return credentialInfosBuilder_;
        }

        private java.lang.Object nextPageToken_ = "";
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @return Whether the nextPageToken field is set.
         */
        public boolean hasNextPageToken() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @return The nextPageToken.
         */
        public java.lang.String getNextPageToken() {
          java.lang.Object ref = nextPageToken_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              nextPageToken_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @return The bytes for nextPageToken.
         */
        public com.google.protobuf.ByteString
            getNextPageTokenBytes() {
          java.lang.Object ref = nextPageToken_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            nextPageToken_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @param value The nextPageToken to set.
         * @return This builder for chaining.
         */
        public Builder setNextPageToken(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          nextPageToken_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearNextPageToken() {
          bitField0_ = (bitField0_ & ~0x00000002);
          nextPageToken_ = getDefaultInstance().getNextPageToken();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         * @param value The bytes for nextPageToken to set.
         * @return This builder for chaining.
         */
        public Builder setNextPageTokenBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          nextPageToken_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:mlflow.GetCredentialsForWrite.Response)
      }

      // @@protoc_insertion_point(class_scope:mlflow.GetCredentialsForWrite.Response)
      private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response();
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Response>
          PARSER = new com.google.protobuf.AbstractParser<Response>() {
        @java.lang.Override
        public Response parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Response(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Response> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Response> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int RUN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object runId_;
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return Whether the runId field is set.
     */
    @java.lang.Override
    public boolean hasRunId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The runId.
     */
    @java.lang.Override
    public java.lang.String getRunId() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          runId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for runId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getRunIdBytes() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        runId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList path_;
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @return A list containing the path.
     */
    public com.google.protobuf.ProtocolStringList
        getPathList() {
      return path_;
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @return The count of path.
     */
    public int getPathCount() {
      return path_.size();
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @param index The index of the element to return.
     * @return The path at the given index.
     */
    public java.lang.String getPath(int index) {
      return path_.get(index);
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     * @param index The index of the value to return.
     * @return The bytes of the path at the given index.
     */
    public com.google.protobuf.ByteString
        getPathBytes(int index) {
      return path_.getByteString(index);
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 3;
    private volatile java.lang.Object pageToken_;
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return Whether the pageToken field is set.
     */
    @java.lang.Override
    public boolean hasPageToken() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return The pageToken.
     */
    @java.lang.Override
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          pageToken_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     * @return The bytes for pageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, runId_);
      }
      for (int i = 0; i < path_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_.getRaw(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, runId_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < path_.size(); i++) {
          dataSize += computeStringSizeNoTag(path_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPathList().size();
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite)) {
        return super.equals(obj);
      }
      com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite) obj;

      if (hasRunId() != other.hasRunId()) return false;
      if (hasRunId()) {
        if (!getRunId()
            .equals(other.getRunId())) return false;
      }
      if (!getPathList()
          .equals(other.getPathList())) return false;
      if (hasPageToken() != other.hasPageToken()) return false;
      if (hasPageToken()) {
        if (!getPageToken()
            .equals(other.getPageToken())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRunId()) {
        hash = (37 * hash) + RUN_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRunId().hashCode();
      }
      if (getPathCount() > 0) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPathList().hashCode();
      }
      if (hasPageToken()) {
        hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getPageToken().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code mlflow.GetCredentialsForWrite}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:mlflow.GetCredentialsForWrite)
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWriteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Builder.class);
      }

      // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        runId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        pageToken_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_descriptor;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite getDefaultInstanceForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.getDefaultInstance();
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite build() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite buildPartial() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.runId_ = runId_;
        if (((bitField0_ & 0x00000002) != 0)) {
          path_ = path_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.path_ = path_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.pageToken_ = pageToken_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite) {
          return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite other) {
        if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.getDefaultInstance()) return this;
        if (other.hasRunId()) {
          bitField0_ |= 0x00000001;
          runId_ = other.runId_;
          onChanged();
        }
        if (!other.path_.isEmpty()) {
          if (path_.isEmpty()) {
            path_ = other.path_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePathIsMutable();
            path_.addAll(other.path_);
          }
          onChanged();
        }
        if (other.hasPageToken()) {
          bitField0_ |= 0x00000004;
          pageToken_ = other.pageToken_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object runId_ = "";
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return Whether the runId field is set.
       */
      public boolean hasRunId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return The runId.
       */
      public java.lang.String getRunId() {
        java.lang.Object ref = runId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            runId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return The bytes for runId.
       */
      public com.google.protobuf.ByteString
          getRunIdBytes() {
        java.lang.Object ref = runId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          runId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @param value The runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearRunId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        runId_ = getDefaultInstance().getRunId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @param value The bytes for runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensurePathIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          path_ = new com.google.protobuf.LazyStringArrayList(path_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @return A list containing the path.
       */
      public com.google.protobuf.ProtocolStringList
          getPathList() {
        return path_.getUnmodifiableView();
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @return The count of path.
       */
      public int getPathCount() {
        return path_.size();
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param index The index of the element to return.
       * @return The path at the given index.
       */
      public java.lang.String getPath(int index) {
        return path_.get(index);
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param index The index of the value to return.
       * @return The bytes of the path at the given index.
       */
      public com.google.protobuf.ByteString
          getPathBytes(int index) {
        return path_.getByteString(index);
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param index The index to set the value at.
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param value The path to add.
       * @return This builder for chaining.
       */
      public Builder addPath(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param values The path to add.
       * @return This builder for chaining.
       */
      public Builder addAllPath(
          java.lang.Iterable<java.lang.String> values) {
        ensurePathIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, path_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       * @param value The bytes of the path to add.
       * @return This builder for chaining.
       */
      public Builder addPathBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object pageToken_ = "";
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @return Whether the pageToken field is set.
       */
      public boolean hasPageToken() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @return The pageToken.
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            pageToken_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @return The bytes for pageToken.
       */
      public com.google.protobuf.ByteString
          getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @param value The pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageToken(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        pageToken_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearPageToken() {
        bitField0_ = (bitField0_ & ~0x00000004);
        pageToken_ = getDefaultInstance().getPageToken();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       * @param value The bytes for pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageTokenBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        pageToken_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:mlflow.GetCredentialsForWrite)
    }

    // @@protoc_insertion_point(class_scope:mlflow.GetCredentialsForWrite)
    private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite();
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetCredentialsForWrite>
        PARSER = new com.google.protobuf.AbstractParser<GetCredentialsForWrite>() {
      @java.lang.Override
      public GetCredentialsForWrite parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetCredentialsForWrite(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<GetCredentialsForWrite> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetCredentialsForWrite> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CreateMultipartUploadOrBuilder extends
      // @@protoc_insertion_point(interface_extends:mlflow.CreateMultipartUpload)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return Whether the runId field is set.
     */
    boolean hasRunId();
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The runId.
     */
    java.lang.String getRunId();
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for runId.
     */
    com.google.protobuf.ByteString
        getRunIdBytes();

    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The path.
     */
    java.lang.String getPath();
    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString
        getPathBytes();

    /**
     * <pre>
     * Number of file parts (chunks of data) to upload in the initiated multipart upload
     * </pre>
     *
     * <code>optional int64 num_parts = 3 [(.mlflow.validate_required) = true];</code>
     * @return Whether the numParts field is set.
     */
    boolean hasNumParts();
    /**
     * <pre>
     * Number of file parts (chunks of data) to upload in the initiated multipart upload
     * </pre>
     *
     * <code>optional int64 num_parts = 3 [(.mlflow.validate_required) = true];</code>
     * @return The numParts.
     */
    long getNumParts();
  }
  /**
   * Protobuf type {@code mlflow.CreateMultipartUpload}
   */
  public static final class CreateMultipartUpload extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:mlflow.CreateMultipartUpload)
      CreateMultipartUploadOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use CreateMultipartUpload.newBuilder() to construct.
    private CreateMultipartUpload(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private CreateMultipartUpload() {
      runId_ = "";
      path_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new CreateMultipartUpload();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private CreateMultipartUpload(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              runId_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              path_ = bs;
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              numParts_ = input.readInt64();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CreateMultipartUpload_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CreateMultipartUpload_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Builder.class);
    }

    public interface ResponseOrBuilder extends
        // @@protoc_insertion_point(interface_extends:mlflow.CreateMultipartUpload.Response)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * ID identifying the initiated multipart upload
       * </pre>
       *
       * <code>optional string upload_id = 1;</code>
       * @return Whether the uploadId field is set.
       */
      boolean hasUploadId();
      /**
       * <pre>
       * ID identifying the initiated multipart upload
       * </pre>
       *
       * <code>optional string upload_id = 1;</code>
       * @return The uploadId.
       */
      java.lang.String getUploadId();
      /**
       * <pre>
       * ID identifying the initiated multipart upload
       * </pre>
       *
       * <code>optional string upload_id = 1;</code>
       * @return The bytes for uploadId.
       */
      com.google.protobuf.ByteString
          getUploadIdBytes();

      /**
       * <pre>
       * Credentials for uploading file parts in the initiated multipart upload
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
       */
      java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> 
          getUploadCredentialInfosList();
      /**
       * <pre>
       * Credentials for uploading file parts in the initiated multipart upload
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getUploadCredentialInfos(int index);
      /**
       * <pre>
       * Credentials for uploading file parts in the initiated multipart upload
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
       */
      int getUploadCredentialInfosCount();
      /**
       * <pre>
       * Credentials for uploading file parts in the initiated multipart upload
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
       */
      java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
          getUploadCredentialInfosOrBuilderList();
      /**
       * <pre>
       * Credentials for uploading file parts in the initiated multipart upload
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getUploadCredentialInfosOrBuilder(
          int index);

      /**
       * <pre>
       * Credential for aborting the initiated multipart upload
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
       * @return Whether the abortCredentialInfo field is set.
       */
      boolean hasAbortCredentialInfo();
      /**
       * <pre>
       * Credential for aborting the initiated multipart upload
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
       * @return The abortCredentialInfo.
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getAbortCredentialInfo();
      /**
       * <pre>
       * Credential for aborting the initiated multipart upload
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getAbortCredentialInfoOrBuilder();
    }
    /**
     * Protobuf type {@code mlflow.CreateMultipartUpload.Response}
     */
    public static final class Response extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:mlflow.CreateMultipartUpload.Response)
        ResponseOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Response.newBuilder() to construct.
      private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Response() {
        uploadId_ = "";
        uploadCredentialInfos_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Response();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Response(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                uploadId_ = bs;
                break;
              }
              case 18: {
                if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                  uploadCredentialInfos_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo>();
                  mutable_bitField0_ |= 0x00000002;
                }
                uploadCredentialInfos_.add(
                    input.readMessage(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.PARSER, extensionRegistry));
                break;
              }
              case 26: {
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) != 0)) {
                  subBuilder = abortCredentialInfo_.toBuilder();
                }
                abortCredentialInfo_ = input.readMessage(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(abortCredentialInfo_);
                  abortCredentialInfo_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000002) != 0)) {
            uploadCredentialInfos_ = java.util.Collections.unmodifiableList(uploadCredentialInfos_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CreateMultipartUpload_Response_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CreateMultipartUpload_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response.Builder.class);
      }

      private int bitField0_;
      public static final int UPLOAD_ID_FIELD_NUMBER = 1;
      private volatile java.lang.Object uploadId_;
      /**
       * <pre>
       * ID identifying the initiated multipart upload
       * </pre>
       *
       * <code>optional string upload_id = 1;</code>
       * @return Whether the uploadId field is set.
       */
      @java.lang.Override
      public boolean hasUploadId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * ID identifying the initiated multipart upload
       * </pre>
       *
       * <code>optional string upload_id = 1;</code>
       * @return The uploadId.
       */
      @java.lang.Override
      public java.lang.String getUploadId() {
        java.lang.Object ref = uploadId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            uploadId_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * ID identifying the initiated multipart upload
       * </pre>
       *
       * <code>optional string upload_id = 1;</code>
       * @return The bytes for uploadId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getUploadIdBytes() {
        java.lang.Object ref = uploadId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          uploadId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int UPLOAD_CREDENTIAL_INFOS_FIELD_NUMBER = 2;
      private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> uploadCredentialInfos_;
      /**
       * <pre>
       * Credentials for uploading file parts in the initiated multipart upload
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
       */
      @java.lang.Override
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> getUploadCredentialInfosList() {
        return uploadCredentialInfos_;
      }
      /**
       * <pre>
       * Credentials for uploading file parts in the initiated multipart upload
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
       */
      @java.lang.Override
      public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
          getUploadCredentialInfosOrBuilderList() {
        return uploadCredentialInfos_;
      }
      /**
       * <pre>
       * Credentials for uploading file parts in the initiated multipart upload
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
       */
      @java.lang.Override
      public int getUploadCredentialInfosCount() {
        return uploadCredentialInfos_.size();
      }
      /**
       * <pre>
       * Credentials for uploading file parts in the initiated multipart upload
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getUploadCredentialInfos(int index) {
        return uploadCredentialInfos_.get(index);
      }
      /**
       * <pre>
       * Credentials for uploading file parts in the initiated multipart upload
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getUploadCredentialInfosOrBuilder(
          int index) {
        return uploadCredentialInfos_.get(index);
      }

      public static final int ABORT_CREDENTIAL_INFO_FIELD_NUMBER = 3;
      private com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo abortCredentialInfo_;
      /**
       * <pre>
       * Credential for aborting the initiated multipart upload
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
       * @return Whether the abortCredentialInfo field is set.
       */
      @java.lang.Override
      public boolean hasAbortCredentialInfo() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Credential for aborting the initiated multipart upload
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
       * @return The abortCredentialInfo.
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getAbortCredentialInfo() {
        return abortCredentialInfo_ == null ? com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance() : abortCredentialInfo_;
      }
      /**
       * <pre>
       * Credential for aborting the initiated multipart upload
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getAbortCredentialInfoOrBuilder() {
        return abortCredentialInfo_ == null ? com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance() : abortCredentialInfo_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uploadId_);
        }
        for (int i = 0; i < uploadCredentialInfos_.size(); i++) {
          output.writeMessage(2, uploadCredentialInfos_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(3, getAbortCredentialInfo());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uploadId_);
        }
        for (int i = 0; i < uploadCredentialInfos_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, uploadCredentialInfos_.get(i));
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(3, getAbortCredentialInfo());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response)) {
          return super.equals(obj);
        }
        com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response) obj;

        if (hasUploadId() != other.hasUploadId()) return false;
        if (hasUploadId()) {
          if (!getUploadId()
              .equals(other.getUploadId())) return false;
        }
        if (!getUploadCredentialInfosList()
            .equals(other.getUploadCredentialInfosList())) return false;
        if (hasAbortCredentialInfo() != other.hasAbortCredentialInfo()) return false;
        if (hasAbortCredentialInfo()) {
          if (!getAbortCredentialInfo()
              .equals(other.getAbortCredentialInfo())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasUploadId()) {
          hash = (37 * hash) + UPLOAD_ID_FIELD_NUMBER;
          hash = (53 * hash) + getUploadId().hashCode();
        }
        if (getUploadCredentialInfosCount() > 0) {
          hash = (37 * hash) + UPLOAD_CREDENTIAL_INFOS_FIELD_NUMBER;
          hash = (53 * hash) + getUploadCredentialInfosList().hashCode();
        }
        if (hasAbortCredentialInfo()) {
          hash = (37 * hash) + ABORT_CREDENTIAL_INFO_FIELD_NUMBER;
          hash = (53 * hash) + getAbortCredentialInfo().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code mlflow.CreateMultipartUpload.Response}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:mlflow.CreateMultipartUpload.Response)
          com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.ResponseOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CreateMultipartUpload_Response_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CreateMultipartUpload_Response_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response.Builder.class);
        }

        // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getUploadCredentialInfosFieldBuilder();
            getAbortCredentialInfoFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          uploadId_ = "";
          bitField0_ = (bitField0_ & ~0x00000001);
          if (uploadCredentialInfosBuilder_ == null) {
            uploadCredentialInfos_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            uploadCredentialInfosBuilder_.clear();
          }
          if (abortCredentialInfoBuilder_ == null) {
            abortCredentialInfo_ = null;
          } else {
            abortCredentialInfoBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CreateMultipartUpload_Response_descriptor;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response getDefaultInstanceForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response.getDefaultInstance();
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response build() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response buildPartial() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            to_bitField0_ |= 0x00000001;
          }
          result.uploadId_ = uploadId_;
          if (uploadCredentialInfosBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              uploadCredentialInfos_ = java.util.Collections.unmodifiableList(uploadCredentialInfos_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.uploadCredentialInfos_ = uploadCredentialInfos_;
          } else {
            result.uploadCredentialInfos_ = uploadCredentialInfosBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            if (abortCredentialInfoBuilder_ == null) {
              result.abortCredentialInfo_ = abortCredentialInfo_;
            } else {
              result.abortCredentialInfo_ = abortCredentialInfoBuilder_.build();
            }
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response) {
            return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response other) {
          if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response.getDefaultInstance()) return this;
          if (other.hasUploadId()) {
            bitField0_ |= 0x00000001;
            uploadId_ = other.uploadId_;
            onChanged();
          }
          if (uploadCredentialInfosBuilder_ == null) {
            if (!other.uploadCredentialInfos_.isEmpty()) {
              if (uploadCredentialInfos_.isEmpty()) {
                uploadCredentialInfos_ = other.uploadCredentialInfos_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureUploadCredentialInfosIsMutable();
                uploadCredentialInfos_.addAll(other.uploadCredentialInfos_);
              }
              onChanged();
            }
          } else {
            if (!other.uploadCredentialInfos_.isEmpty()) {
              if (uploadCredentialInfosBuilder_.isEmpty()) {
                uploadCredentialInfosBuilder_.dispose();
                uploadCredentialInfosBuilder_ = null;
                uploadCredentialInfos_ = other.uploadCredentialInfos_;
                bitField0_ = (bitField0_ & ~0x00000002);
                uploadCredentialInfosBuilder_ = 
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getUploadCredentialInfosFieldBuilder() : null;
              } else {
                uploadCredentialInfosBuilder_.addAllMessages(other.uploadCredentialInfos_);
              }
            }
          }
          if (other.hasAbortCredentialInfo()) {
            mergeAbortCredentialInfo(other.getAbortCredentialInfo());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.lang.Object uploadId_ = "";
        /**
         * <pre>
         * ID identifying the initiated multipart upload
         * </pre>
         *
         * <code>optional string upload_id = 1;</code>
         * @return Whether the uploadId field is set.
         */
        public boolean hasUploadId() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * ID identifying the initiated multipart upload
         * </pre>
         *
         * <code>optional string upload_id = 1;</code>
         * @return The uploadId.
         */
        public java.lang.String getUploadId() {
          java.lang.Object ref = uploadId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              uploadId_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * ID identifying the initiated multipart upload
         * </pre>
         *
         * <code>optional string upload_id = 1;</code>
         * @return The bytes for uploadId.
         */
        public com.google.protobuf.ByteString
            getUploadIdBytes() {
          java.lang.Object ref = uploadId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            uploadId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * ID identifying the initiated multipart upload
         * </pre>
         *
         * <code>optional string upload_id = 1;</code>
         * @param value The uploadId to set.
         * @return This builder for chaining.
         */
        public Builder setUploadId(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          uploadId_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * ID identifying the initiated multipart upload
         * </pre>
         *
         * <code>optional string upload_id = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearUploadId() {
          bitField0_ = (bitField0_ & ~0x00000001);
          uploadId_ = getDefaultInstance().getUploadId();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * ID identifying the initiated multipart upload
         * </pre>
         *
         * <code>optional string upload_id = 1;</code>
         * @param value The bytes for uploadId to set.
         * @return This builder for chaining.
         */
        public Builder setUploadIdBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          uploadId_ = value;
          onChanged();
          return this;
        }

        private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> uploadCredentialInfos_ =
          java.util.Collections.emptyList();
        private void ensureUploadCredentialInfosIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            uploadCredentialInfos_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo>(uploadCredentialInfos_);
            bitField0_ |= 0x00000002;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> uploadCredentialInfosBuilder_;

        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> getUploadCredentialInfosList() {
          if (uploadCredentialInfosBuilder_ == null) {
            return java.util.Collections.unmodifiableList(uploadCredentialInfos_);
          } else {
            return uploadCredentialInfosBuilder_.getMessageList();
          }
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public int getUploadCredentialInfosCount() {
          if (uploadCredentialInfosBuilder_ == null) {
            return uploadCredentialInfos_.size();
          } else {
            return uploadCredentialInfosBuilder_.getCount();
          }
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getUploadCredentialInfos(int index) {
          if (uploadCredentialInfosBuilder_ == null) {
            return uploadCredentialInfos_.get(index);
          } else {
            return uploadCredentialInfosBuilder_.getMessage(index);
          }
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public Builder setUploadCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (uploadCredentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureUploadCredentialInfosIsMutable();
            uploadCredentialInfos_.set(index, value);
            onChanged();
          } else {
            uploadCredentialInfosBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public Builder setUploadCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (uploadCredentialInfosBuilder_ == null) {
            ensureUploadCredentialInfosIsMutable();
            uploadCredentialInfos_.set(index, builderForValue.build());
            onChanged();
          } else {
            uploadCredentialInfosBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public Builder addUploadCredentialInfos(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (uploadCredentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureUploadCredentialInfosIsMutable();
            uploadCredentialInfos_.add(value);
            onChanged();
          } else {
            uploadCredentialInfosBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public Builder addUploadCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (uploadCredentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureUploadCredentialInfosIsMutable();
            uploadCredentialInfos_.add(index, value);
            onChanged();
          } else {
            uploadCredentialInfosBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public Builder addUploadCredentialInfos(
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (uploadCredentialInfosBuilder_ == null) {
            ensureUploadCredentialInfosIsMutable();
            uploadCredentialInfos_.add(builderForValue.build());
            onChanged();
          } else {
            uploadCredentialInfosBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public Builder addUploadCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (uploadCredentialInfosBuilder_ == null) {
            ensureUploadCredentialInfosIsMutable();
            uploadCredentialInfos_.add(index, builderForValue.build());
            onChanged();
          } else {
            uploadCredentialInfosBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public Builder addAllUploadCredentialInfos(
            java.lang.Iterable<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> values) {
          if (uploadCredentialInfosBuilder_ == null) {
            ensureUploadCredentialInfosIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, uploadCredentialInfos_);
            onChanged();
          } else {
            uploadCredentialInfosBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public Builder clearUploadCredentialInfos() {
          if (uploadCredentialInfosBuilder_ == null) {
            uploadCredentialInfos_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            uploadCredentialInfosBuilder_.clear();
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public Builder removeUploadCredentialInfos(int index) {
          if (uploadCredentialInfosBuilder_ == null) {
            ensureUploadCredentialInfosIsMutable();
            uploadCredentialInfos_.remove(index);
            onChanged();
          } else {
            uploadCredentialInfosBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder getUploadCredentialInfosBuilder(
            int index) {
          return getUploadCredentialInfosFieldBuilder().getBuilder(index);
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getUploadCredentialInfosOrBuilder(
            int index) {
          if (uploadCredentialInfosBuilder_ == null) {
            return uploadCredentialInfos_.get(index);  } else {
            return uploadCredentialInfosBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
             getUploadCredentialInfosOrBuilderList() {
          if (uploadCredentialInfosBuilder_ != null) {
            return uploadCredentialInfosBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(uploadCredentialInfos_);
          }
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder addUploadCredentialInfosBuilder() {
          return getUploadCredentialInfosFieldBuilder().addBuilder(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance());
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder addUploadCredentialInfosBuilder(
            int index) {
          return getUploadCredentialInfosFieldBuilder().addBuilder(
              index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance());
        }
        /**
         * <pre>
         * Credentials for uploading file parts in the initiated multipart upload
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo upload_credential_infos = 2;</code>
         */
        public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder> 
             getUploadCredentialInfosBuilderList() {
          return getUploadCredentialInfosFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
            getUploadCredentialInfosFieldBuilder() {
          if (uploadCredentialInfosBuilder_ == null) {
            uploadCredentialInfosBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder>(
                    uploadCredentialInfos_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            uploadCredentialInfos_ = null;
          }
          return uploadCredentialInfosBuilder_;
        }

        private com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo abortCredentialInfo_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> abortCredentialInfoBuilder_;
        /**
         * <pre>
         * Credential for aborting the initiated multipart upload
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
         * @return Whether the abortCredentialInfo field is set.
         */
        public boolean hasAbortCredentialInfo() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <pre>
         * Credential for aborting the initiated multipart upload
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
         * @return The abortCredentialInfo.
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getAbortCredentialInfo() {
          if (abortCredentialInfoBuilder_ == null) {
            return abortCredentialInfo_ == null ? com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance() : abortCredentialInfo_;
          } else {
            return abortCredentialInfoBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Credential for aborting the initiated multipart upload
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
         */
        public Builder setAbortCredentialInfo(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (abortCredentialInfoBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            abortCredentialInfo_ = value;
            onChanged();
          } else {
            abortCredentialInfoBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <pre>
         * Credential for aborting the initiated multipart upload
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
         */
        public Builder setAbortCredentialInfo(
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (abortCredentialInfoBuilder_ == null) {
            abortCredentialInfo_ = builderForValue.build();
            onChanged();
          } else {
            abortCredentialInfoBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <pre>
         * Credential for aborting the initiated multipart upload
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
         */
        public Builder mergeAbortCredentialInfo(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (abortCredentialInfoBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0) &&
                abortCredentialInfo_ != null &&
                abortCredentialInfo_ != com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance()) {
              abortCredentialInfo_ =
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.newBuilder(abortCredentialInfo_).mergeFrom(value).buildPartial();
            } else {
              abortCredentialInfo_ = value;
            }
            onChanged();
          } else {
            abortCredentialInfoBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <pre>
         * Credential for aborting the initiated multipart upload
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
         */
        public Builder clearAbortCredentialInfo() {
          if (abortCredentialInfoBuilder_ == null) {
            abortCredentialInfo_ = null;
            onChanged();
          } else {
            abortCredentialInfoBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }
        /**
         * <pre>
         * Credential for aborting the initiated multipart upload
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder getAbortCredentialInfoBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getAbortCredentialInfoFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Credential for aborting the initiated multipart upload
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getAbortCredentialInfoOrBuilder() {
          if (abortCredentialInfoBuilder_ != null) {
            return abortCredentialInfoBuilder_.getMessageOrBuilder();
          } else {
            return abortCredentialInfo_ == null ?
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance() : abortCredentialInfo_;
          }
        }
        /**
         * <pre>
         * Credential for aborting the initiated multipart upload
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo abort_credential_info = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
            getAbortCredentialInfoFieldBuilder() {
          if (abortCredentialInfoBuilder_ == null) {
            abortCredentialInfoBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder>(
                    getAbortCredentialInfo(),
                    getParentForChildren(),
                    isClean());
            abortCredentialInfo_ = null;
          }
          return abortCredentialInfoBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:mlflow.CreateMultipartUpload.Response)
      }

      // @@protoc_insertion_point(class_scope:mlflow.CreateMultipartUpload.Response)
      private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response();
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Response>
          PARSER = new com.google.protobuf.AbstractParser<Response>() {
        @java.lang.Override
        public Response parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Response(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Response> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Response> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Response getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int RUN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object runId_;
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return Whether the runId field is set.
     */
    @java.lang.Override
    public boolean hasRunId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The runId.
     */
    @java.lang.Override
    public java.lang.String getRunId() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          runId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for runId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getRunIdBytes() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        runId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private volatile java.lang.Object path_;
    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          path_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NUM_PARTS_FIELD_NUMBER = 3;
    private long numParts_;
    /**
     * <pre>
     * Number of file parts (chunks of data) to upload in the initiated multipart upload
     * </pre>
     *
     * <code>optional int64 num_parts = 3 [(.mlflow.validate_required) = true];</code>
     * @return Whether the numParts field is set.
     */
    @java.lang.Override
    public boolean hasNumParts() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Number of file parts (chunks of data) to upload in the initiated multipart upload
     * </pre>
     *
     * <code>optional int64 num_parts = 3 [(.mlflow.validate_required) = true];</code>
     * @return The numParts.
     */
    @java.lang.Override
    public long getNumParts() {
      return numParts_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, runId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeInt64(3, numParts_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, runId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, path_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(3, numParts_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload)) {
        return super.equals(obj);
      }
      com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload) obj;

      if (hasRunId() != other.hasRunId()) return false;
      if (hasRunId()) {
        if (!getRunId()
            .equals(other.getRunId())) return false;
      }
      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (hasNumParts() != other.hasNumParts()) return false;
      if (hasNumParts()) {
        if (getNumParts()
            != other.getNumParts()) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRunId()) {
        hash = (37 * hash) + RUN_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRunId().hashCode();
      }
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      if (hasNumParts()) {
        hash = (37 * hash) + NUM_PARTS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getNumParts());
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code mlflow.CreateMultipartUpload}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:mlflow.CreateMultipartUpload)
        com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUploadOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CreateMultipartUpload_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CreateMultipartUpload_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.Builder.class);
      }

      // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        runId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        numParts_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CreateMultipartUpload_descriptor;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload getDefaultInstanceForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.getDefaultInstance();
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload build() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload buildPartial() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.runId_ = runId_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.path_ = path_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.numParts_ = numParts_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload) {
          return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload other) {
        if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload.getDefaultInstance()) return this;
        if (other.hasRunId()) {
          bitField0_ |= 0x00000001;
          runId_ = other.runId_;
          onChanged();
        }
        if (other.hasPath()) {
          bitField0_ |= 0x00000002;
          path_ = other.path_;
          onChanged();
        }
        if (other.hasNumParts()) {
          setNumParts(other.getNumParts());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object runId_ = "";
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return Whether the runId field is set.
       */
      public boolean hasRunId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return The runId.
       */
      public java.lang.String getRunId() {
        java.lang.Object ref = runId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            runId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return The bytes for runId.
       */
      public com.google.protobuf.ByteString
          getRunIdBytes() {
        java.lang.Object ref = runId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          runId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @param value The runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearRunId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        runId_ = getDefaultInstance().getRunId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @param value The bytes for runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            path_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString
          getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        path_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        bitField0_ = (bitField0_ & ~0x00000002);
        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        path_ = value;
        onChanged();
        return this;
      }

      private long numParts_ ;
      /**
       * <pre>
       * Number of file parts (chunks of data) to upload in the initiated multipart upload
       * </pre>
       *
       * <code>optional int64 num_parts = 3 [(.mlflow.validate_required) = true];</code>
       * @return Whether the numParts field is set.
       */
      @java.lang.Override
      public boolean hasNumParts() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Number of file parts (chunks of data) to upload in the initiated multipart upload
       * </pre>
       *
       * <code>optional int64 num_parts = 3 [(.mlflow.validate_required) = true];</code>
       * @return The numParts.
       */
      @java.lang.Override
      public long getNumParts() {
        return numParts_;
      }
      /**
       * <pre>
       * Number of file parts (chunks of data) to upload in the initiated multipart upload
       * </pre>
       *
       * <code>optional int64 num_parts = 3 [(.mlflow.validate_required) = true];</code>
       * @param value The numParts to set.
       * @return This builder for chaining.
       */
      public Builder setNumParts(long value) {
        bitField0_ |= 0x00000004;
        numParts_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Number of file parts (chunks of data) to upload in the initiated multipart upload
       * </pre>
       *
       * <code>optional int64 num_parts = 3 [(.mlflow.validate_required) = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearNumParts() {
        bitField0_ = (bitField0_ & ~0x00000004);
        numParts_ = 0L;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:mlflow.CreateMultipartUpload)
    }

    // @@protoc_insertion_point(class_scope:mlflow.CreateMultipartUpload)
    private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload();
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<CreateMultipartUpload>
        PARSER = new com.google.protobuf.AbstractParser<CreateMultipartUpload>() {
      @java.lang.Override
      public CreateMultipartUpload parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CreateMultipartUpload(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<CreateMultipartUpload> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CreateMultipartUpload> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.CreateMultipartUpload getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PartEtagOrBuilder extends
      // @@protoc_insertion_point(interface_extends:mlflow.PartEtag)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional int64 part_number = 1;</code>
     * @return Whether the partNumber field is set.
     */
    boolean hasPartNumber();
    /**
     * <code>optional int64 part_number = 1;</code>
     * @return The partNumber.
     */
    long getPartNumber();

    /**
     * <code>optional string etag = 2;</code>
     * @return Whether the etag field is set.
     */
    boolean hasEtag();
    /**
     * <code>optional string etag = 2;</code>
     * @return The etag.
     */
    java.lang.String getEtag();
    /**
     * <code>optional string etag = 2;</code>
     * @return The bytes for etag.
     */
    com.google.protobuf.ByteString
        getEtagBytes();
  }
  /**
   * Protobuf type {@code mlflow.PartEtag}
   */
  public static final class PartEtag extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:mlflow.PartEtag)
      PartEtagOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PartEtag.newBuilder() to construct.
    private PartEtag(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PartEtag() {
      etag_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new PartEtag();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private PartEtag(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              bitField0_ |= 0x00000001;
              partNumber_ = input.readInt64();
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              etag_ = bs;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_PartEtag_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_PartEtag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder.class);
    }

    private int bitField0_;
    public static final int PART_NUMBER_FIELD_NUMBER = 1;
    private long partNumber_;
    /**
     * <code>optional int64 part_number = 1;</code>
     * @return Whether the partNumber field is set.
     */
    @java.lang.Override
    public boolean hasPartNumber() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional int64 part_number = 1;</code>
     * @return The partNumber.
     */
    @java.lang.Override
    public long getPartNumber() {
      return partNumber_;
    }

    public static final int ETAG_FIELD_NUMBER = 2;
    private volatile java.lang.Object etag_;
    /**
     * <code>optional string etag = 2;</code>
     * @return Whether the etag field is set.
     */
    @java.lang.Override
    public boolean hasEtag() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional string etag = 2;</code>
     * @return The etag.
     */
    @java.lang.Override
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          etag_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string etag = 2;</code>
     * @return The bytes for etag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt64(1, partNumber_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, etag_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(1, partNumber_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, etag_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag)) {
        return super.equals(obj);
      }
      com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag) obj;

      if (hasPartNumber() != other.hasPartNumber()) return false;
      if (hasPartNumber()) {
        if (getPartNumber()
            != other.getPartNumber()) return false;
      }
      if (hasEtag() != other.hasEtag()) return false;
      if (hasEtag()) {
        if (!getEtag()
            .equals(other.getEtag())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPartNumber()) {
        hash = (37 * hash) + PART_NUMBER_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getPartNumber());
      }
      if (hasEtag()) {
        hash = (37 * hash) + ETAG_FIELD_NUMBER;
        hash = (53 * hash) + getEtag().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code mlflow.PartEtag}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:mlflow.PartEtag)
        com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtagOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_PartEtag_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_PartEtag_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder.class);
      }

      // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        partNumber_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        etag_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_PartEtag_descriptor;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag getDefaultInstanceForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.getDefaultInstance();
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag build() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag buildPartial() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.partNumber_ = partNumber_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.etag_ = etag_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag) {
          return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag other) {
        if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.getDefaultInstance()) return this;
        if (other.hasPartNumber()) {
          setPartNumber(other.getPartNumber());
        }
        if (other.hasEtag()) {
          bitField0_ |= 0x00000002;
          etag_ = other.etag_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long partNumber_ ;
      /**
       * <code>optional int64 part_number = 1;</code>
       * @return Whether the partNumber field is set.
       */
      @java.lang.Override
      public boolean hasPartNumber() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional int64 part_number = 1;</code>
       * @return The partNumber.
       */
      @java.lang.Override
      public long getPartNumber() {
        return partNumber_;
      }
      /**
       * <code>optional int64 part_number = 1;</code>
       * @param value The partNumber to set.
       * @return This builder for chaining.
       */
      public Builder setPartNumber(long value) {
        bitField0_ |= 0x00000001;
        partNumber_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int64 part_number = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearPartNumber() {
        bitField0_ = (bitField0_ & ~0x00000001);
        partNumber_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object etag_ = "";
      /**
       * <code>optional string etag = 2;</code>
       * @return Whether the etag field is set.
       */
      public boolean hasEtag() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional string etag = 2;</code>
       * @return The etag.
       */
      public java.lang.String getEtag() {
        java.lang.Object ref = etag_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            etag_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string etag = 2;</code>
       * @return The bytes for etag.
       */
      public com.google.protobuf.ByteString
          getEtagBytes() {
        java.lang.Object ref = etag_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          etag_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string etag = 2;</code>
       * @param value The etag to set.
       * @return This builder for chaining.
       */
      public Builder setEtag(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        etag_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string etag = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearEtag() {
        bitField0_ = (bitField0_ & ~0x00000002);
        etag_ = getDefaultInstance().getEtag();
        onChanged();
        return this;
      }
      /**
       * <code>optional string etag = 2;</code>
       * @param value The bytes for etag to set.
       * @return This builder for chaining.
       */
      public Builder setEtagBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        etag_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:mlflow.PartEtag)
    }

    // @@protoc_insertion_point(class_scope:mlflow.PartEtag)
    private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag();
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<PartEtag>
        PARSER = new com.google.protobuf.AbstractParser<PartEtag>() {
      @java.lang.Override
      public PartEtag parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new PartEtag(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<PartEtag> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PartEtag> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CompleteMultipartUploadOrBuilder extends
      // @@protoc_insertion_point(interface_extends:mlflow.CompleteMultipartUpload)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return Whether the runId field is set.
     */
    boolean hasRunId();
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The runId.
     */
    java.lang.String getRunId();
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for runId.
     */
    com.google.protobuf.ByteString
        getRunIdBytes();

    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The path.
     */
    java.lang.String getPath();
    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString
        getPathBytes();

    /**
     * <pre>
     * ID identifying the multipart upload to complete
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return Whether the uploadId field is set.
     */
    boolean hasUploadId();
    /**
     * <pre>
     * ID identifying the multipart upload to complete
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return The uploadId.
     */
    java.lang.String getUploadId();
    /**
     * <pre>
     * ID identifying the multipart upload to complete
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for uploadId.
     */
    com.google.protobuf.ByteString
        getUploadIdBytes();

    /**
     * <pre>
     * A list of file parts uploaded in the multipart upload to complete
     * </pre>
     *
     * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
     */
    java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag> 
        getPartEtagsList();
    /**
     * <pre>
     * A list of file parts uploaded in the multipart upload to complete
     * </pre>
     *
     * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
     */
    com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag getPartEtags(int index);
    /**
     * <pre>
     * A list of file parts uploaded in the multipart upload to complete
     * </pre>
     *
     * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
     */
    int getPartEtagsCount();
    /**
     * <pre>
     * A list of file parts uploaded in the multipart upload to complete
     * </pre>
     *
     * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
     */
    java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtagOrBuilder> 
        getPartEtagsOrBuilderList();
    /**
     * <pre>
     * A list of file parts uploaded in the multipart upload to complete
     * </pre>
     *
     * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
     */
    com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtagOrBuilder getPartEtagsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code mlflow.CompleteMultipartUpload}
   */
  public static final class CompleteMultipartUpload extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:mlflow.CompleteMultipartUpload)
      CompleteMultipartUploadOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use CompleteMultipartUpload.newBuilder() to construct.
    private CompleteMultipartUpload(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private CompleteMultipartUpload() {
      runId_ = "";
      path_ = "";
      uploadId_ = "";
      partEtags_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new CompleteMultipartUpload();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private CompleteMultipartUpload(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              runId_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              path_ = bs;
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              uploadId_ = bs;
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                partEtags_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag>();
                mutable_bitField0_ |= 0x00000008;
              }
              partEtags_.add(
                  input.readMessage(com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.PARSER, extensionRegistry));
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000008) != 0)) {
          partEtags_ = java.util.Collections.unmodifiableList(partEtags_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CompleteMultipartUpload_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CompleteMultipartUpload_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Builder.class);
    }

    public interface ResponseOrBuilder extends
        // @@protoc_insertion_point(interface_extends:mlflow.CompleteMultipartUpload.Response)
        com.google.protobuf.MessageOrBuilder {
    }
    /**
     * Protobuf type {@code mlflow.CompleteMultipartUpload.Response}
     */
    public static final class Response extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:mlflow.CompleteMultipartUpload.Response)
        ResponseOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Response.newBuilder() to construct.
      private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Response() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Response();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Response(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CompleteMultipartUpload_Response_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CompleteMultipartUpload_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response.Builder.class);
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response)) {
          return super.equals(obj);
        }
        com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response) obj;

        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code mlflow.CompleteMultipartUpload.Response}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:mlflow.CompleteMultipartUpload.Response)
          com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.ResponseOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CompleteMultipartUpload_Response_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CompleteMultipartUpload_Response_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response.Builder.class);
        }

        // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CompleteMultipartUpload_Response_descriptor;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response getDefaultInstanceForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response.getDefaultInstance();
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response build() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response buildPartial() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response) {
            return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response other) {
          if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response.getDefaultInstance()) return this;
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:mlflow.CompleteMultipartUpload.Response)
      }

      // @@protoc_insertion_point(class_scope:mlflow.CompleteMultipartUpload.Response)
      private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response();
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Response>
          PARSER = new com.google.protobuf.AbstractParser<Response>() {
        @java.lang.Override
        public Response parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Response(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Response> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Response> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Response getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int RUN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object runId_;
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return Whether the runId field is set.
     */
    @java.lang.Override
    public boolean hasRunId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The runId.
     */
    @java.lang.Override
    public java.lang.String getRunId() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          runId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for runId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getRunIdBytes() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        runId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private volatile java.lang.Object path_;
    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          path_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int UPLOAD_ID_FIELD_NUMBER = 3;
    private volatile java.lang.Object uploadId_;
    /**
     * <pre>
     * ID identifying the multipart upload to complete
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return Whether the uploadId field is set.
     */
    @java.lang.Override
    public boolean hasUploadId() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * ID identifying the multipart upload to complete
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return The uploadId.
     */
    @java.lang.Override
    public java.lang.String getUploadId() {
      java.lang.Object ref = uploadId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          uploadId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * ID identifying the multipart upload to complete
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for uploadId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getUploadIdBytes() {
      java.lang.Object ref = uploadId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uploadId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PART_ETAGS_FIELD_NUMBER = 4;
    private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag> partEtags_;
    /**
     * <pre>
     * A list of file parts uploaded in the multipart upload to complete
     * </pre>
     *
     * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
     */
    @java.lang.Override
    public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag> getPartEtagsList() {
      return partEtags_;
    }
    /**
     * <pre>
     * A list of file parts uploaded in the multipart upload to complete
     * </pre>
     *
     * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtagOrBuilder> 
        getPartEtagsOrBuilderList() {
      return partEtags_;
    }
    /**
     * <pre>
     * A list of file parts uploaded in the multipart upload to complete
     * </pre>
     *
     * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
     */
    @java.lang.Override
    public int getPartEtagsCount() {
      return partEtags_.size();
    }
    /**
     * <pre>
     * A list of file parts uploaded in the multipart upload to complete
     * </pre>
     *
     * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
     */
    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag getPartEtags(int index) {
      return partEtags_.get(index);
    }
    /**
     * <pre>
     * A list of file parts uploaded in the multipart upload to complete
     * </pre>
     *
     * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
     */
    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtagOrBuilder getPartEtagsOrBuilder(
        int index) {
      return partEtags_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, runId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uploadId_);
      }
      for (int i = 0; i < partEtags_.size(); i++) {
        output.writeMessage(4, partEtags_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, runId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, path_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uploadId_);
      }
      for (int i = 0; i < partEtags_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, partEtags_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload)) {
        return super.equals(obj);
      }
      com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload) obj;

      if (hasRunId() != other.hasRunId()) return false;
      if (hasRunId()) {
        if (!getRunId()
            .equals(other.getRunId())) return false;
      }
      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (hasUploadId() != other.hasUploadId()) return false;
      if (hasUploadId()) {
        if (!getUploadId()
            .equals(other.getUploadId())) return false;
      }
      if (!getPartEtagsList()
          .equals(other.getPartEtagsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRunId()) {
        hash = (37 * hash) + RUN_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRunId().hashCode();
      }
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      if (hasUploadId()) {
        hash = (37 * hash) + UPLOAD_ID_FIELD_NUMBER;
        hash = (53 * hash) + getUploadId().hashCode();
      }
      if (getPartEtagsCount() > 0) {
        hash = (37 * hash) + PART_ETAGS_FIELD_NUMBER;
        hash = (53 * hash) + getPartEtagsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code mlflow.CompleteMultipartUpload}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:mlflow.CompleteMultipartUpload)
        com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUploadOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CompleteMultipartUpload_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CompleteMultipartUpload_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.Builder.class);
      }

      // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPartEtagsFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        runId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        uploadId_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        if (partEtagsBuilder_ == null) {
          partEtags_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          partEtagsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_CompleteMultipartUpload_descriptor;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload getDefaultInstanceForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.getDefaultInstance();
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload build() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload buildPartial() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.runId_ = runId_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.path_ = path_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.uploadId_ = uploadId_;
        if (partEtagsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            partEtags_ = java.util.Collections.unmodifiableList(partEtags_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.partEtags_ = partEtags_;
        } else {
          result.partEtags_ = partEtagsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload) {
          return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload other) {
        if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload.getDefaultInstance()) return this;
        if (other.hasRunId()) {
          bitField0_ |= 0x00000001;
          runId_ = other.runId_;
          onChanged();
        }
        if (other.hasPath()) {
          bitField0_ |= 0x00000002;
          path_ = other.path_;
          onChanged();
        }
        if (other.hasUploadId()) {
          bitField0_ |= 0x00000004;
          uploadId_ = other.uploadId_;
          onChanged();
        }
        if (partEtagsBuilder_ == null) {
          if (!other.partEtags_.isEmpty()) {
            if (partEtags_.isEmpty()) {
              partEtags_ = other.partEtags_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensurePartEtagsIsMutable();
              partEtags_.addAll(other.partEtags_);
            }
            onChanged();
          }
        } else {
          if (!other.partEtags_.isEmpty()) {
            if (partEtagsBuilder_.isEmpty()) {
              partEtagsBuilder_.dispose();
              partEtagsBuilder_ = null;
              partEtags_ = other.partEtags_;
              bitField0_ = (bitField0_ & ~0x00000008);
              partEtagsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getPartEtagsFieldBuilder() : null;
            } else {
              partEtagsBuilder_.addAllMessages(other.partEtags_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object runId_ = "";
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return Whether the runId field is set.
       */
      public boolean hasRunId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return The runId.
       */
      public java.lang.String getRunId() {
        java.lang.Object ref = runId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            runId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return The bytes for runId.
       */
      public com.google.protobuf.ByteString
          getRunIdBytes() {
        java.lang.Object ref = runId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          runId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @param value The runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearRunId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        runId_ = getDefaultInstance().getRunId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @param value The bytes for runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            path_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString
          getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        path_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        bitField0_ = (bitField0_ & ~0x00000002);
        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Artifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        path_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object uploadId_ = "";
      /**
       * <pre>
       * ID identifying the multipart upload to complete
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @return Whether the uploadId field is set.
       */
      public boolean hasUploadId() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * ID identifying the multipart upload to complete
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @return The uploadId.
       */
      public java.lang.String getUploadId() {
        java.lang.Object ref = uploadId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            uploadId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID identifying the multipart upload to complete
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @return The bytes for uploadId.
       */
      public com.google.protobuf.ByteString
          getUploadIdBytes() {
        java.lang.Object ref = uploadId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          uploadId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID identifying the multipart upload to complete
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @param value The uploadId to set.
       * @return This builder for chaining.
       */
      public Builder setUploadId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        uploadId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID identifying the multipart upload to complete
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearUploadId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        uploadId_ = getDefaultInstance().getUploadId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID identifying the multipart upload to complete
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @param value The bytes for uploadId to set.
       * @return This builder for chaining.
       */
      public Builder setUploadIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        uploadId_ = value;
        onChanged();
        return this;
      }

      private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag> partEtags_ =
        java.util.Collections.emptyList();
      private void ensurePartEtagsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          partEtags_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag>(partEtags_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtagOrBuilder> partEtagsBuilder_;

      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag> getPartEtagsList() {
        if (partEtagsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(partEtags_);
        } else {
          return partEtagsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public int getPartEtagsCount() {
        if (partEtagsBuilder_ == null) {
          return partEtags_.size();
        } else {
          return partEtagsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag getPartEtags(int index) {
        if (partEtagsBuilder_ == null) {
          return partEtags_.get(index);
        } else {
          return partEtagsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public Builder setPartEtags(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag value) {
        if (partEtagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartEtagsIsMutable();
          partEtags_.set(index, value);
          onChanged();
        } else {
          partEtagsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public Builder setPartEtags(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder builderForValue) {
        if (partEtagsBuilder_ == null) {
          ensurePartEtagsIsMutable();
          partEtags_.set(index, builderForValue.build());
          onChanged();
        } else {
          partEtagsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public Builder addPartEtags(com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag value) {
        if (partEtagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartEtagsIsMutable();
          partEtags_.add(value);
          onChanged();
        } else {
          partEtagsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public Builder addPartEtags(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag value) {
        if (partEtagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePartEtagsIsMutable();
          partEtags_.add(index, value);
          onChanged();
        } else {
          partEtagsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public Builder addPartEtags(
          com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder builderForValue) {
        if (partEtagsBuilder_ == null) {
          ensurePartEtagsIsMutable();
          partEtags_.add(builderForValue.build());
          onChanged();
        } else {
          partEtagsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public Builder addPartEtags(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder builderForValue) {
        if (partEtagsBuilder_ == null) {
          ensurePartEtagsIsMutable();
          partEtags_.add(index, builderForValue.build());
          onChanged();
        } else {
          partEtagsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public Builder addAllPartEtags(
          java.lang.Iterable<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag> values) {
        if (partEtagsBuilder_ == null) {
          ensurePartEtagsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, partEtags_);
          onChanged();
        } else {
          partEtagsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public Builder clearPartEtags() {
        if (partEtagsBuilder_ == null) {
          partEtags_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          partEtagsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public Builder removePartEtags(int index) {
        if (partEtagsBuilder_ == null) {
          ensurePartEtagsIsMutable();
          partEtags_.remove(index);
          onChanged();
        } else {
          partEtagsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder getPartEtagsBuilder(
          int index) {
        return getPartEtagsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtagOrBuilder getPartEtagsOrBuilder(
          int index) {
        if (partEtagsBuilder_ == null) {
          return partEtags_.get(index);  } else {
          return partEtagsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtagOrBuilder> 
           getPartEtagsOrBuilderList() {
        if (partEtagsBuilder_ != null) {
          return partEtagsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(partEtags_);
        }
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder addPartEtagsBuilder() {
        return getPartEtagsFieldBuilder().addBuilder(
            com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.getDefaultInstance());
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder addPartEtagsBuilder(
          int index) {
        return getPartEtagsFieldBuilder().addBuilder(
            index, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.getDefaultInstance());
      }
      /**
       * <pre>
       * A list of file parts uploaded in the multipart upload to complete
       * </pre>
       *
       * <code>repeated .mlflow.PartEtag part_etags = 4;</code>
       */
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder> 
           getPartEtagsBuilderList() {
        return getPartEtagsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtagOrBuilder> 
          getPartEtagsFieldBuilder() {
        if (partEtagsBuilder_ == null) {
          partEtagsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtag.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.PartEtagOrBuilder>(
                  partEtags_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          partEtags_ = null;
        }
        return partEtagsBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:mlflow.CompleteMultipartUpload)
    }

    // @@protoc_insertion_point(class_scope:mlflow.CompleteMultipartUpload)
    private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload();
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<CompleteMultipartUpload>
        PARSER = new com.google.protobuf.AbstractParser<CompleteMultipartUpload>() {
      @java.lang.Override
      public CompleteMultipartUpload parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CompleteMultipartUpload(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<CompleteMultipartUpload> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CompleteMultipartUpload> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.CompleteMultipartUpload getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetPresignedUploadPartUrlOrBuilder extends
      // @@protoc_insertion_point(interface_extends:mlflow.GetPresignedUploadPartUrl)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return Whether the runId field is set.
     */
    boolean hasRunId();
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The runId.
     */
    java.lang.String getRunId();
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for runId.
     */
    com.google.protobuf.ByteString
        getRunIdBytes();

    /**
     * <pre>
     * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return Whether the path field is set.
     */
    boolean hasPath();
    /**
     * <pre>
     * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The path.
     */
    java.lang.String getPath();
    /**
     * <pre>
     * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString
        getPathBytes();

    /**
     * <pre>
     * ID identifying the multipart upload in which the part is uploaded
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return Whether the uploadId field is set.
     */
    boolean hasUploadId();
    /**
     * <pre>
     * ID identifying the multipart upload in which the part is uploaded
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return The uploadId.
     */
    java.lang.String getUploadId();
    /**
     * <pre>
     * ID identifying the multipart upload in which the part is uploaded
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for uploadId.
     */
    com.google.protobuf.ByteString
        getUploadIdBytes();

    /**
     * <pre>
     * Part number
     * </pre>
     *
     * <code>optional int64 part_number = 4 [(.mlflow.validate_required) = true];</code>
     * @return Whether the partNumber field is set.
     */
    boolean hasPartNumber();
    /**
     * <pre>
     * Part number
     * </pre>
     *
     * <code>optional int64 part_number = 4 [(.mlflow.validate_required) = true];</code>
     * @return The partNumber.
     */
    long getPartNumber();
  }
  /**
   * Protobuf type {@code mlflow.GetPresignedUploadPartUrl}
   */
  public static final class GetPresignedUploadPartUrl extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:mlflow.GetPresignedUploadPartUrl)
      GetPresignedUploadPartUrlOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetPresignedUploadPartUrl.newBuilder() to construct.
    private GetPresignedUploadPartUrl(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetPresignedUploadPartUrl() {
      runId_ = "";
      path_ = "";
      uploadId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new GetPresignedUploadPartUrl();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private GetPresignedUploadPartUrl(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              runId_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              path_ = bs;
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              uploadId_ = bs;
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              partNumber_ = input.readInt64();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetPresignedUploadPartUrl_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetPresignedUploadPartUrl_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Builder.class);
    }

    public interface ResponseOrBuilder extends
        // @@protoc_insertion_point(interface_extends:mlflow.GetPresignedUploadPartUrl.Response)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Credential for uploading the part
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
       * @return Whether the uploadCredentialInfo field is set.
       */
      boolean hasUploadCredentialInfo();
      /**
       * <pre>
       * Credential for uploading the part
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
       * @return The uploadCredentialInfo.
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getUploadCredentialInfo();
      /**
       * <pre>
       * Credential for uploading the part
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getUploadCredentialInfoOrBuilder();
    }
    /**
     * Protobuf type {@code mlflow.GetPresignedUploadPartUrl.Response}
     */
    public static final class Response extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:mlflow.GetPresignedUploadPartUrl.Response)
        ResponseOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Response.newBuilder() to construct.
      private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Response() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Response();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Response(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) != 0)) {
                  subBuilder = uploadCredentialInfo_.toBuilder();
                }
                uploadCredentialInfo_ = input.readMessage(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(uploadCredentialInfo_);
                  uploadCredentialInfo_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetPresignedUploadPartUrl_Response_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetPresignedUploadPartUrl_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response.Builder.class);
      }

      private int bitField0_;
      public static final int UPLOAD_CREDENTIAL_INFO_FIELD_NUMBER = 1;
      private com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo uploadCredentialInfo_;
      /**
       * <pre>
       * Credential for uploading the part
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
       * @return Whether the uploadCredentialInfo field is set.
       */
      @java.lang.Override
      public boolean hasUploadCredentialInfo() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Credential for uploading the part
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
       * @return The uploadCredentialInfo.
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getUploadCredentialInfo() {
        return uploadCredentialInfo_ == null ? com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance() : uploadCredentialInfo_;
      }
      /**
       * <pre>
       * Credential for uploading the part
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
       */
      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getUploadCredentialInfoOrBuilder() {
        return uploadCredentialInfo_ == null ? com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance() : uploadCredentialInfo_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getUploadCredentialInfo());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, getUploadCredentialInfo());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response)) {
          return super.equals(obj);
        }
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response) obj;

        if (hasUploadCredentialInfo() != other.hasUploadCredentialInfo()) return false;
        if (hasUploadCredentialInfo()) {
          if (!getUploadCredentialInfo()
              .equals(other.getUploadCredentialInfo())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasUploadCredentialInfo()) {
          hash = (37 * hash) + UPLOAD_CREDENTIAL_INFO_FIELD_NUMBER;
          hash = (53 * hash) + getUploadCredentialInfo().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code mlflow.GetPresignedUploadPartUrl.Response}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:mlflow.GetPresignedUploadPartUrl.Response)
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.ResponseOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetPresignedUploadPartUrl_Response_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetPresignedUploadPartUrl_Response_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response.Builder.class);
        }

        // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getUploadCredentialInfoFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (uploadCredentialInfoBuilder_ == null) {
            uploadCredentialInfo_ = null;
          } else {
            uploadCredentialInfoBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetPresignedUploadPartUrl_Response_descriptor;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response getDefaultInstanceForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response.getDefaultInstance();
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response build() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response buildPartial() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            if (uploadCredentialInfoBuilder_ == null) {
              result.uploadCredentialInfo_ = uploadCredentialInfo_;
            } else {
              result.uploadCredentialInfo_ = uploadCredentialInfoBuilder_.build();
            }
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response) {
            return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response other) {
          if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response.getDefaultInstance()) return this;
          if (other.hasUploadCredentialInfo()) {
            mergeUploadCredentialInfo(other.getUploadCredentialInfo());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo uploadCredentialInfo_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> uploadCredentialInfoBuilder_;
        /**
         * <pre>
         * Credential for uploading the part
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
         * @return Whether the uploadCredentialInfo field is set.
         */
        public boolean hasUploadCredentialInfo() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Credential for uploading the part
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
         * @return The uploadCredentialInfo.
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getUploadCredentialInfo() {
          if (uploadCredentialInfoBuilder_ == null) {
            return uploadCredentialInfo_ == null ? com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance() : uploadCredentialInfo_;
          } else {
            return uploadCredentialInfoBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Credential for uploading the part
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
         */
        public Builder setUploadCredentialInfo(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (uploadCredentialInfoBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            uploadCredentialInfo_ = value;
            onChanged();
          } else {
            uploadCredentialInfoBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         * <pre>
         * Credential for uploading the part
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
         */
        public Builder setUploadCredentialInfo(
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (uploadCredentialInfoBuilder_ == null) {
            uploadCredentialInfo_ = builderForValue.build();
            onChanged();
          } else {
            uploadCredentialInfoBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         * <pre>
         * Credential for uploading the part
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
         */
        public Builder mergeUploadCredentialInfo(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (uploadCredentialInfoBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0) &&
                uploadCredentialInfo_ != null &&
                uploadCredentialInfo_ != com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance()) {
              uploadCredentialInfo_ =
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.newBuilder(uploadCredentialInfo_).mergeFrom(value).buildPartial();
            } else {
              uploadCredentialInfo_ = value;
            }
            onChanged();
          } else {
            uploadCredentialInfoBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000001;
          return this;
        }
        /**
         * <pre>
         * Credential for uploading the part
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
         */
        public Builder clearUploadCredentialInfo() {
          if (uploadCredentialInfoBuilder_ == null) {
            uploadCredentialInfo_ = null;
            onChanged();
          } else {
            uploadCredentialInfoBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }
        /**
         * <pre>
         * Credential for uploading the part
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder getUploadCredentialInfoBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getUploadCredentialInfoFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Credential for uploading the part
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getUploadCredentialInfoOrBuilder() {
          if (uploadCredentialInfoBuilder_ != null) {
            return uploadCredentialInfoBuilder_.getMessageOrBuilder();
          } else {
            return uploadCredentialInfo_ == null ?
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance() : uploadCredentialInfo_;
          }
        }
        /**
         * <pre>
         * Credential for uploading the part
         * </pre>
         *
         * <code>optional .mlflow.ArtifactCredentialInfo upload_credential_info = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
            getUploadCredentialInfoFieldBuilder() {
          if (uploadCredentialInfoBuilder_ == null) {
            uploadCredentialInfoBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder>(
                    getUploadCredentialInfo(),
                    getParentForChildren(),
                    isClean());
            uploadCredentialInfo_ = null;
          }
          return uploadCredentialInfoBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:mlflow.GetPresignedUploadPartUrl.Response)
      }

      // @@protoc_insertion_point(class_scope:mlflow.GetPresignedUploadPartUrl.Response)
      private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response();
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Response>
          PARSER = new com.google.protobuf.AbstractParser<Response>() {
        @java.lang.Override
        public Response parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Response(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Response> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Response> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Response getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int RUN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object runId_;
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return Whether the runId field is set.
     */
    @java.lang.Override
    public boolean hasRunId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The runId.
     */
    @java.lang.Override
    public java.lang.String getRunId() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          runId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Run ID
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for runId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getRunIdBytes() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        runId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private volatile java.lang.Object path_;
    /**
     * <pre>
     * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return Whether the path field is set.
     */
    @java.lang.Override
    public boolean hasPath() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          path_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
     * </pre>
     *
     * <code>optional string path = 2;</code>
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int UPLOAD_ID_FIELD_NUMBER = 3;
    private volatile java.lang.Object uploadId_;
    /**
     * <pre>
     * ID identifying the multipart upload in which the part is uploaded
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return Whether the uploadId field is set.
     */
    @java.lang.Override
    public boolean hasUploadId() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * ID identifying the multipart upload in which the part is uploaded
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return The uploadId.
     */
    @java.lang.Override
    public java.lang.String getUploadId() {
      java.lang.Object ref = uploadId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          uploadId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * ID identifying the multipart upload in which the part is uploaded
     * </pre>
     *
     * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
     * @return The bytes for uploadId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getUploadIdBytes() {
      java.lang.Object ref = uploadId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uploadId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PART_NUMBER_FIELD_NUMBER = 4;
    private long partNumber_;
    /**
     * <pre>
     * Part number
     * </pre>
     *
     * <code>optional int64 part_number = 4 [(.mlflow.validate_required) = true];</code>
     * @return Whether the partNumber field is set.
     */
    @java.lang.Override
    public boolean hasPartNumber() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Part number
     * </pre>
     *
     * <code>optional int64 part_number = 4 [(.mlflow.validate_required) = true];</code>
     * @return The partNumber.
     */
    @java.lang.Override
    public long getPartNumber() {
      return partNumber_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, runId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uploadId_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeInt64(4, partNumber_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, runId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, path_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, uploadId_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(4, partNumber_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl)) {
        return super.equals(obj);
      }
      com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl) obj;

      if (hasRunId() != other.hasRunId()) return false;
      if (hasRunId()) {
        if (!getRunId()
            .equals(other.getRunId())) return false;
      }
      if (hasPath() != other.hasPath()) return false;
      if (hasPath()) {
        if (!getPath()
            .equals(other.getPath())) return false;
      }
      if (hasUploadId() != other.hasUploadId()) return false;
      if (hasUploadId()) {
        if (!getUploadId()
            .equals(other.getUploadId())) return false;
      }
      if (hasPartNumber() != other.hasPartNumber()) return false;
      if (hasPartNumber()) {
        if (getPartNumber()
            != other.getPartNumber()) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRunId()) {
        hash = (37 * hash) + RUN_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRunId().hashCode();
      }
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      if (hasUploadId()) {
        hash = (37 * hash) + UPLOAD_ID_FIELD_NUMBER;
        hash = (53 * hash) + getUploadId().hashCode();
      }
      if (hasPartNumber()) {
        hash = (37 * hash) + PART_NUMBER_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getPartNumber());
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code mlflow.GetPresignedUploadPartUrl}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:mlflow.GetPresignedUploadPartUrl)
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrlOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetPresignedUploadPartUrl_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetPresignedUploadPartUrl_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.Builder.class);
      }

      // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        runId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        uploadId_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        partNumber_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetPresignedUploadPartUrl_descriptor;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl getDefaultInstanceForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.getDefaultInstance();
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl build() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl buildPartial() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.runId_ = runId_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.path_ = path_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.uploadId_ = uploadId_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.partNumber_ = partNumber_;
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl) {
          return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl other) {
        if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl.getDefaultInstance()) return this;
        if (other.hasRunId()) {
          bitField0_ |= 0x00000001;
          runId_ = other.runId_;
          onChanged();
        }
        if (other.hasPath()) {
          bitField0_ |= 0x00000002;
          path_ = other.path_;
          onChanged();
        }
        if (other.hasUploadId()) {
          bitField0_ |= 0x00000004;
          uploadId_ = other.uploadId_;
          onChanged();
        }
        if (other.hasPartNumber()) {
          setPartNumber(other.getPartNumber());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object runId_ = "";
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return Whether the runId field is set.
       */
      public boolean hasRunId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return The runId.
       */
      public java.lang.String getRunId() {
        java.lang.Object ref = runId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            runId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return The bytes for runId.
       */
      public com.google.protobuf.ByteString
          getRunIdBytes() {
        java.lang.Object ref = runId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          runId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @param value The runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearRunId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        runId_ = getDefaultInstance().getRunId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Run ID
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       * @param value The bytes for runId to set.
       * @return This builder for chaining.
       */
      public Builder setRunIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       * <pre>
       * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return Whether the path field is set.
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            path_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString
          getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        path_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearPath() {
        bitField0_ = (bitField0_ & ~0x00000002);
        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Atifact path, relative to the Run's artifact root location (e.g. "path/to/file")
       * </pre>
       *
       * <code>optional string path = 2;</code>
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        path_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object uploadId_ = "";
      /**
       * <pre>
       * ID identifying the multipart upload in which the part is uploaded
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @return Whether the uploadId field is set.
       */
      public boolean hasUploadId() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * ID identifying the multipart upload in which the part is uploaded
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @return The uploadId.
       */
      public java.lang.String getUploadId() {
        java.lang.Object ref = uploadId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            uploadId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID identifying the multipart upload in which the part is uploaded
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @return The bytes for uploadId.
       */
      public com.google.protobuf.ByteString
          getUploadIdBytes() {
        java.lang.Object ref = uploadId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          uploadId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID identifying the multipart upload in which the part is uploaded
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @param value The uploadId to set.
       * @return This builder for chaining.
       */
      public Builder setUploadId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        uploadId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID identifying the multipart upload in which the part is uploaded
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearUploadId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        uploadId_ = getDefaultInstance().getUploadId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID identifying the multipart upload in which the part is uploaded
       * </pre>
       *
       * <code>optional string upload_id = 3 [(.mlflow.validate_required) = true];</code>
       * @param value The bytes for uploadId to set.
       * @return This builder for chaining.
       */
      public Builder setUploadIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        uploadId_ = value;
        onChanged();
        return this;
      }

      private long partNumber_ ;
      /**
       * <pre>
       * Part number
       * </pre>
       *
       * <code>optional int64 part_number = 4 [(.mlflow.validate_required) = true];</code>
       * @return Whether the partNumber field is set.
       */
      @java.lang.Override
      public boolean hasPartNumber() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * Part number
       * </pre>
       *
       * <code>optional int64 part_number = 4 [(.mlflow.validate_required) = true];</code>
       * @return The partNumber.
       */
      @java.lang.Override
      public long getPartNumber() {
        return partNumber_;
      }
      /**
       * <pre>
       * Part number
       * </pre>
       *
       * <code>optional int64 part_number = 4 [(.mlflow.validate_required) = true];</code>
       * @param value The partNumber to set.
       * @return This builder for chaining.
       */
      public Builder setPartNumber(long value) {
        bitField0_ |= 0x00000008;
        partNumber_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Part number
       * </pre>
       *
       * <code>optional int64 part_number = 4 [(.mlflow.validate_required) = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearPartNumber() {
        bitField0_ = (bitField0_ & ~0x00000008);
        partNumber_ = 0L;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:mlflow.GetPresignedUploadPartUrl)
    }

    // @@protoc_insertion_point(class_scope:mlflow.GetPresignedUploadPartUrl)
    private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl();
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetPresignedUploadPartUrl>
        PARSER = new com.google.protobuf.AbstractParser<GetPresignedUploadPartUrl>() {
      @java.lang.Override
      public GetPresignedUploadPartUrl parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetPresignedUploadPartUrl(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<GetPresignedUploadPartUrl> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetPresignedUploadPartUrl> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetPresignedUploadPartUrl getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_ArtifactCredentialInfo_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_ArtifactCredentialInfo_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_GetCredentialsForRead_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_GetCredentialsForRead_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_GetCredentialsForRead_Response_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_GetCredentialsForRead_Response_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_GetCredentialsForWrite_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_GetCredentialsForWrite_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_GetCredentialsForWrite_Response_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_GetCredentialsForWrite_Response_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_CreateMultipartUpload_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_CreateMultipartUpload_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_CreateMultipartUpload_Response_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_CreateMultipartUpload_Response_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_PartEtag_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_PartEtag_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_CompleteMultipartUpload_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_CompleteMultipartUpload_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_CompleteMultipartUpload_Response_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_CompleteMultipartUpload_Response_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_GetPresignedUploadPartUrl_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_GetPresignedUploadPartUrl_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_GetPresignedUploadPartUrl_Response_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_GetPresignedUploadPartUrl_Response_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\032databricks_artifacts.proto\022\006mlflow\032\025sc" +
      "alapb/scalapb.proto\032\020databricks.proto\"\337\001" +
      "\n\026ArtifactCredentialInfo\022\016\n\006run_id\030\001 \001(\t" +
      "\022\014\n\004path\030\002 \001(\t\022\022\n\nsigned_uri\030\003 \001(\t\022:\n\007he" +
      "aders\030\004 \003(\0132).mlflow.ArtifactCredentialI" +
      "nfo.HttpHeader\022,\n\004type\030\005 \001(\0162\036.mlflow.Ar" +
      "tifactCredentialType\032)\n\nHttpHeader\022\014\n\004na" +
      "me\030\001 \001(\t\022\r\n\005value\030\002 \001(\t\"\225\002\n\025GetCredentia" +
      "lsForRead\022\024\n\006run_id\030\001 \001(\tB\004\370\206\031\001\022\014\n\004path\030" +
      "\002 \003(\t\022\022\n\npage_token\030\003 \001(\t\032c\n\010Response\0228\n" +
      "\020credential_infos\030\002 \003(\0132\036.mlflow.Artifac" +
      "tCredentialInfo\022\027\n\017next_page_token\030\003 \001(\t" +
      "J\004\010\001\020\002:_\342?(\n&com.databricks.rpc.RPC[$thi" +
      "s.Response]\342?1\n/com.databricks.mlflow.ap" +
      "i.MlflowTrackingMessage\"\226\002\n\026GetCredentia" +
      "lsForWrite\022\024\n\006run_id\030\001 \001(\tB\004\370\206\031\001\022\014\n\004path" +
      "\030\002 \003(\t\022\022\n\npage_token\030\003 \001(\t\032c\n\010Response\0228" +
      "\n\020credential_infos\030\002 \003(\0132\036.mlflow.Artifa" +
      "ctCredentialInfo\022\027\n\017next_page_token\030\003 \001(" +
      "\tJ\004\010\001\020\002:_\342?(\n&com.databricks.rpc.RPC[$th" +
      "is.Response]\342?1\n/com.databricks.mlflow.a" +
      "pi.MlflowTrackingMessage\"\325\002\n\025CreateMulti" +
      "partUpload\022\024\n\006run_id\030\001 \001(\tB\004\370\206\031\001\022\014\n\004path" +
      "\030\002 \001(\t\022\027\n\tnum_parts\030\003 \001(\003B\004\370\206\031\001\032\235\001\n\010Resp" +
      "onse\022\021\n\tupload_id\030\001 \001(\t\022?\n\027upload_creden" +
      "tial_infos\030\002 \003(\0132\036.mlflow.ArtifactCreden" +
      "tialInfo\022=\n\025abort_credential_info\030\003 \001(\0132" +
      "\036.mlflow.ArtifactCredentialInfo:_\342?(\n&co" +
      "m.databricks.rpc.RPC[$this.Response]\342?1\n" +
      "/com.databricks.mlflow.api.MlflowTrackin" +
      "gMessage\"-\n\010PartEtag\022\023\n\013part_number\030\001 \001(" +
      "\003\022\014\n\004etag\030\002 \001(\t\"\351\001\n\027CompleteMultipartUpl" +
      "oad\022\024\n\006run_id\030\001 \001(\tB\004\370\206\031\001\022\014\n\004path\030\002 \001(\t\022" +
      "\027\n\tupload_id\030\003 \001(\tB\004\370\206\031\001\022$\n\npart_etags\030\004" +
      " \003(\0132\020.mlflow.PartEtag\032\n\n\010Response:_\342?(\n" +
      "&com.databricks.rpc.RPC[$this.Response]\342" +
      "?1\n/com.databricks.mlflow.api.MlflowTrac" +
      "kingMessage\"\240\002\n\031GetPresignedUploadPartUr" +
      "l\022\024\n\006run_id\030\001 \001(\tB\004\370\206\031\001\022\014\n\004path\030\002 \001(\t\022\027\n" +
      "\tupload_id\030\003 \001(\tB\004\370\206\031\001\022\031\n\013part_number\030\004 " +
      "\001(\003B\004\370\206\031\001\032J\n\010Response\022>\n\026upload_credenti" +
      "al_info\030\001 \001(\0132\036.mlflow.ArtifactCredentia" +
      "lInfo:_\342?(\n&com.databricks.rpc.RPC[$this" +
      ".Response]\342?1\n/com.databricks.mlflow.api" +
      ".MlflowTrackingMessage*s\n\026ArtifactCreden" +
      "tialType\022\021\n\rAZURE_SAS_URI\020\001\022\025\n\021AWS_PRESI" +
      "GNED_URL\020\002\022\022\n\016GCP_SIGNED_URL\020\003\022\033\n\027AZURE_" +
      "ADLS_GEN2_SAS_URI\020\0042\343\006\n DatabricksMlflow" +
      "ArtifactsService\022\234\001\n\025getCredentialsForRe" +
      "ad\022\035.mlflow.GetCredentialsForRead\032&.mlfl" +
      "ow.GetCredentialsForRead.Response\"<\362\206\0318\n" +
      "4\n\004POST\022&/mlflow/artifacts/credentials-f" +
      "or-read\032\004\010\002\020\000\020\003\022\240\001\n\026getCredentialsForWri" +
      "te\022\036.mlflow.GetCredentialsForWrite\032\'.mlf" +
      "low.GetCredentialsForWrite.Response\"=\362\206\031" +
      "9\n5\n\004POST\022\'/mlflow/artifacts/credentials" +
      "-for-write\032\004\010\002\020\000\020\003\022\237\001\n\025createMultipartUp" +
      "load\022\035.mlflow.CreateMultipartUpload\032&.ml" +
      "flow.CreateMultipartUpload.Response\"?\362\206\031" +
      ";\n7\n\004POST\022)/mlflow/artifacts/create-mult" +
      "ipart-upload\032\004\010\002\020\000\020\003\022\247\001\n\027completeMultipa" +
      "rtUpload\022\037.mlflow.CompleteMultipartUploa" +
      "d\032(.mlflow.CompleteMultipartUpload.Respo" +
      "nse\"A\362\206\031=\n9\n\004POST\022+/mlflow/artifacts/com" +
      "plete-multipart-upload\032\004\010\002\020\000\020\003\022\260\001\n\031getPr" +
      "esignedUploadPartUrl\022!.mlflow.GetPresign" +
      "edUploadPartUrl\032*.mlflow.GetPresignedUpl" +
      "oadPartUrl.Response\"D\362\206\031@\n<\n\003GET\022//mlflo" +
      "w/artifacts/get-presigned-upload-part-ur" +
      "l\032\004\010\002\020\000\020\003B,\n\037com.databricks.api.proto.ml" +
      "flow\220\001\001\240\001\001\342?\002\020\001"
    };
    descriptor = com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          org.mlflow.scalapb_interface.Scalapb.getDescriptor(),
          com.databricks.api.proto.databricks.Databricks.getDescriptor(),
        });
    internal_static_mlflow_ArtifactCredentialInfo_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_mlflow_ArtifactCredentialInfo_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_ArtifactCredentialInfo_descriptor,
        new java.lang.String[] { "RunId", "Path", "SignedUri", "Headers", "Type", });
    internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor =
      internal_static_mlflow_ArtifactCredentialInfo_descriptor.getNestedTypes().get(0);
    internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor,
        new java.lang.String[] { "Name", "Value", });
    internal_static_mlflow_GetCredentialsForRead_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_mlflow_GetCredentialsForRead_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_GetCredentialsForRead_descriptor,
        new java.lang.String[] { "RunId", "Path", "PageToken", });
    internal_static_mlflow_GetCredentialsForRead_Response_descriptor =
      internal_static_mlflow_GetCredentialsForRead_descriptor.getNestedTypes().get(0);
    internal_static_mlflow_GetCredentialsForRead_Response_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_GetCredentialsForRead_Response_descriptor,
        new java.lang.String[] { "CredentialInfos", "NextPageToken", });
    internal_static_mlflow_GetCredentialsForWrite_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_mlflow_GetCredentialsForWrite_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_GetCredentialsForWrite_descriptor,
        new java.lang.String[] { "RunId", "Path", "PageToken", });
    internal_static_mlflow_GetCredentialsForWrite_Response_descriptor =
      internal_static_mlflow_GetCredentialsForWrite_descriptor.getNestedTypes().get(0);
    internal_static_mlflow_GetCredentialsForWrite_Response_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_GetCredentialsForWrite_Response_descriptor,
        new java.lang.String[] { "CredentialInfos", "NextPageToken", });
    internal_static_mlflow_CreateMultipartUpload_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_mlflow_CreateMultipartUpload_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_CreateMultipartUpload_descriptor,
        new java.lang.String[] { "RunId", "Path", "NumParts", });
    internal_static_mlflow_CreateMultipartUpload_Response_descriptor =
      internal_static_mlflow_CreateMultipartUpload_descriptor.getNestedTypes().get(0);
    internal_static_mlflow_CreateMultipartUpload_Response_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_CreateMultipartUpload_Response_descriptor,
        new java.lang.String[] { "UploadId", "UploadCredentialInfos", "AbortCredentialInfo", });
    internal_static_mlflow_PartEtag_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_mlflow_PartEtag_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_PartEtag_descriptor,
        new java.lang.String[] { "PartNumber", "Etag", });
    internal_static_mlflow_CompleteMultipartUpload_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_mlflow_CompleteMultipartUpload_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_CompleteMultipartUpload_descriptor,
        new java.lang.String[] { "RunId", "Path", "UploadId", "PartEtags", });
    internal_static_mlflow_CompleteMultipartUpload_Response_descriptor =
      internal_static_mlflow_CompleteMultipartUpload_descriptor.getNestedTypes().get(0);
    internal_static_mlflow_CompleteMultipartUpload_Response_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_CompleteMultipartUpload_Response_descriptor,
        new java.lang.String[] { });
    internal_static_mlflow_GetPresignedUploadPartUrl_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_mlflow_GetPresignedUploadPartUrl_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_GetPresignedUploadPartUrl_descriptor,
        new java.lang.String[] { "RunId", "Path", "UploadId", "PartNumber", });
    internal_static_mlflow_GetPresignedUploadPartUrl_Response_descriptor =
      internal_static_mlflow_GetPresignedUploadPartUrl_descriptor.getNestedTypes().get(0);
    internal_static_mlflow_GetPresignedUploadPartUrl_Response_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_GetPresignedUploadPartUrl_Response_descriptor,
        new java.lang.String[] { "UploadCredentialInfo", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.databricks.api.proto.databricks.Databricks.rpc);
    registry.add(com.databricks.api.proto.databricks.Databricks.validateRequired);
    registry.add(org.mlflow.scalapb_interface.Scalapb.message);
    registry.add(org.mlflow.scalapb_interface.Scalapb.options);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    org.mlflow.scalapb_interface.Scalapb.getDescriptor();
    com.databricks.api.proto.databricks.Databricks.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
