/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.conn;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.mlflow_project.apachecommons.logging.Log;
import org.mlflow_project.apachecommons.logging.LogFactory;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.conn.ManagedHttpClientConnection;
import org.mlflow_project.apachehttp.conn.routing.HttpRoute;
import org.mlflow_project.apachehttp.impl.conn.CPoolEntry;
import org.mlflow_project.apachehttp.pool.AbstractConnPool;
import org.mlflow_project.apachehttp.pool.ConnFactory;
import org.mlflow_project.apachehttp.pool.PoolEntryCallback;

@Contract(threading=ThreadingBehavior.SAFE)
class CPool
extends AbstractConnPool<HttpRoute, ManagedHttpClientConnection, CPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit tunit;

    public CPool(ConnFactory<HttpRoute, ManagedHttpClientConnection> connFactory, int defaultMaxPerRoute, int maxTotal, long timeToLive, TimeUnit tunit) {
        super(connFactory, defaultMaxPerRoute, maxTotal);
        this.timeToLive = timeToLive;
        this.tunit = tunit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute route, ManagedHttpClientConnection conn) {
        String id = Long.toString(COUNTER.getAndIncrement());
        return new CPoolEntry(this.log, id, route, conn, this.timeToLive, this.tunit);
    }

    @Override
    protected boolean validate(CPoolEntry entry) {
        return !((ManagedHttpClientConnection)entry.getConnection()).isStale();
    }

    @Override
    protected void enumAvailable(PoolEntryCallback<HttpRoute, ManagedHttpClientConnection> callback) {
        super.enumAvailable(callback);
    }

    @Override
    protected void enumLeased(PoolEntryCallback<HttpRoute, ManagedHttpClientConnection> callback) {
        super.enumLeased(callback);
    }
}

