/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.spark.autologging;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.mlflow.spark.autologging.DatasourceAttributeExtractorBase;
import org.mlflow.spark.autologging.ExceptionUtils$;
import org.mlflow.spark.autologging.ReflectionUtils$;
import org.mlflow.spark.autologging.SparkTableInfo;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.util.control.NonFatal$;

public final class ReplAwareDatasourceAttributeExtractor$
implements DatasourceAttributeExtractorBase {
    public static ReplAwareDatasourceAttributeExtractor$ MODULE$;
    private final Logger logger;

    static {
        new ReplAwareDatasourceAttributeExtractor$();
    }

    @Override
    public Option<SparkTableInfo> getTableInfoToLog(LogicalPlan leafNode) {
        return DatasourceAttributeExtractorBase.getTableInfoToLog$(this, leafNode);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void org$mlflow$spark$autologging$DatasourceAttributeExtractorBase$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Option<SparkTableInfo> maybeGetDeltaTableInfo(LogicalPlan leafNode) {
        LogicalPlan logicalPlan = leafNode;
        if (logicalPlan instanceof LogicalRelation) {
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan;
            Object obj = ReflectionUtils$.MODULE$.getScalaObjectByName("com.databricks.sql.transaction.tahoe.DeltaTable");
            Option deltaFileIndexOpt = (Option)ReflectionUtils$.MODULE$.callMethod(obj, "unapply", (Seq<Object>)((Seq)new .colon.colon((Object)logicalRelation, (List)Nil$.MODULE$)));
            return deltaFileIndexOpt.map((Function1 & Serializable & scala.Serializable)fileIndex -> {
                String path = ReflectionUtils$.MODULE$.getField(fileIndex, "path").toString();
                Option versionOpt = Option$.MODULE$.apply(ReflectionUtils$.MODULE$.callMethod(fileIndex, "tableVersion", (Seq<Object>)((Seq)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString());
                return new SparkTableInfo(path, (Option<String>)versionOpt, (Option<String>)Option$.MODULE$.apply((Object)"delta"));
            });
        }
        return None$.MODULE$;
    }

    private String tryRedactString(String value) {
        String string;
        try {
            Object redactor = ReflectionUtils$.MODULE$.getScalaObjectByName("com.databricks.spark.util.DatabricksSparkLogRedactor");
            string = (String)ReflectionUtils$.MODULE$.callMethod(redactor, "redact", (Seq<Object>)((Seq)new .colon.colon((Object)value, (List)Nil$.MODULE$)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String msg = ExceptionUtils$.MODULE$.getUnexpectedExceptionMessage(e, "while applying redaction to datasource paths");
                this.logger().error(msg);
                throw e;
            }
            throw throwable;
        }
        return string;
    }

    private SparkTableInfo applyRedaction(SparkTableInfo tableInfo) {
        SparkTableInfo sparkTableInfo = tableInfo;
        if (sparkTableInfo != null) {
            String path = sparkTableInfo.path();
            Option<String> versionOpt = sparkTableInfo.versionOpt();
            Option<String> formatOpt = sparkTableInfo.formatOpt();
            return new SparkTableInfo(this.tryRedactString(path), versionOpt, formatOpt);
        }
        throw new MatchError((Object)sparkTableInfo);
    }

    @Override
    public Seq<SparkTableInfo> getTableInfos(SparkListenerSQLExecutionEnd event) {
        return (Seq)DatasourceAttributeExtractorBase.getTableInfos$(this, event).map((Function1 & Serializable & scala.Serializable)tableInfo -> MODULE$.applyRedaction((SparkTableInfo)tableInfo), Seq$.MODULE$.canBuildFrom());
    }

    private ReplAwareDatasourceAttributeExtractor$() {
        MODULE$ = this;
        DatasourceAttributeExtractorBase.$init$(this);
    }
}

