/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.spark.autologging;

import java.io.Serializable;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.mlflow.spark.autologging.DatasourceAttributeExtractorBase;
import org.mlflow.spark.autologging.MlflowAutologEventPublisherImpl;
import org.mlflow.spark.autologging.ReplAwareDatasourceAttributeExtractor$;
import org.mlflow.spark.autologging.ReplAwareSparkDataSourceListener$;
import org.mlflow.spark.autologging.SparkDataSourceListener;
import org.mlflow.spark.autologging.SparkTableInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\b\u0010\u0001aA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\u0006C\u0001!\tA\t\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u0011\u0019\u0001\u0005\u0001)A\u0005O!)\u0011\t\u0001C)\u0005\"1a\t\u0001C\u0001\u001f\u001dCQ!\u0016\u0001\u0005BYCaa\u0017\u0001\u0005R=a\u0006\"\u00025\u0001\t\u0013Iwa\u00028\u0010\u0003\u0003E\ta\u001c\u0004\b\u001d=\t\t\u0011#\u0001q\u0011\u0015\t3\u0002\"\u0001u\u0011\u001d)8\"%A\u0005\u0002Y\u0014\u0001EU3qY\u0006;\u0018M]3Ta\u0006\u00148\u000eR1uCN{WO]2f\u0019&\u001cH/\u001a8fe*\u0011\u0001#E\u0001\fCV$x\u000e\\8hO&twM\u0003\u0002\u0013'\u0005)1\u000f]1sW*\u0011A#F\u0001\u0007[24Gn\\<\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iYR\"A\b\n\u0005qy!aF*qCJ\\G)\u0019;b'>,(oY3MSN$XM\\3s\u0003%\u0001XO\u00197jg\",'\u000f\u0005\u0002\u001b?%\u0011\u0001e\u0004\u0002 \u001b24Gn\\<BkR|Gn\\4Fm\u0016tG\u000fU;cY&\u001c\b.\u001a:J[Bd\u0017A\u0002\u001fj]&$h\b\u0006\u0002$IA\u0011!\u0004\u0001\u0005\b;\t\u0001\n\u00111\u0001\u001f\u0003M)\u00070Z2vi&|g.\u00133U_J+\u0007\u000f\\%e+\u00059\u0003\u0003\u0002\u00150cUj\u0011!\u000b\u0006\u0003U-\nq!\\;uC\ndWM\u0003\u0002-[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0015\u0003\u00075\u000b\u0007\u000f\u0005\u00023g5\tQ&\u0003\u00025[\t!Aj\u001c8h!\t1TH\u0004\u00028wA\u0011\u0001(L\u0007\u0002s)\u0011!hF\u0001\u0007yI|w\u000e\u001e \n\u0005qj\u0013A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001P\u0017\u0002)\u0015DXmY;uS>t\u0017\n\u001a+p%\u0016\u0004H.\u00133!\u0003}9W\r\u001e#bi\u0006\u001cx.\u001e:dK\u0006#HO]5ckR,W\t\u001f;sC\u000e$xN]\u000b\u0002\u0007B\u0011!\u0004R\u0005\u0003\u000b>\u0011\u0001\u0005R1uCN|WO]2f\u0003R$(/\u001b2vi\u0016,\u0005\u0010\u001e:bGR|'OQ1tK\u0006iq-\u001a;Qe>\u0004XM\u001d;jKN$\"\u0001\u0013&\u0011\tYJU'N\u0005\u0003a}BQa\u0013\u0004A\u00021\u000bQ!\u001a<f]R\u0004\"!T*\u000e\u00039S!a\u0014)\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\nR\u0015\t\u0011V#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003):\u0013Qc\u00159be.d\u0015n\u001d;f]\u0016\u0014(j\u001c2Ti\u0006\u0014H/\u0001\u0006p]*{'m\u0015;beR$\"a\u0016.\u0011\u0005IB\u0016BA-.\u0005\u0011)f.\u001b;\t\u000b-;\u0001\u0019\u0001'\u0002#=t7+\u0015'Fq\u0016\u001cW\u000f^5p]\u0016sG\r\u0006\u0002X;\")1\n\u0003a\u0001=B\u0011qLZ\u0007\u0002A*\u0011\u0011MY\u0001\u0003k&T!a\u00193\u0002\u0013\u0015DXmY;uS>t'BA3Q\u0003\r\u0019\u0018\u000f\\\u0005\u0003O\u0002\u0014Ad\u00159be.d\u0015n\u001d;f]\u0016\u00148+\u0015'Fq\u0016\u001cW\u000f^5p]\u0016sG-\u0001\u0007q_B\u0014V\r\u001d7JI>\u0003H\u000f\u0006\u0002k[B\u0019!g[\u001b\n\u00051l#AB(qi&|g\u000eC\u0003L\u0013\u0001\u0007a,\u0001\u0011SKBd\u0017i^1sKN\u0003\u0018M]6ECR\f7k\\;sG\u0016d\u0015n\u001d;f]\u0016\u0014\bC\u0001\u000e\f'\tY\u0011\u000f\u0005\u00023e&\u00111/\f\u0002\u0007\u0003:L(+\u001a4\u0015\u0003=\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT#A<+\u0005yA8&A=\u0011\u0005i|X\"A>\u000b\u0005ql\u0018!C;oG\",7m[3e\u0015\tqX&\u0001\u0006b]:|G/\u0019;j_:L1!!\u0001|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ReplAwareSparkDataSourceListener
extends SparkDataSourceListener {
    private final MlflowAutologEventPublisherImpl publisher;
    private final Map<Object, String> executionIdToReplId;

    public static MlflowAutologEventPublisherImpl $lessinit$greater$default$1() {
        return ReplAwareSparkDataSourceListener$.MODULE$.$lessinit$greater$default$1();
    }

    private Map<Object, String> executionIdToReplId() {
        return this.executionIdToReplId;
    }

    @Override
    public DatasourceAttributeExtractorBase getDatasourceAttributeExtractor() {
        return ReplAwareDatasourceAttributeExtractor$.MODULE$;
    }

    public scala.collection.immutable.Map<String, String> getProperties(SparkListenerJobStart event) {
        return (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)event.properties()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(x$1).asScala()).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    public void onJobStart(SparkListenerJobStart event) {
        scala.collection.immutable.Map<String, String> properties = this.getProperties(event);
        Option executionIdOpt = properties.get((Object)SQLExecution$.MODULE$.EXECUTION_ID_KEY()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ReplAwareSparkDataSourceListener.$anonfun$onJobStart$1(x$2)));
        if (executionIdOpt.isEmpty()) {
            this.logger().warn(new StringBuilder(121).append("Unable to find execution ID of current Spark Job, ").append("refusing to autolog datasource reads performed within current Spark job").toString());
            return;
        }
        long executionId = BoxesRunTime.unboxToLong((Object)executionIdOpt.get());
        Option replIdOpt = properties.get((Object)"spark.databricks.replId");
        if (replIdOpt.isEmpty()) {
            this.logger().warn(new StringBuilder(147).append("Unable to find ID of REPL that triggered current Spark Job (execution ID ").append(executionId).append("), ").append("refusing to autolog datasource reads performed within current Spark job").toString());
            return;
        }
        this.executionIdToReplId().put((Object)BoxesRunTime.boxToLong((long)executionId), replIdOpt.get());
    }

    @Override
    public void onSQLExecutionEnd(SparkListenerSQLExecutionEnd event) {
        DatasourceAttributeExtractorBase extractor = this.getDatasourceAttributeExtractor();
        Seq<SparkTableInfo> tableInfos = extractor.getTableInfos(event);
        Option<String> replIdOpt = this.popReplIdOpt(event);
        if (replIdOpt.isDefined()) {
            tableInfos.foreach((Function1 & Serializable & scala.Serializable)tableInfo -> {
                this.publisher.publishEvent((Option<String>)replIdOpt, tableInfo);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Option<String> popReplIdOpt(SparkListenerSQLExecutionEnd event) {
        return this.executionIdToReplId().remove((Object)BoxesRunTime.boxToLong((long)event.executionId()));
    }

    public static final /* synthetic */ long $anonfun$onJobStart$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public ReplAwareSparkDataSourceListener(MlflowAutologEventPublisherImpl publisher) {
        this.publisher = publisher;
        super(publisher);
        this.executionIdToReplId = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

