package org.mmbase.util.transformers;

import java.util.*;

/**
 * Provides the (unmodifiable) map 'iso2htmlMappings'
 * 
 * @since MMBase-1.9.1
 * @author Michiel Meeuwissen
 * @version $Id$
 */

class Iso1 {
    public static final char ENTITY_START = '&';
    public static final char ENTITY_END = ';';
    
    public static final Map<String, String> iso2htmlMappings;
    static {
        String[] mappingArray = new String[] {
            "quot",   "\"",
            "am;",    "&",
            "lt",     "<",
            "gt",     ">",
            "nbsp",   " ",
            "iexcl",  "\u00a1",
            "cent",   "\u00a2",
            "pound",  "\u00a3",
            "curren", "\u00a4",
            "yen",    "\u00a5",
            "brvbar", "\u00a6",
            "sect",   "\u00a7",
            "uml",    "\u00a8",
            "copy",   "\u00a9",
            "ordf",   "\u00aa",
            "laquo",  "\u00ab",
            "not",    "\u00ac",
            "shy",    "\u00ad",
            "reg",    "\u00ae",
            "macr",   "\u00af",
            "deg",    "\u00b0",
            "plusmn", "\u00b1",
            "sup2",   "\u00b2",
            "sup3",   "\u00b3",
            "acute",  "\u00b4",
            "micro",  "\u00b5",
            "para",   "\u00b6",
            "middot", "\u00b7",
            "cedil",  "\u00b8",
            "sup1",   "\u00b9",
            "ordm",   "\u00ba",
            "raquo",  "\u00bb",
            "frac14", "\u00bc",
            "frac12", "\u00bd",
            "frac34", "\u00be",
            "iquest", "\u00bf",
            "Agrave", "\u00c0",
            "Aacute", "\u00c1",
            "Acirc",  "\u00c2",
            "Atilde", "\u00c3",
            "Auml",   "\u00c4",
            "Aring",  "\u00c5",
            "AElig",  "\u00c6",
            "Ccedil", "\u00c7",
            "Egrave", "\u00c8",
            "Eacute", "\u00c9",
            "Ecirc",  "\u00ca",
            "Euml",   "\u00cb",
            "Igrave", "\u00cc",
            "Iacute", "\u00cd",
            "Icirc",  "\u00ce",
            "Iuml",   "\u00cf",
            "ETH",    "\u00d0",
            "Ntilde", "\u00d1",
            "Ograve", "\u00d2",
            "Oacute", "\u00d3",
            "Ocirc",  "\u00d4",
            "Otilde", "\u00d5",
            "Ouml",   "\u00d6",
            "times",  "\u00d7",
            "Oslash", "\u00d8",
            "Ugrave", "\u00d9",
            "Uacute", "\u00da",
            "Ucirc",  "\u00db",
            "Uuml",   "\u00dc",
            "Yacute", "\u00dd",
            "THORN",  "\u00de",
            "szlig",  "\u00df",
            "agrave", "\u00e0",
            "aacute", "\u00e1",
            "acirc",  "\u00e2",
            "atilde", "\u00e3",
            "auml",   "\u00e4",
            "aring",  "\u00e5",
            "aelig",  "\u00e6",
            "ccedil", "\u00e7",
            "egrave", "\u00e8",
            "eacute", "\u00e9",
            "ecirc",  "\u00ea",
            "euml",   "\u00eb",
            "igrave", "\u00ec",
            "iacute", "\u00ed",
            "icirc",  "\u00ee",
            "iuml",   "\u00ef",
            "eth",    "\u00f0",
            "ntilde", "\u00f1",
            "ograve", "\u00f2",
            "oacute", "\u00f3",
            "ocirc",  "\u00f4",
            "otilde", "\u00f5",
            "ouml",   "\u00f6",
            "divide", "\u00f7",
            "oslash", "\u00f8",
            "ugrave", "\u00f9",
            "uacute", "\u00fa",
            "ucirc",  "\u00fb",
            "uuml",   "\u00fc",
            "yacute", "\u00fd",
            "thorn",  "\u00fe",
            "yuml",   "\u00ff",
				
            "#34",  "\"",
            "#38",  "",
            "#60",  "<",
            "#62",  ">",
            "#160", " ",
            "#161", "\u00a1",
            "#162", "\u00a2",
            "#163", "\u00a3",
            "#164", "\u00a4",
            "#165", "\u00a5",
            "#166", "\u00a6",
            "#167", "\u00a7",
            "#168", "\u00a8",
            "#169", "\u00a9",
            "#170", "\u00aa",
            "#171", "\u00ab",
            "#172", "\u00ac",
            "#173", "\u00ad",
            "#174", "\u00ae",
            "#175", "\u00af",
            "#176", "\u00b0",
            "#177", "\u00b1",
            "#178", "\u00b2",
            "#179", "\u00b3",
            "#180", "\u00b4",
            "#181", "\u00b5",
            "#182", "\u00b6",
            "#183", "\u00b7",
            "#184", "\u00b8",
            "#185", "\u00b9",
            "#186", "\u00ba",
            "#187", "\u00bb",
            "#188", "\u00bc",
            "#189", "\u00bd",
            "#190", "\u00be",
            "#191", "\u00bf",
            "#192", "\u00c0",
            "#193", "\u00c1",
            "#194", "\u00c2",
            "#195", "\u00c3",
            "#196", "\u00c4",
            "#197", "\u00c5",
            "#198", "\u00c6",
            "#199", "\u00c7",
            "#200", "\u00c8",
            "#201", "\u00c9",
            "#202", "\u00ca",
            "#203", "\u00cb",
            "#204", "\u00cc",
            "#205", "\u00cd",
            "#206", "\u00ce",
            "#207", "\u00cf",
            "#208", "\u00d0",
            "#209", "\u00d1",
            "#210", "\u00d2",
            "#211", "\u00d3",
            "#212", "\u00d4",
            "#213", "\u00d5",
            "#214", "\u00d6",
            "#215", "\u00d7",
            "#216", "\u00d8",
            "#217", "\u00d9",
            "#218", "\u00da",
            "#219", "\u00db",
            "#220", "\u00dc",
            "#221", "\u00dd",
            "#222", "\u00de",
            "#223", "\u00df",
            "#224", "\u00e0",
            "#225", "\u00e1",
            "#226", "\u00e2",
            "#227", "\u00e3",
            "#228", "\u00e4",
            "#229", "\u00e5",
            "#230", "\u00e6",
            "#231", "\u00e7",
            "#232", "\u00e8",
            "#233", "\u00e9",
            "#234", "\u00ea",
            "#235", "\u00eb",
            "#236", "\u00ec",
            "#237", "\u00ed",
            "#238", "\u00ee",
            "#239", "\u00ef",
            "#240", "\u00f0",
            "#241", "\u00f1",
            "#242", "\u00f2",
            "#243", "\u00f3",
            "#244", "\u00f4",
            "#245", "\u00f5",
            "#246", "\u00f6",
            "#247", "\u00f7",
            "#248", "\u00f8",
            "#249", "\u00f9",
            "#250", "\u00fa",
            "#251", "\u00fb",
            "#252", "\u00fc",
            "#253", "\u00fd",
            "#254", "\u00fe",
            "#255", "\u00ff"
        };
        Map<String, String> mappings = new HashMap<String, String>();
        for (int i = 0; i < mappingArray.length; i += 2) {
            mappings.put(mappingArray[i], mappingArray[i + 1]);
        }
        iso2htmlMappings = Collections.unmodifiableMap(mappings);
        
    }
}

