/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class Version {
    private static final Logger LOG = Logging.getLoggerInstance(Version.class);
    private static final Pattern SCM = Pattern.compile("\\$URL: https://scm.mmbase.org/mmbase/(.*)");
    private static final String VERSION_CLASS = "org/mmbase/Version.class";
    private static Manifest manifest;
    private static boolean manifestLoaded;

    public static String getTag() {
        String url = "$URL: https://scm.mmbase.org/mmbase/trunk/utils/src/main/java/org/mmbase/Version.java $";
        Matcher matcher = SCM.matcher(url);
        if (matcher.matches()) {
            String[] group = matcher.group(1).split("/", 3);
            if (group[0].equals("tags") || group[0].equals("branches")) {
                return group[1];
            }
            return group[0];
        }
        return "trunk?";
    }

    public static String getName() {
        return "MMBase";
    }

    public static int getMajor() {
        return 2;
    }

    public static int getMinor() {
        return 0;
    }

    public static int getPatchLevel() {
        return 0;
    }

    public static String getBuildDate() {
        Manifest man = Version.getManifest();
        if (man != null) {
            return man.getAttributes("org/mmbase").getValue("Build-Date");
        }
        return "";
    }

    public static String getSCMRevision() {
        Manifest man = Version.getManifest();
        if (man != null) {
            return man.getAttributes("org/mmbase").getValue("SCM-Revision");
        }
        return "?";
    }

    public static String getNumber() {
        return Version.getMajor() + "." + Version.getMinor() + "." + Version.getPatchLevel() + (Version.isRelease() ? "-" + Version.getReleaseStatus() + " " : ".") + Version.getBuildDate();
    }

    public static boolean isRelease() {
        return false;
    }

    public static String getReleaseStatus() {
        return "";
    }

    public static String get() {
        String tag = Version.getTag();
        if (tag.startsWith("MMBase")) {
            return tag + " " + Version.getBuildDate() + " (r" + Version.getSCMRevision() + ")";
        }
        return Version.getName() + " " + Version.getNumber() + " (r" + Version.getSCMRevision() + ")";
    }

    public static Manifest getManifest() {
        if (!manifestLoaded) {
            try {
                URL url = Version.class.getClassLoader().getResource(VERSION_CLASS);
                String u = url.toString();
                String[] parts = u.split("!", 2);
                if (parts.length == 2) {
                    URL jarUrl = new URL(parts[0] + "!/");
                    JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
                    manifest = jarConnection.getManifest();
                }
            }
            catch (IOException ioe) {
                LOG.warn(ioe);
            }
            manifestLoaded = true;
        }
        return manifest;
    }

    public static void main(String[] args) {
        System.out.println(Version.get());
    }

    private Version() {
    }

    static {
        manifestLoaded = false;
    }
}

