/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.cache;

import org.mmbase.cache.Cache;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public abstract class BlobCache
extends Cache<String, Object> {
    private static final Logger log = Logging.getLoggerInstance(BlobCache.class);

    public BlobCache(int size) {
        super(size);
    }

    @Override
    protected int getDefaultMaxEntrySize() {
        return 102400;
    }

    @Override
    public String getName() {
        return "A Blob Cache";
    }

    @Override
    public String getDescription() {
        return "Node number - field Name-> ByteArray";
    }

    public final String getKey(int nodeNumber, String fieldName) {
        return "" + nodeNumber + '-' + fieldName;
    }

    @Override
    public Object put(String key, Object value) {
        if (!this.checkCachePolicy(key)) {
            return null;
        }
        if (value instanceof byte[]) {
            int max = this.getMaxEntrySize();
            byte[] b = (byte[])value;
            log.trace(" max " + max + " " + b.length);
            if (max > 0 && b.length > max) {
                return null;
            }
        } else if (value instanceof String) {
            int max = this.getMaxEntrySize();
            String s = (String)value;
            if (max > 0 && s.length() > this.getMaxEntrySize()) {
                return null;
            }
        }
        return super.put(key, value);
    }
}

