/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.cache;

import java.lang.management.ManagementFactory;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.mmbase.cache.Cache;
import org.mmbase.cache.CacheManagerMBean;
import org.mmbase.core.event.EventManager;
import org.mmbase.core.event.SystemEvent;
import org.mmbase.core.event.SystemEventListener;
import org.mmbase.util.Entry;
import org.mmbase.util.MMBaseContext;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.ResourceWatcher;
import org.mmbase.util.SizeOf;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.Identifier;
import org.mmbase.util.xml.DocumentReader;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CacheManager
implements CacheManagerMBean,
SystemEventListener {
    private static final Logger log = Logging.getLoggerInstance(CacheManager.class);
    private final Map<String, Cache<?, ?>> caches = new ConcurrentHashMap();
    private static CacheManager instance = null;
    private String machineName;
    private static DocumentReader configReader = null;
    private static final ResourceWatcher configWatcher = new ResourceWatcher(){

        @Override
        public void onChange(String resource) {
            try {
                InputSource is = ResourceLoader.getConfigurationRoot().getInputSource(resource);
                if (is == null) {
                    log.warn("Not found " + resource + " in " + ResourceLoader.getConfigurationRoot());
                    return;
                }
                log.service("Reading " + is.getSystemId());
                configReader = new DocumentReader(is, Cache.class);
            }
            catch (Exception e) {
                log.warn(e.getClass() + " " + e.getMessage(), e);
                return;
            }
            CacheManager.configure(configReader);
        }
    };

    private CacheManager() {
    }

    private String getMachineName() {
        return this.machineName;
    }

    public static CacheManager getInstance() {
        if (instance == null) {
            instance = new CacheManager();
            instance.register();
            EventManager.getInstance().addEventListener(instance);
        }
        return instance;
    }

    private void register() {
        ObjectName on;
        this.machineName = MMBaseContext.getMachineName();
        Hashtable<String, String> props = new Hashtable<String, String>();
        try {
            props.put("type", "Caches");
            try {
                String machineName = this.getMachineName();
                if (machineName != null) {
                    props.put("type", machineName);
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
            on = new ObjectName("org.mmbase", props);
        }
        catch (MalformedObjectNameException mfone) {
            log.warn("" + props + " " + mfone);
            return;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(instance, on);
            log.service("Registered " + on);
        }
        catch (JMException jmo) {
            log.warn("" + on + " " + jmo.getClass() + " " + jmo.getMessage());
        }
        catch (Throwable t) {
            log.error("" + on + " " + t.getClass() + " " + t.getMessage());
        }
    }

    public static Cache getCache(String name) {
        return CacheManager.getInstance().caches.get(name);
    }

    public static Bean getBean(String name) {
        return new Bean(CacheManager.getCache(name));
    }

    public static Set<Bean> getCaches(String className) {
        TreeSet<Bean> result = new TreeSet<Bean>();
        for (Cache<?, ?> c : CacheManager.getInstance().caches.values()) {
            try {
                if (className != null && !"".equals(className) && !Class.forName(className).isInstance(c)) continue;
                result.add(new Bean(c));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Set<String> getCaches() {
        return Collections.unmodifiableSet(CacheManager.getInstance().caches.keySet());
    }

    public static Map<String, Cache<?, ?>> getMap() {
        return Collections.unmodifiableMap(CacheManager.getInstance().caches);
    }

    public static <K, V> Cache<K, V> putCache(Cache<K, V> cache) {
        Cache<K, V> old = CacheManager.getInstance().caches.put(cache.getName(), cache);
        try {
            CacheManager.configure(configReader, cache.getName());
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        CacheManager.getInstance().register(cache);
        return old;
    }

    private void register(Cache cache) {
        ObjectName name = this.getObjectName(cache);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(cache, name);
        }
        catch (JMException jmo) {
            log.warn("" + name + " " + jmo.getClass() + " " + jmo.getMessage());
        }
        catch (Throwable t) {
            log.error("" + name + " " + t.getClass() + " " + t.getMessage());
        }
    }

    private ObjectName getObjectName(Cache cache) {
        StringBuilder buf = new StringBuilder("org.mmbase:");
        try {
            buf.append("type=Caches");
            Identifier identifier = new Identifier();
            String machineName = this.getMachineName();
            if (machineName != null) {
                buf.append(",mmb=").append(machineName);
            }
            if (cache != null) {
                buf.append(",name=").append(identifier.transform(cache.getName()));
            }
            return new ObjectName(buf.toString());
        }
        catch (MalformedObjectNameException mfone) {
            log.warn("" + buf + " " + mfone);
            return null;
        }
    }

    private static void configure(DocumentReader file) {
        CacheManager.configure(file, null);
    }

    private static void configure(DocumentReader xmlReader, String only) {
        if (xmlReader == null) {
            return;
        }
        if (only == null) {
            log.service("Configuring caches with " + xmlReader.getSystemId());
        } else if (log.isDebugEnabled()) {
            log.debug("Configuring cache " + only + " with file " + xmlReader.getSystemId());
        }
        for (Element cacheElement : xmlReader.getChildElements("caches", "cache")) {
            String cacheName = cacheElement.getAttribute("name");
            if (only != null && !only.equals(cacheName)) continue;
            Cache cache = CacheManager.getCache(cacheName);
            if (cache == null) {
                log.service("No cache " + cacheName + " is present (perhaps not used yet?)");
                continue;
            }
            cache.configure(cacheElement);
        }
    }

    public static int getTotalByteSize() {
        int len = 0;
        SizeOf sizeof = new SizeOf();
        for (Map.Entry<String, Cache<?, ?>> entry : CacheManager.getInstance().caches.entrySet()) {
            len += sizeof.sizeof((Object)entry.getKey()) + sizeof.sizeof((Object)entry.getValue());
        }
        return len;
    }

    private void unRegister() {
        ObjectName name;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        log.info("Clearing and unregistering all caches");
        log.debug(mbs.queryNames(this.getObjectName(null), null));
        for (Cache<?, ?> cache : this.caches.values()) {
            cache.clear();
            name = this.getObjectName(cache);
            if (!mbs.isRegistered(name)) continue;
            try {
                mbs.unregisterMBean(name);
            }
            catch (JMException jmo) {
                log.warn("" + name + " " + jmo.getClass() + " " + jmo.getMessage() + " " + mbs.queryNames(null, null));
            }
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("type", "Caches");
        String machineName = MMBaseContext.getMachineName();
        if (machineName != null) {
            props.put("type", machineName);
        }
        try {
            name = new ObjectName("org.mmbase", props);
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
        }
        catch (JMException jMException) {
            // empty catch block
        }
        if (mbs.queryNames(this.getObjectName(null), null).size() > 0) {
            log.warn("Didn't unregister all caches" + mbs.queryNames(this.getObjectName(null), null));
        }
    }

    public static void shutdown() {
        CacheManager.getInstance().unRegister();
        CacheManager.getInstance().caches.clear();
        instance = null;
    }

    public static Object remove(String name, Object key) {
        Cache cache = CacheManager.getCache(name);
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        log.service("Removing " + key + " from " + cache);
        return cache.remove(key);
    }

    @Override
    public String clear(String pattern) {
        if (pattern == null) {
            pattern = ".*";
        }
        StringBuilder buf = new StringBuilder();
        Pattern p = Pattern.compile(pattern);
        for (Map.Entry<String, Cache<?, ?>> entry : this.caches.entrySet()) {
            if (!p.matcher(entry.getKey()).matches()) continue;
            buf.append("Clearing ").append(entry.getValue()).append("\n");
            entry.getValue().clear();
        }
        if (buf.length() == 0) {
            buf.append("The regular expression '").append(pattern).append("' matched no cache at all");
        }
        return buf.toString();
    }

    @Override
    public String enable(String pattern) {
        if (pattern == null) {
            pattern = ".*";
        }
        StringBuilder buf = new StringBuilder();
        Pattern p = Pattern.compile(pattern);
        for (Map.Entry<String, Cache<?, ?>> entry : this.caches.entrySet()) {
            if (!p.matcher(entry.getKey()).matches()) continue;
            Cache<?, ?> c = entry.getValue();
            if (c.isActive()) {
                buf.append("Already active ").append(c).append("\n");
                continue;
            }
            c.setActive(true);
            buf.append("Making active ").append(c).append("\n");
        }
        if (buf.length() == 0) {
            buf.append("The regular expression '").append(pattern).append("' matched no cache at all");
        }
        return buf.toString();
    }

    @Override
    public String disable(String pattern) {
        if (pattern == null) {
            pattern = ".*";
        }
        StringBuilder buf = new StringBuilder();
        Pattern p = Pattern.compile(pattern);
        for (Map.Entry<String, Cache<?, ?>> entry : this.caches.entrySet()) {
            if (!p.matcher(entry.getKey()).matches()) continue;
            Cache<?, ?> c = entry.getValue();
            if (c.isActive()) {
                c.setActive(false);
                buf.append("Making inactive ").append(c).append("\n");
                continue;
            }
            buf.append("Already inactive ").append(c).append("\n");
        }
        if (buf.length() == 0) {
            buf.append("The regular expression '").append(pattern).append("' matched no cache at all");
        }
        return buf.toString();
    }

    @Override
    public String readConfiguration() {
        configWatcher.onChange("caches.xml");
        return "Read " + ResourceLoader.getConfigurationRoot().getResource("caches.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(SystemEvent event) {
        if (event instanceof SystemEvent.MachineName) {
            SystemEvent.MachineName mn = (SystemEvent.MachineName)event;
            Map<String, Cache<?, ?>> map = this.caches;
            synchronized (map) {
                this.unRegister();
                this.machineName = mn.getMachine();
                this.register();
                for (Cache<?, ?> c : this.caches.values()) {
                    this.register(c);
                }
            }
        }
    }

    @Override
    public int getWeight() {
        return 0;
    }

    static {
        try {
            log.debug("Static init of Caches");
            configWatcher.add("caches.xml");
            configWatcher.onChange("caches.xml");
            configWatcher.setDelay(10000L);
            configWatcher.start();
        }
        catch (Throwable t) {
            log.error(t);
        }
    }

    public static class Bean<K, V>
    implements Comparable<Bean<?, ?>> {
        private final Cache cache;

        public Bean(Cache<K, V> c) {
            this.cache = c;
        }

        public String getName() {
            return this.cache.getName();
        }

        public String getDescription() {
            return this.cache.getDescription();
        }

        public int getMaxEntrySize() {
            return this.cache.getMaxEntrySize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Map.Entry<K, V>> getEntrySet() {
            Object object = this.cache.getLock();
            synchronized (object) {
                return new HashSet(this.cache.entrySet());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<K> getKeySet() {
            Object object = this.cache.getLock();
            synchronized (object) {
                return new HashSet(this.cache.keySet());
            }
        }

        public long getHits() {
            return this.cache.getHits();
        }

        public long getMisses() {
            return this.cache.getMisses();
        }

        public long getPuts() {
            return this.cache.getPuts();
        }

        public int getMaxSize() {
            return this.cache.maxSize();
        }

        public int getSize() {
            return this.cache.size();
        }

        public double getRatio() {
            return this.cache.getRatio();
        }

        public String getStats() {
            return this.cache.getStats();
        }

        public String toString() {
            return this.cache.toString();
        }

        public boolean isActive() {
            return this.cache.isActive();
        }

        public int getByteSize() {
            return this.cache.getByteSize();
        }

        public int getCheapByteSize() {
            return this.cache.getCheapByteSize();
        }

        public boolean isEmpty() {
            return this.cache.isEmpty();
        }

        public Map<K, V> getMap() {
            return this.cache;
        }

        public Map<K, Integer> getCounts() {
            return new AbstractMap<K, Integer>(){

                @Override
                public Set<Map.Entry<K, Integer>> entrySet() {
                    return new AbstractSet<Map.Entry<K, Integer>>(){

                        @Override
                        public int size() {
                            return cache.size();
                        }

                        @Override
                        public Iterator<Map.Entry<K, Integer>> iterator() {
                            return new Iterator<Map.Entry<K, Integer>>(){
                                private Iterator<K> iterator;
                                {
                                    this.iterator = this.getKeySet().iterator();
                                }

                                @Override
                                public boolean hasNext() {
                                    return this.iterator.hasNext();
                                }

                                @Override
                                public Map.Entry<K, Integer> next() {
                                    Object key = this.iterator.next();
                                    return new Entry(key, cache.getCount(key));
                                }

                                @Override
                                public void remove() {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                    };
                }
            };
        }

        public boolean equals(Object o) {
            return o instanceof Bean && ((Bean)o).cache.equals(this.cache);
        }

        public int hashCode() {
            return this.cache.hashCode();
        }

        @Override
        public int compareTo(Bean<?, ?> bean) {
            return this.getName().compareTo(bean.getName());
        }
    }
}

