/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.cache.implementation;

import java.util.Random;
import org.mmbase.cache.CacheImplementationInterface;
import org.mmbase.cache.implementation.LRUCache;

public class Test {
    public static void main(String[] argv) throws Exception {
        Class impl = LRUCache.class;
        int treesiz = 1024;
        int opers = 1000000;
        int thrds = 1;
        try {
            if (argv.length > 0) {
                treesiz = Integer.parseInt(argv[0]);
            }
            if (argv.length > 1) {
                opers = Integer.parseInt(argv[1]);
            }
            if (argv.length > 2) {
                thrds = Integer.parseInt(argv[2]);
            }
            if (argv.length > 3) {
                impl = Class.forName(argv[3]);
            }
        }
        catch (Exception e) {
            System.out.println("Usage: java org.mmbase.util.LRUHashtable <size of table> <number of operation to do> <threads> <class name>");
            return;
        }
        final CacheImplementationInterface treap = (CacheImplementationInterface)impl.newInstance();
        treap.setMaxSize(treesiz / 2);
        long ll1 = System.currentTimeMillis();
        for (int i = 0; i < treesiz; ++i) {
            treap.put("" + i, "" + i);
        }
        long ll2 = System.currentTimeMillis();
        System.out.println("Size " + treap.size());
        if (treesiz <= 1024) {
            System.out.println("LRUHashtable initially " + treap.entrySet());
        }
        final int TREESIZ = treesiz;
        final int OPERS = opers;
        final int[][] score = new int[TREESIZ][thrds];
        long ll3 = System.nanoTime();
        final Thread[] threads = new Thread[thrds];
        for (int t = 0; t < thrds; ++t) {
            final int threadnr = t;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (threads.length > 1) {
                        System.out.print("[+" + threadnr + "]");
                    }
                    Random rnd = new Random();
                    for (int i = 0; i < OPERS; ++i) {
                        int j = Math.abs(rnd.nextInt()) % (TREESIZ / 2) + TREESIZ / 4;
                        int k = Math.abs(rnd.nextInt()) % 2;
                        switch (k) {
                            case 0: {
                                treap.put("" + j, "" + j);
                                int[] nArray = score[j];
                                int n = threadnr;
                                nArray[n] = nArray[n] + 1;
                                break;
                            }
                            case 1: {
                                treap.get("" + j);
                                int[] nArray = score[j];
                                int n = threadnr;
                                nArray[n] = nArray[n] + 1;
                            }
                        }
                        j = Math.abs(rnd.nextInt()) % TREESIZ;
                        treap.get("" + j);
                        int[] nArray = score[j];
                        int n = threadnr;
                        nArray[n] = nArray[n] + 1;
                    }
                    if (threads.length > 1) {
                        System.out.print("[-" + threadnr + "]");
                    }
                }
            };
            threads[t] = new Thread(runnable);
            threads[t].start();
        }
        long ll4 = System.nanoTime();
        for (int i = 0; i < thrds; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException ie) {
                System.err.println("Interrupted");
            }
        }
        System.out.println(".");
        long ll5 = System.nanoTime();
        if (TREESIZ <= 1024) {
            System.out.println("LRUHashtable afterwards " + treap.entrySet());
            for (int i = 0; i < TREESIZ; ++i) {
                int totscore = 0;
                for (int j = 0; j < thrds; ++j) {
                    totscore += score[i][j];
                }
                System.out.println("" + i + " score " + totscore);
            }
        }
        System.out.println("Creation " + (ll2 - ll1) + " ns");
        System.out.println("Thread starting " + (ll4 - ll3) / 1000L + " us");
        if (TREESIZ <= 1024) {
            System.out.println("Print    " + (ll3 - ll2) / 1000000L + " ms");
        } else {
            System.out.println("Not printed (too huge)");
        }
        long timePerKop = (ll5 - ll3) * 1000L / (long)opers;
        System.out.println("Run      " + (ll5 - ll3) / 1000000L + " ms (" + timePerKop / 1000L + " us/koperation,  " + timePerKop / (long)thrds / 1000L + " us/koperation total from " + thrds + " threads)");
        System.out.println("Used implementation: " + impl);
    }
}

