/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.cache.xslt;

import java.io.File;
import java.net.URL;
import javax.xml.transform.TransformerFactory;
import org.mmbase.cache.Cache;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.URIResolver;

public class FactoryCache
extends Cache<javax.xml.transform.URIResolver, TransformerFactory> {
    private static final Logger log = Logging.getLoggerInstance(FactoryCache.class);
    private static FactoryCache cache;
    private static File defaultDir;
    private static boolean loggedImplementation;
    boolean warnedFeature = false;

    public static FactoryCache getCache() {
        return cache;
    }

    @Override
    public String getName() {
        return "XSLFactories";
    }

    @Override
    public String getDescription() {
        return "XSL Transformer Factories";
    }

    private FactoryCache(int size) {
        super(size);
    }

    public TransformerFactory getDefaultFactory() {
        return this.getFactory(defaultDir);
    }

    public TransformerFactory getFactory(javax.xml.transform.URIResolver uri) {
        TransformerFactory tf = (TransformerFactory)this.get(uri);
        if (tf == null) {
            tf = TransformerFactory.newInstance();
            try {
                tf.setAttribute("http://saxon.sf.net/feature/version-warning", false);
            }
            catch (IllegalArgumentException iae) {
                if (!this.warnedFeature) {
                    log.service(tf + ": " + iae.getMessage() + ". (subsequent messages logged on debug)");
                    this.warnedFeature = true;
                }
                log.debug(tf + ": " + iae.getMessage() + ".");
            }
            tf.setURIResolver(uri);
            this.put(uri, tf);
        }
        if (!loggedImplementation) {
            log.info("XSLT TransformerFactory implementation " + tf.getClass().getName());
            loggedImplementation = true;
        }
        return tf;
    }

    public TransformerFactory getFactory(File cwd) {
        try {
            TransformerFactory tf = (TransformerFactory)this.get(new URIResolver(new URL("file://" + cwd), true));
            if (tf == null) {
                return this.getFactory(new URIResolver(new URL("file://" + cwd)));
            }
            return tf;
        }
        catch (Exception e) {
            return null;
        }
    }

    public TransformerFactory getFactory(URL cwd) {
        TransformerFactory tf = (TransformerFactory)this.get(new URIResolver(cwd, true));
        if (tf == null) {
            return this.getFactory(new URIResolver(cwd));
        }
        return tf;
    }

    static {
        defaultDir = new File("");
        loggedImplementation = false;
        int cacheSize = 50;
        cache = new FactoryCache(cacheSize);
        cache.putCache();
    }
}

