/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.cache.xslt;

import java.io.File;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;
import org.mmbase.cache.Cache;
import org.mmbase.cache.xslt.FactoryCache;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.ResourceWatcher;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.URIResolver;

public class TemplateCache
extends Cache<Key, Templates> {
    private static final Logger log = Logging.getLoggerInstance(TemplateCache.class);
    private static int cacheSize = 50;
    private static final TemplateCache cache = new TemplateCache(cacheSize);
    private static ResourceWatcher templateWatcher = new ResourceWatcher(ResourceLoader.getWebRoot()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(String file) {
            if (log.isDebugEnabled()) {
                log.debug("Removing " + file.toString() + " from cache");
            }
            TemplateCache templateCache = cache;
            synchronized (templateCache) {
                int removed = cache.remove(file);
                if (removed == 0) {
                    log.error("Could not remove " + file.toString() + " Template(s) from cache!");
                } else if (log.isDebugEnabled()) {
                    log.debug("Removed " + removed + " entries from cache");
                }
            }
            this.remove(file);
        }
    };

    public static TemplateCache getCache() {
        return cache;
    }

    @Override
    public String getName() {
        return "XSLTemplates";
    }

    @Override
    public String getDescription() {
        return "XSL Templates";
    }

    private TemplateCache(int size) {
        super(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int remove(String file) {
        int removed = 0;
        if (log.isDebugEnabled()) {
            log.debug("trying to remove keys containing " + file);
        }
        HashSet<Key> remove = new HashSet<Key>();
        TemplateCache templateCache = this;
        synchronized (templateCache) {
            for (Map.Entry entry : this.entrySet()) {
                Key mapKey = (Key)entry.getKey();
                if (!mapKey.getURL().equals(file)) continue;
                remove.add(mapKey);
            }
        }
        for (Key mapKey : remove) {
            if (this.remove(mapKey) != null) {
                ++removed;
                continue;
            }
            log.warn("Could not remove " + mapKey);
        }
        return removed;
    }

    public Templates getTemplates(Source src) {
        return this.getTemplates(src, null);
    }

    public Templates getTemplates(Source src, javax.xml.transform.URIResolver uri) {
        Key key = new Key(src, uri);
        if (log.isDebugEnabled()) {
            log.debug("Getting from cache " + key);
        }
        return (Templates)this.get(key);
    }

    @Override
    public synchronized Templates remove(Object o) {
        if (log.isDebugEnabled()) {
            log.debug("Removing " + o);
        }
        Key key = (Key)o;
        Templates result = (Templates)super.remove(key);
        String url = key.getURL();
        this.remove(url);
        templateWatcher.remove(url);
        return result;
    }

    @Override
    public void clear() {
        templateWatcher.clear();
        super.clear();
    }

    @Override
    public Templates put(Key key, Templates value) {
        throw new RuntimeException("wrong types in cache");
    }

    @Override
    public Templates put(Source src, Templates value) {
        return this.put(src, value, null);
    }

    public Templates put(Source src, Templates value, javax.xml.transform.URIResolver uri) {
        if (!this.isActive()) {
            if (log.isDebugEnabled()) {
                log.debug("XSLT Cache is not active");
            }
            return null;
        }
        Key key = new Key(src, uri);
        Templates res = super.put(key, value);
        log.debug("Put xslt in cache with key " + key);
        if (!templateWatcher.getResources().contains(key.getURL())) {
            templateWatcher.add(key.getURL());
        }
        if (log.isDebugEnabled()) {
            log.debug("have set watch on  " + key.getURL());
            log.trace("currently watching: " + templateWatcher);
        }
        return res;
    }

    public static void main(String[] argv) {
        log.setLevel(Level.DEBUG);
        try {
            File xslFile = File.createTempFile("templatecachetest", ".xsl");
            log.info("using file " + xslFile);
            FileWriter fw = new FileWriter(xslFile);
            fw.write("<xsl:stylesheet  version = \"1.1\" xmlns:xsl =\"http://www.w3.org/1999/XSL/Transform\"></xsl:stylesheet>");
            fw.close();
            for (int i = 0; i < 10; ++i) {
                TemplateCache c = TemplateCache.getCache();
                StreamSource xsl = new StreamSource(xslFile);
                URIResolver uri = new URIResolver(xslFile.getParentFile());
                Templates cachedXslt = c.getTemplates(xsl, uri);
                log.info("template cache size " + c.size() + " entries: " + c.entrySet());
                if (cachedXslt == null) {
                    cachedXslt = FactoryCache.getCache().getFactory(uri).newTemplates(xsl);
                    c.put(xsl, cachedXslt, uri);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Used xslt from cache with " + xsl.getSystemId());
            }
            xslFile.delete();
        }
        catch (Exception e) {
            System.err.println("hmm?" + e);
        }
    }

    static {
        cache.putCache();
        templateWatcher.setDelay(10000L);
        templateWatcher.start();
    }

    public static class Key {
        private final String src;
        private final javax.xml.transform.URIResolver uri;

        Key(Source src, javax.xml.transform.URIResolver uri) {
            this.src = src.getSystemId();
            this.uri = uri;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                return (this.src == null ? k.src == null : this.src.equals(k.src)) && (this.uri == null ? k.uri == null : this.uri.equals(k.uri));
            }
            return false;
        }

        public int hashCode() {
            return 32 * (this.src == null ? 0 : this.src.hashCode()) + (this.uri == null ? 0 : this.uri.hashCode());
        }

        String getURL() {
            return this.src;
        }

        public String toString() {
            return "" + this.src + "/" + this.uri;
        }
    }
}

