/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.core.event;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.mmbase.core.event.Event;
import org.mmbase.core.event.EventBroker;
import org.mmbase.core.event.EventListener;
import org.mmbase.core.event.SystemEvent;
import org.mmbase.core.event.SystemEventListener;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.ResourceWatcher;
import org.mmbase.util.ThreadPools;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.DocumentReader;
import org.mmbase.util.xml.EntityResolver;
import org.mmbase.util.xml.Instantiator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EventManager
implements SystemEventListener {
    private static final Logger log = Logging.getLoggerInstance(EventManager.class);
    private static final UUID INSTANCEID = UUID.randomUUID();
    private static String machineName = "localhost";
    public static final String PUBLIC_ID_EVENTMANAGER = "-//MMBase//DTD eventmanager config 1.0//EN";
    public static final String DTD_EVENTMANAGER = "eventmanager_1_0.dtd";
    protected static final String CONFIG = "eventmanager.xml";
    private static final EventManager eventManager;
    private final Set<EventBroker> eventBrokers = new CopyOnWriteArraySet<EventBroker>();
    private long numberOfPropagatedEvents = 0L;
    private long duration = 0L;
    private final Set<EventListener> listenersFromResources = new CopyOnWriteArraySet<EventListener>();
    private final Map<SystemEvent.Collectable, Set<EventListener>> receivedSystemEvents = new ConcurrentHashMap<SystemEvent.Collectable, Set<EventListener>>();
    protected ResourceWatcher watcher;

    public static EventManager getInstance() {
        if (eventManager == null) {
            throw new IllegalStateException();
        }
        return eventManager;
    }

    public static UUID getUUID() {
        return INSTANCEID;
    }

    public static String getMachineName() {
        return machineName;
    }

    @Override
    public synchronized void notify(SystemEvent se) {
        if (se instanceof SystemEvent.MachineName) {
            machineName = ((SystemEvent.MachineName)se).getName();
        }
        if (se instanceof SystemEvent.Shutdown) {
            this.shutdown();
        }
        if (se instanceof SystemEvent.Collectable) {
            HashSet<EventListener> notified = new HashSet<EventListener>();
            this.receivedSystemEvents.put((SystemEvent.Collectable)se, notified);
            for (EventBroker broker : this.eventBrokers) {
                if (!broker.canBrokerForEvent(se)) continue;
                Collection<EventListener> alreadyNotified = broker.getListeners();
                notified.addAll(alreadyNotified);
            }
        }
        if (se instanceof SystemEvent.Up) {
            this.watcher = new ResourceWatcher(){

                @Override
                public void onChange(String w) {
                    EventManager.this.configure(w);
                }
            };
            this.watcher.add(CONFIG);
            this.watcher.onChange();
            this.watcher.start();
        }
        if (se instanceof SystemEvent.ResourceLoaderChange) {
            log.service("Reconfiguring event managers, because " + se);
            if (this.watcher != null) {
                this.watcher.onChange();
            }
        }
    }

    @Override
    public int getWeight() {
        return Integer.MAX_VALUE;
    }

    private EventManager() {
    }

    protected final synchronized void configure(String resource) {
        DocumentReader configReader;
        Document config;
        log.service("Configuring the event manager");
        HashSet<EventBroker> originalEventBrokers = new HashSet<EventBroker>();
        HashSet<EventListener> newListeners = new HashSet<EventListener>();
        originalEventBrokers.addAll(this.eventBrokers);
        this.eventBrokers.clear();
        for (URL url : ResourceLoader.getConfigurationRoot().getResourceList(resource)) {
            try {
                log.debug("listeners of " + url);
                if (!url.openConnection().getDoInput()) continue;
                config = ResourceLoader.getDocument(url, true, EventManager.class);
                configReader = new DocumentReader(config);
                for (Element element : configReader.getChildElements("eventmanager.brokers", "broker")) {
                    try {
                        EventBroker broker = (EventBroker)Instantiator.getInstance(element, new Object[0]);
                        if (broker == null) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("adding event broker: " + broker);
                        }
                        this.addEventBroker(broker);
                    }
                    catch (Throwable ee) {
                        log.warn(ee.getMessage(), ee);
                    }
                }
            }
            catch (SAXException e1) {
                log.error("Something went wrong configuring the event system (" + url + "): " + e1.getMessage(), e1);
            }
            catch (IOException e1) {
                log.error("something went wrong configuring the event system (" + url + "): " + e1.getMessage(), e1);
            }
        }
        log.debug("Found brokers " + this.getBrokers());
        for (URL url : ResourceLoader.getConfigurationRoot().getResourceList(resource)) {
            try {
                log.debug("listeners of " + url);
                if (!url.openConnection().getDoInput()) continue;
                config = ResourceLoader.getDocument(url, true, EventManager.class);
                configReader = new DocumentReader(config);
                for (Element element : configReader.getChildElements("eventmanager.listeners", "listener")) {
                    try {
                        EventListener listener = (EventListener)Instantiator.getInstance(element, new Object[0]);
                        log.debug(" " + listener);
                        this.addEventListener(listener);
                        newListeners.add(listener);
                    }
                    catch (Throwable ee) {
                        log.warn(ee.getMessage(), ee);
                    }
                }
            }
            catch (SAXException e1) {
                log.debug("Something went wrong configuring the event system (" + url + "): " + e1.getMessage(), e1);
            }
            catch (IOException e1) {
                log.debug("something went wrong configuring the event system (" + url + "): " + e1.getMessage(), e1);
            }
        }
        if (this.eventBrokers.isEmpty()) {
            log.debug("No event brokers could not be found. This means that query-invalidation does not work correctly now. Proceeding anyway.");
        }
        for (EventBroker original : originalEventBrokers) {
            for (EventListener el : original.getListeners()) {
                log.debug("Reading " + el);
                if (!original.getListeners().contains(el)) continue;
                original.removeListener(el);
                this.addEventListener(el, false);
            }
        }
        this.listenersFromResources.clear();
        this.listenersFromResources.addAll(newListeners);
        log.debug("Ready ");
        this.propagateEvent(new Ready());
    }

    public Collection<EventBroker> getBrokers() {
        return Collections.unmodifiableSet(this.eventBrokers);
    }

    public void addEventBroker(EventBroker broker) {
        if (!this.eventBrokers.contains(broker)) {
            if (log.isDebugEnabled()) {
                log.debug("adding broker " + broker.toString());
            }
            this.eventBrokers.add(broker);
        } else if (log.isDebugEnabled()) {
            log.debug("broker " + broker.toString() + "was already registered: rejected.");
        }
    }

    public void removeEventBroker(EventBroker broker) {
        this.eventBrokers.remove(broker);
    }

    public final void addEventListener(EventListener listener) {
        this.addEventListener(listener, true);
    }

    protected void addEventListener(EventListener listener, boolean propagateToCollected) {
        boolean notifiedReceived;
        BrokerIterator i = this.findBrokers(listener);
        boolean bl = notifiedReceived = !propagateToCollected;
        while (i.hasNext()) {
            EventBroker broker = i.next();
            if (!broker.addListener(listener)) continue;
            if (!notifiedReceived && listener instanceof SystemEventListener) {
                if (log.isDebugEnabled()) {
                    log.debug("Notifying " + this.receivedSystemEvents + " to " + listener);
                }
                notifiedReceived = true;
                SystemEventListener sel = (SystemEventListener)listener;
                for (Map.Entry<SystemEvent.Collectable, Set<EventListener>> se : this.receivedSystemEvents.entrySet()) {
                    if (!se.getValue().contains(sel)) {
                        sel.notify(se.getKey());
                        se.getValue().add(sel);
                        continue;
                    }
                    log.debug(sel.toString() + " was already notified about " + se);
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("listener " + listener + " added to broker " + broker);
        }
    }

    public void removeEventListener(EventListener listener) {
        if (log.isDebugEnabled()) {
            log.debug("removing listener of type: " + listener.getClass().getName());
        }
        BrokerIterator i = this.findBrokers(listener);
        while (i.hasNext()) {
            i.next().removeListener(listener);
        }
    }

    public void propagateEvent(Event event) {
        if (log.isTraceEnabled()) {
            log.trace("Propagating event '" + event + " to " + this.eventBrokers);
        }
        long startTime = System.nanoTime();
        for (EventBroker broker : this.eventBrokers) {
            try {
                if (broker.canBrokerForEvent(event)) {
                    broker.notifyForEvent(event);
                    if (!log.isDebugEnabled()) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("event from '" + event.getMachine() + "': " + event + " has been accepted by broker " + broker);
                        continue;
                    }
                    log.debug("event from '" + event.getMachine() + "' has been accepted by broker " + broker);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                if (log.isTraceEnabled()) {
                    log.trace("event from '" + event.getMachine() + "': " + event + " has been rejected by broker " + broker);
                    continue;
                }
                log.debug("event from '" + event.getMachine() + "' has been rejected by broker " + broker);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        ++this.numberOfPropagatedEvents;
        this.duration += System.nanoTime() - startTime;
    }

    public void propagateEvent(final Event event, boolean asynchronous) {
        if (asynchronous) {
            ThreadPools.jobsExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    EventManager.this.propagateEvent(event);
                }
            });
        } else {
            this.propagateEvent(event);
        }
    }

    public long getNumberOfPropagatedEvents() {
        return this.numberOfPropagatedEvents;
    }

    public long getPropagationCost() {
        return this.duration / 1000000L;
    }

    public long getPropagationCostNs() {
        return this.duration;
    }

    private BrokerIterator findBrokers(EventListener listener) {
        if (log.isDebugEnabled()) {
            log.debug("try to find broker for " + listener.getClass().getName());
        }
        return new BrokerIterator(this.eventBrokers.iterator(), listener);
    }

    public void shutdown() {
        log.service("Shutting down event manager");
        this.eventBrokers.clear();
        if (this.watcher != null) {
            this.watcher.exit();
        }
    }

    static {
        EntityResolver.registerPublicID(PUBLIC_ID_EVENTMANAGER, DTD_EVENTMANAGER, EventManager.class);
        eventManager = new EventManager();
        eventManager.configure(CONFIG);
        eventManager.addEventListener(eventManager);
    }

    public static class Ready
    extends SystemEvent.Collectable {
    }

    private static final class BrokerIterator
    implements Iterator<EventBroker>,
    Iterable<EventBroker> {
        EventBroker next;
        final Iterator<EventBroker> i;
        final EventListener listener;

        BrokerIterator(Iterator<EventBroker> i, EventListener listener) {
            this.i = i;
            this.listener = listener;
            this.findNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<EventBroker> iterator() {
            return this;
        }

        @Override
        public EventBroker next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            EventBroker n = this.next;
            this.findNext();
            return n;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        protected void findNext() {
            while (this.i.hasNext()) {
                EventBroker broker = this.i.next();
                if (broker.canBrokerForListener(this.listener)) {
                    if (log.isDebugEnabled()) {
                        log.debug("broker " + broker + " can broker for eventlistener " + this.listener.getClass().getName());
                    }
                    this.next = broker;
                    return;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("broker " + broker + " cannot boker for eventlistener." + this.listener.getClass().getName());
            }
            this.next = null;
        }
    }
}

