/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.core.event;

import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.mmbase.core.event.Event;
import org.mmbase.core.event.EventBroker;
import org.mmbase.core.event.EventListener;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public abstract class WeakEventBroker
extends EventBroker {
    private static final Logger log = Logging.getLoggerInstance(WeakEventBroker.class);
    private final Map<EventListener, Boolean> listeners = new WeakHashMap<EventListener, Boolean>();

    @Override
    protected Collection<EventListener> backing() {
        return this.listeners.keySet();
    }

    @Override
    public synchronized boolean addListener(EventListener listener) {
        if (this.canBrokerForListener(listener)) {
            if (this.listeners.containsKey(listener)) {
                return false;
            }
            this.listeners.put(listener, null);
            return true;
        }
        log.warn("Ignored listener for" + this.getClass() + " because it cannot broker for that.");
        return false;
    }

    @Override
    public synchronized void removeListener(EventListener listener) {
        if (!this.listeners.remove(listener).booleanValue()) {
            log.warn("Tried to remove " + listener + " from " + this.getClass() + " but it was not found. Ignored.");
        }
    }

    @Override
    public synchronized void notifyForEvent(Event event) {
        super.notifyForEvent(event);
    }

    @Override
    public String toString() {
        return "Weak Event Broker";
    }

    public static void main(String[] argv) {
        WeakHashMap weakSet = new WeakHashMap();
        weakSet.put(new Object(), null);
        System.out.println("set " + weakSet.keySet());
        Runtime.getRuntime().gc();
        System.out.println("set " + weakSet.keySet());
    }
}

