/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class ApplicationContextReader {
    private static final Logger log = Logging.getLoggerInstance(ApplicationContextReader.class);
    private static final Map<String, Map<String, String>> cache = new ConcurrentHashMap<String, Map<String, String>>();

    public static Map<String, String> getCachedProperties(String path) {
        Map<String, String> m = cache.get(path);
        if (m == null) {
            try {
                m = ApplicationContextReader.getProperties(path);
            }
            catch (NameNotFoundException nfe) {
                log.service(nfe + ": " + path);
                m = Collections.emptyMap();
            }
            catch (NoInitialContextException nie) {
                log.service(nie);
                m = Collections.emptyMap();
            }
            catch (NamingException ne) {
                log.error(ne);
                m = Collections.emptyMap();
            }
            cache.put(path, m);
        }
        return m;
    }

    public static Map<String, String> getProperties(String path) throws NamingException {
        if (path == null || "".equals(path)) {
            throw new IllegalArgumentException("Path is empty");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        Context env = ApplicationContextReader.getContext();
        if (env != null) {
            NamingEnumeration<NameClassPair> ne = env.list(path);
            while (ne.hasMoreElements()) {
                NameClassPair element = (NameClassPair)ne.nextElement();
                String contextName = element.getName();
                String lookupName = env.composeName(contextName, path);
                Object value = env.lookup(lookupName);
                if (value instanceof Context) {
                    Map<String, String> subProps = ApplicationContextReader.getProperties(path + "/" + contextName);
                    for (Map.Entry<String, String> entry : subProps.entrySet()) {
                        properties.put(contextName + "/" + entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                if (value != null) {
                    properties.put(contextName, value.toString());
                    continue;
                }
                properties.put(contextName, "");
            }
        }
        return properties;
    }

    public static Context getContext() throws NamingException {
        InitialContext context = new InitialContext();
        return (Context)context.lookup("java:comp/env");
    }
}

