/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class CSVReader {
    private static final Logger log = Logging.getLoggerInstance(CSVReader.class);
    private static final String DEFAULT_DELIM = ",";
    private static final String DEFAULT_CHARSET = "UTT-8";
    private final String filename;
    private final String delimiter;
    private final String charset;
    private Pattern csv_pattern = Pattern.compile("\"([^\"]+?)\",?|([^,]+),?|,");
    public List<String> lines = new ArrayList<String>();
    public List<String> header = new ArrayList<String>();
    public Map<Integer, List<String>> rows = new HashMap<Integer, List<String>>();

    public CSVReader(String filename, String delimiter, String charset) {
        this.filename = filename;
        this.delimiter = delimiter == null || delimiter.length() == 0 ? DEFAULT_DELIM : delimiter;
        this.charset = charset == null || charset.length() == 0 ? DEFAULT_CHARSET : charset;
        this.readCSV();
    }

    public CSVReader(String filename, String delimiter) {
        this(filename, delimiter, null);
    }

    public CSVReader(String filename) {
        this(filename, null);
    }

    private void readCSV() {
        if (log.isDebugEnabled()) {
            log.debug("filename: " + this.filename + ", delimiter: " + this.delimiter + ", charset: " + this.charset);
        }
        try {
            String line;
            Charset cs = Charset.forName(this.charset);
            log.info("Trying to parse CSV-file: " + this.filename);
            if (!DEFAULT_DELIM.equals(this.delimiter)) {
                this.csv_pattern = this.compilePattern(this.delimiter);
            }
            InputStream is = ResourceLoader.getWebRoot().getResourceAsStream(this.filename);
            InputStreamReader isr = new InputStreamReader(is, cs);
            BufferedReader in = new BufferedReader(isr);
            this.lines.clear();
            while ((line = in.readLine()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("line: " + line);
                }
                this.lines.add(line);
            }
            in.close();
            if (this.lines.size() > 0) {
                this.header.clear();
                this.rows.clear();
                this.header = this.parse(this.lines.get(0));
                int i = 0;
                for (String l : this.lines) {
                    this.rows.put(i++, this.parse(l));
                }
            }
        }
        catch (IllegalCharsetNameException ice) {
            log.error("Illegal charset name: " + ice);
        }
        catch (UnsupportedCharsetException uce) {
            log.error("Unsupported charset: " + uce);
        }
        catch (IOException ioe) {
            log.error("IOException, probably file '" + this.filename + "' not found: " + ioe);
        }
    }

    public String getElement(int r, int c) {
        List<String> row = this.rows.get(r);
        String value = row.get(c);
        return value;
    }

    public Map<Integer, List<String>> getValues() {
        return this.rows;
    }

    public static Map<Integer, List<String>> getValues(String filename, String delimiter, String charset) {
        CSVReader reader = new CSVReader(filename, delimiter, charset);
        return reader.getValues();
    }

    public static CSVReader readCSV(String filename, String delimiter, String charset) {
        return new CSVReader(filename, delimiter, charset);
    }

    public int size() {
        return this.rows.size();
    }

    private List<String> parse(String line) {
        String match;
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = this.csv_pattern.matcher(line);
        while (m.find() && (match = m.group()) != null) {
            if (match.endsWith(DEFAULT_DELIM)) {
                match = match.substring(0, match.length() - 1);
            }
            if (match.startsWith("\"")) {
                match = match.substring(1, match.length() - 1);
            }
            if (match.length() == 0) {
                match = null;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found match: " + match);
            }
            list.add(match);
        }
        return list;
    }

    private Pattern compilePattern(String delimiter) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"([^\"]+?)\"").append(delimiter).append("?|([^").append(delimiter);
        sb.append("]+)").append(delimiter).append("?|").append(delimiter);
        try {
            return Pattern.compile(sb.toString());
        }
        catch (PatternSyntaxException pse) {
            log.error("Can not use this delimiter '" + delimiter + "', it causes an exception: " + pse);
            return null;
        }
    }

    public String getDescription() {
        StringBuilder msg = new StringBuilder("Hi, I'm the CSVReader. ");
        msg.append("My configuration is as follows:");
        msg.append("\nfile to import: ").append(this.filename);
        msg.append("\ndelimiter: ").append(this.delimiter);
        msg.append("\ncharset: ").append(this.charset);
        return msg.toString();
    }
}

