/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mmbase.util.MMBaseContext;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.ByteToCharTransformer;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.transformers.Config;
import org.mmbase.util.transformers.ConfigurableTransformer;
import org.mmbase.util.transformers.Transformer;

public class Encode {
    private static final Logger log = Logging.getLoggerInstance(Encode.class);
    private Transformer trans;
    private static Map<String, Config> encodings;
    private static Set<String> registered;

    public Encode(String encoding) {
        if (encodings.containsKey(encoding.toUpperCase())) {
            Config e = encodings.get(encoding.toUpperCase());
            try {
                this.trans = (Transformer)e.clazz.newInstance();
            }
            catch (InstantiationException ex) {
                throw new IllegalArgumentException("encoding: '" + encoding + "' could not be instantiated");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (this.trans instanceof ConfigurableTransformer) {
                ((ConfigurableTransformer)this.trans).configure(e.config);
            }
        } else {
            throw new IllegalArgumentException("encoding: '" + encoding + "' unknown" + encodings.keySet());
        }
    }

    public Transformer getTransformer() {
        return this.trans;
    }

    public static void register(String clazz) {
        if (!registered.contains(clazz)) {
            block7: {
                log.service("registering encode class " + clazz);
                try {
                    Class<?> atrans = Class.forName(clazz);
                    if (Transformer.class.isAssignableFrom(atrans)) {
                        if (ConfigurableTransformer.class.isAssignableFrom(atrans)) {
                            log.debug("A configurable transformer");
                            ConfigurableTransformer transformer = (ConfigurableTransformer)atrans.newInstance();
                            Map<String, Config> newencodings = transformer.transformers();
                            encodings.putAll(newencodings);
                        } else {
                            log.debug("Non configurable");
                            Transformer transformer = (Transformer)atrans.newInstance();
                            encodings.put(transformer.toString().toUpperCase(), new Config(atrans, -1, "Transformer: " + clazz));
                        }
                        break block7;
                    }
                    throw new IllegalArgumentException("The class " + clazz + " does not implement " + Transformer.class.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e.toString(), e);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.toString());
                }
            }
            registered.add(clazz);
        }
    }

    public static String encode(String encoding, String toEncode) {
        Encode e = new Encode(encoding);
        return e.encode(toEncode);
    }

    public static String encode(String encoding, byte[] bytes) {
        Encode e = new Encode(encoding);
        return e.encode(bytes);
    }

    public static String decode(String encoding, String toDecode) {
        Encode e = new Encode(encoding);
        return e.decode(toDecode);
    }

    public static byte[] decodeBytes(String encoding, String toDecode) {
        Encode e = new Encode(encoding);
        return e.decodeBytes(toDecode);
    }

    public String encode(String toEncode) {
        if (this.isByteToCharEncoder()) {
            return ((ByteToCharTransformer)this.trans).transform(toEncode.getBytes());
        }
        return ((CharTransformer)this.trans).transform(toEncode);
    }

    public String encode(byte[] bytes) {
        return ((ByteToCharTransformer)this.trans).transform(bytes);
    }

    public String decode(String toDecode) {
        if (this.isByteToCharEncoder()) {
            return new String(((ByteToCharTransformer)this.trans).transformBack(toDecode));
        }
        return ((CharTransformer)this.trans).transformBack(toDecode);
    }

    public byte[] decodeBytes(String toDecode) {
        if (this.isByteToCharEncoder()) {
            return ((ByteToCharTransformer)this.trans).transformBack(toDecode);
        }
        return ((CharTransformer)this.trans).transformBack(toDecode).getBytes();
    }

    public static Set<String> possibleEncodings() {
        return encodings.keySet();
    }

    public static boolean isEncoding(String e) {
        return encodings.containsKey(e.toUpperCase());
    }

    public boolean isCharEncoder() {
        return this.trans instanceof CharTransformer;
    }

    public boolean isByteToCharEncoder() {
        return this.trans instanceof ByteToCharTransformer;
    }

    public String getEncoding() {
        return this.trans.toString();
    }

    public static void main(String[] argv) {
        try {
            MMBaseContext.init(System.getProperty("mmbase.config"), false);
        }
        catch (Throwable e) {
            System.err.println("Could not intialize mmbase context, proceeding without it: " + e.getMessage());
        }
        String coding = null;
        boolean decode = false;
        String string = null;
        for (int cur = 0; cur < argv.length; ++cur) {
            if ("-decode".equals(argv[cur])) {
                decode = true;
                continue;
            }
            if ("-encode".equals(argv[cur])) continue;
            if ("-class".equals(argv[cur])) {
                Encode.register(argv[++cur]);
                continue;
            }
            if (coding == null) {
                coding = argv[cur];
                if (Encode.isEncoding(coding)) continue;
                throw new RuntimeException(coding + " is not a  known coding");
            }
            if (argv[cur].charAt(0) == '-') {
                throw new RuntimeException("unknown option " + argv[cur]);
            }
            if (string == null) {
                string = "";
            }
            string = string + " " + argv[cur];
        }
        if (coding == null) {
            System.out.println("org.mmbase.util.Encode main is for testing purposes only\n");
            System.out.println("   use: java -Dmmbase.config=... org.mmbase.util.Encode [-class <classname> [-class ..]] [-encode|-decode] <coding> [string]\n\n");
            System.out.println("On default it encodes and gets the string from STDIN\n\n");
            System.out.println("possible decoding are");
            ArrayList<String> v = new ArrayList<String>(Encode.possibleEncodings());
            Collections.sort(v);
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                String aV;
                String enc = aV = (String)iterator.next();
                System.out.println(enc + "   " + Encode.encodings.get((Object)enc).info);
            }
        } else {
            if (string == null) {
                string = "";
                try {
                    BufferedReader stdinReader = new BufferedReader(new InputStreamReader(System.in));
                    String line = stdinReader.readLine();
                    while (line != null) {
                        string = string + line + "\n";
                        line = stdinReader.readLine();
                    }
                    log.service("----------------");
                }
                catch (IOException e) {
                    System.err.println(e.toString());
                }
            }
            if (decode) {
                System.out.println(new String(Encode.decodeBytes(coding, string)));
            } else {
                System.out.println(Encode.encode(coding, string));
            }
        }
    }

    static {
        registered = new HashSet<String>();
        encodings = new HashMap<String, Config>();
        for (String clazz : new String[]{"org.mmbase.util.transformers.MD5", "org.mmbase.util.transformers.Base64", "org.mmbase.util.transformers.Hex", "org.mmbase.util.transformers.Xml", "org.mmbase.util.transformers.Url", "org.mmbase.util.transformers.Sql", "org.mmbase.util.transformers.XmlField", "org.mmbase.util.transformers.LinkFinder", "org.mmbase.util.transformers.Censor", "org.mmbase.util.transformers.Rot13", "org.mmbase.util.transformers.Rot5", "org.mmbase.util.transformers.UnicodeEscaper"}) {
            try {
                Encode.register(clazz);
            }
            catch (IllegalArgumentException e) {
                log.warn(e.getMessage());
            }
        }
    }
}

