/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.mmbase.util.GenericResponseWrapper;

public class EncodingDetectingOutputStreamWriter
extends Writer {
    private OutputStream outputStream;
    private Writer wrapped = null;
    private StringBuilder buffer = new StringBuilder(100);

    EncodingDetectingOutputStreamWriter(OutputStream os) {
        this.outputStream = os;
    }

    private void wrap() throws IOException {
        if (this.wrapped == null) {
            String encoding = GenericResponseWrapper.getXMLEncoding(this.buffer.toString());
            if (encoding == null) {
                encoding = "UTF-8";
            }
            try {
                this.wrapped = new OutputStreamWriter(this.outputStream, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.wrapped.write(this.buffer.toString());
            this.buffer = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.wrap();
        this.wrapped.close();
    }

    @Override
    public void flush() throws IOException {
        this.wrap();
        this.wrapped.flush();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (this.wrapped != null) {
            this.wrapped.write(cbuf);
        } else {
            this.write(cbuf, 0, cbuf.length);
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this.wrapped != null) {
            this.wrapped.write(c);
        } else {
            super.write(c);
        }
    }

    @Override
    public void write(String str) throws IOException {
        if (this.wrapped != null) {
            this.wrapped.write(str);
        } else {
            super.write(str);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.wrapped != null) {
            this.wrapped.write(str, off, len);
        } else {
            super.write(str, off, len);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.wrapped != null) {
            this.wrapped.write(cbuf, off, len);
        } else {
            for (int i = off; i < len + off; ++i) {
                this.buffer.append(cbuf[i]);
                if (this.buffer.length() != 100) continue;
                this.wrap();
                if (++i >= len) break;
                this.wrapped.write(cbuf, i, len - (i - off));
                break;
            }
        }
    }
}

