/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class ExprCalc {
    private static final int MC_SYMB = 1;
    private static final int MC_NUM = 2;
    private static final int MC_NONE = 0;
    private static final int MC_EOT = -1;
    private static final Logger log = Logging.getLoggerInstance(ExprCalc.class);
    private StringTokenizer tokenizer;
    private String input;
    private int mCode;
    private char mSymb;
    private double mNum;
    private double result;

    public ExprCalc(String input) {
        this.input = input;
        this.tokenizer = new StringTokenizer(input, "+-*/()% \t", true);
        this.mCode = 0;
        this.result = this.expr();
        if (this.mCode != -1) {
            log.error("Could not evaluate expression: '" + input + "'");
        }
    }

    public double getResult() {
        return this.result;
    }

    private boolean lex() {
        if (this.mCode == 0) {
            String token;
            this.mCode = -1;
            this.mSymb = '\u0000';
            this.mNum = 0.0;
            try {
                while (" ".equals(token = this.tokenizer.nextToken()) || "\t".equals(token)) {
                }
            }
            catch (NoSuchElementException e) {
                return false;
            }
            if (Character.isDigit(token.charAt(0))) {
                int i;
                for (i = 0; i < token.length() && (Character.isDigit(token.charAt(i)) || token.charAt(i) == '.'); ++i) {
                }
                if (i != token.length()) {
                    log.error("Could not evaluate expression '" + token + "' of '" + this.input + "'");
                }
                try {
                    this.mNum = Double.valueOf(token);
                }
                catch (NumberFormatException e) {
                    log.error("Could not evaluate expression ('" + token + "' not a number) of '" + this.input + "'");
                }
                this.mCode = 2;
            } else {
                this.mSymb = token.charAt(0);
                this.mCode = 1;
            }
        }
        return true;
    }

    private double expr() {
        double tmp = this.term();
        while (this.lex() && this.mCode == 1 && (this.mSymb == '+' || this.mSymb == '-')) {
            this.mCode = 0;
            if (this.mSymb == '+') {
                tmp += this.term();
                continue;
            }
            tmp -= this.term();
        }
        if (!(this.mCode == 1 && this.mSymb == '(' || this.mCode == 1 && this.mSymb == ')' || this.mCode == -1)) {
            log.error("expr: Could not evaluate expression '" + this.input + "'");
        }
        return tmp;
    }

    private double term() {
        double tmp = this.fac();
        while (this.lex() && this.mCode == 1 && (this.mSymb == '*' || this.mSymb == '/' || this.mSymb == '%')) {
            this.mCode = 0;
            if (this.mSymb == '*') {
                tmp *= this.fac();
                continue;
            }
            if (this.mSymb == '/') {
                tmp /= this.fac();
                continue;
            }
            tmp %= this.fac();
        }
        return tmp;
    }

    private double fac() {
        double tmp = -1.0;
        boolean minus = false;
        if (this.lex() && this.mCode == 1 && this.mSymb == '-') {
            this.mCode = 0;
            minus = true;
        }
        if (this.lex() && this.mCode == 1 && this.mSymb == '(') {
            this.mCode = 0;
            tmp = this.expr();
            if (this.lex() && this.mCode != 1 || this.mSymb != ')') {
                log.error("fac1: Could not evaluate expression '" + this.input + "'");
            }
            this.mCode = 0;
        } else if (this.mCode == 2) {
            this.mCode = 0;
            tmp = this.mNum;
        } else {
            log.error("fac2: Could not evaluate expression '" + this.input + "'");
        }
        if (minus) {
            tmp = -tmp;
        }
        return tmp;
    }
}

