/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.mmbase.util.MyServletOutputStream;
import org.mmbase.util.WriterOutputStream;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class GenericResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger log = Logging.getLoggerInstance(GenericResponseWrapper.class);
    private static final Pattern XMLHEADER = Pattern.compile("<\\?xml.*?(?:\\sencoding=(?:\"([^\"]+?)\"|'([^']+?)'))?\\s*\\?>.*", 32);
    private static String UNSET_CHARSET = "iso-8859-1";
    public static String TEXT_XML_DEFAULT_CHARSET = "US-ASCII";
    private static String DEFAULT_CONTENTTYPE = "text/html";
    private static String[] IGNORED_HEADERS = new String[]{"Last-Modified", "ETag"};
    private PrintWriter writer;
    private StringWriter string;
    private ServletOutputStream outputStream;
    private ByteArrayOutputStream bytes;
    private String characterEncoding = UNSET_CHARSET;
    private HttpServletResponse wrappedResponse;
    protected String redirected = null;

    public GenericResponseWrapper(HttpServletResponse resp) {
        super(resp);
        this.wrappedResponse = resp;
    }

    public GenericResponseWrapper(HttpServletResponse resp, String encoding) {
        this(resp);
        this.characterEncoding = encoding;
        this.wrappedResponse = resp;
    }

    public HttpServletResponse getHttpServletResponse() {
        HttpServletResponse response = this.wrappedResponse;
        while (response instanceof HttpServletResponseWrapper) {
            if (response instanceof GenericResponseWrapper) {
                response = ((GenericResponseWrapper)response).wrappedResponse;
                continue;
            }
            response = (HttpServletResponse)((HttpServletResponseWrapper)response).getResponse();
        }
        return response;
    }

    private boolean mayAddHeader(String header) {
        for (String element : IGNORED_HEADERS) {
            if (!element.equalsIgnoreCase(header)) continue;
            return false;
        }
        return true;
    }

    public void sendRedirect(String location) throws IOException {
        this.redirected = location;
        this.getHttpServletResponse().sendRedirect(location);
    }

    public String getRedirected() {
        return this.redirected;
    }

    public void setStatus(int s) {
        this.getHttpServletResponse().setStatus(s);
    }

    public void addCookie(Cookie c) {
        this.getHttpServletResponse().addCookie(c);
    }

    public void setHeader(String header, String value) {
        if (this.mayAddHeader(header)) {
            this.getHttpServletResponse().setHeader(header, value);
        }
    }

    public void addDateHeader(String arg0, long arg1) {
        if (this.mayAddHeader(arg0)) {
            this.getHttpServletResponse().addDateHeader(arg0, arg1);
        }
    }

    public void addHeader(String arg0, String arg1) {
        if (this.mayAddHeader(arg0)) {
            this.getHttpServletResponse().addHeader(arg0, arg1);
        }
    }

    public void addIntHeader(String arg0, int arg1) {
        if (this.mayAddHeader(arg0)) {
            this.getHttpServletResponse().addIntHeader(arg0, arg1);
        }
    }

    public boolean containsHeader(String arg0) {
        return this.getHttpServletResponse().containsHeader(arg0);
    }

    public String encodeRedirectURL(String arg0) {
        return this.getHttpServletResponse().encodeRedirectURL(arg0);
    }

    public String encodeURL(String arg0) {
        return this.getHttpServletResponse().encodeURL(arg0);
    }

    public Locale getLocale() {
        return this.getHttpServletResponse().getLocale();
    }

    public void sendError(int arg0, String arg1) throws IOException {
        this.getHttpServletResponse().sendError(arg0, arg1);
    }

    public void sendError(int arg0) throws IOException {
        this.getHttpServletResponse().sendError(arg0);
    }

    public void setDateHeader(String arg0, long arg1) {
        if (this.mayAddHeader(arg0)) {
            this.getHttpServletResponse().setDateHeader(arg0, arg1);
        }
    }

    public void setIntHeader(String arg0, int arg1) {
        if (this.mayAddHeader(arg0)) {
            this.getHttpServletResponse().setIntHeader(arg0, arg1);
        }
    }

    public void setLocale(Locale arg0) {
        this.getHttpServletResponse().setLocale(arg0);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        if (this.writer != null) {
            this.outputStream = new MyServletOutputStream(new WriterOutputStream(this.writer, this.characterEncoding));
            return this.outputStream;
        }
        this.bytes = new ByteArrayOutputStream();
        this.outputStream = new MyServletOutputStream(this.bytes);
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.outputStream != null) {
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)this.outputStream, this.characterEncoding)));
            return this.writer;
        }
        this.string = new StringWriter();
        this.writer = new PrintWriter(this.string);
        return this.writer;
    }

    public void setContentType(String ct) {
        String contentType = DEFAULT_CONTENTTYPE;
        if (ct == null) {
            contentType = DEFAULT_CONTENTTYPE;
        } else {
            contentType = ct;
            this.characterEncoding = GenericResponseWrapper.getEncoding(ct);
            if (this.characterEncoding == null) {
                this.characterEncoding = GenericResponseWrapper.getDefaultEncoding(contentType);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("set contenttype of include page to: '" + contentType + "' (and character encoding to '" + this.characterEncoding + "')");
        }
    }

    public String getCharacterEncoding() {
        log.debug(this.characterEncoding);
        return this.characterEncoding;
    }

    protected byte[] determinXMLEncoding() {
        byte[] allBytes = this.bytes.toByteArray();
        this.characterEncoding = GenericResponseWrapper.getXMLEncoding(allBytes);
        if (this.characterEncoding == null) {
            this.characterEncoding = "UTF-8";
        }
        return allBytes;
    }

    public String toString() {
        if (this.string != null) {
            return this.string.toString();
        }
        if (this.outputStream != null) {
            try {
                byte[] allBytes = TEXT_XML_DEFAULT_CHARSET.equals(this.characterEncoding) ? this.determinXMLEncoding() : this.bytes.toByteArray();
                return new String(allBytes, this.getCharacterEncoding());
            }
            catch (Exception e) {
                return this.bytes.toString();
            }
        }
        return "";
    }

    public static String getXMLEncoding(String xmlString) {
        Matcher m = XMLHEADER.matcher(xmlString);
        if (!m.matches()) {
            return null;
        }
        String encoding = m.group(1);
        if (encoding == null) {
            encoding = m.group(2);
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public static String getXMLEncoding(byte[] allBytes) {
        byte[] firstBytes = allBytes;
        if (allBytes.length > 100) {
            firstBytes = new byte[100];
            System.arraycopy(allBytes, 0, firstBytes, 0, 100);
        }
        try {
            return GenericResponseWrapper.getXMLEncoding(new String(firstBytes, "US-ASCII"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "UTF-8";
        }
    }

    public static String getEncoding(String contentType) {
        String contentTypeLowerCase = contentType.toLowerCase();
        int cs = contentTypeLowerCase.indexOf("charset=");
        if (cs > 0) {
            return contentType.substring(cs + 8);
        }
        return null;
    }

    public static String getDefaultEncoding(String contentType) {
        if ("text/xml".equals(contentType)) {
            return TEXT_XML_DEFAULT_CHARSET;
        }
        if ("application/xml".equals(contentType) || "application/xhtml+xml".equals(contentType)) {
            return "UTF-8";
        }
        return "iso-8859-1";
    }
}

