/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public final class IOUtil {
    private static final Logger log = Logging.getLoggerInstance(IOUtil.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtil() {
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        if (input instanceof FileInputStream && output instanceof FileOutputStream) {
            log.debug("Streams are for files, using nio.");
            return IOUtil.copy((FileInputStream)input, (FileOutputStream)output);
        }
        return IOUtil.copy(input, output, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(FileInputStream input, FileOutputStream output) throws IOException {
        FileChannel source = null;
        FileChannel destination = null;
        try {
            source = input.getChannel();
            destination = output.getChannel();
            log.debug("Copying " + source.size() + " bytes");
            destination.transferFrom(source, 0L, source.size());
            long l = source.size();
            return l;
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File from, File to) throws IOException {
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        try {
            long result;
            long l = result = IOUtil.copy(in, out);
            return l;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        long size = 0L;
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer, 0, bufferSize))) {
            output.write(buffer, 0, n);
            size += (long)n;
        }
        return size;
    }

    public static long copy(Reader input, Writer output) throws IOException {
        return IOUtil.copy(input, output, 4096);
    }

    public static long copy(Reader input, Writer output, int bufferSize) throws IOException {
        long size = 0L;
        char[] buffer = new char[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            size += (long)n;
        }
        output.flush();
        return size;
    }
}

