/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LinkMap<K, V>
extends AbstractMap<K, V> {
    private final Changes changes;
    private final Map<K, V> map1;
    private final Map<K, V> map2;

    public LinkMap(Map<K, V> m1, Map<K, V> m2, Changes c) {
        this.map1 = m1;
        this.map2 = m2;
        this.changes = c;
    }

    public LinkMap(Map<K, V> m1, Map<K, V> m2) {
        this(m1, m2, Changes.NONE);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator i = LinkMap.this.map1.entrySet().iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry entry1 = (Map.Entry)i.next();
                        final Object key = entry1.getKey();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return key;
                            }

                            @Override
                            public V getValue() {
                                if (LinkMap.this.map2.containsKey(key)) {
                                    return LinkMap.this.map2.get(key);
                                }
                                return entry1.getValue();
                            }

                            @Override
                            public V setValue(V v) {
                                return LinkMap.this.put(key, v);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return LinkMap.this.map1.size();
            }
        };
    }

    @Override
    public int size() {
        return this.map1.size();
    }

    @Override
    public V get(Object key) {
        if (this.map2.containsKey(key)) {
            return this.map2.get(key);
        }
        return this.map1.get(key);
    }

    @Override
    public V put(K key, V v) {
        V r = this.get(key);
        switch (this.changes) {
            case FIRST: {
                this.map1.put(key, v);
                break;
            }
            case SECOND: {
                this.map2.put(key, v);
                break;
            }
            case BOTH: {
                this.map1.put(key, v);
                this.map2.put(key, v);
                break;
            }
            case CONSERVE: {
                if (!this.map2.containsKey(key)) {
                    this.map2.put(key, r);
                }
                this.map1.put(key, v);
                break;
            }
            case NONE: {
                throw new UnsupportedOperationException();
            }
        }
        return r;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map1.containsKey(key);
    }

    public static void main(String[] args) {
        System.out.println("Please run with -ea");
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("a", "A");
        values.put("b", "B");
        System.out.println("values: " + values);
        String key = "b";
        String value = "C";
        HashMap originals = new HashMap();
        LinkMap<String, String> wrapper = new LinkMap<String, String>(values, originals, Changes.CONSERVE);
        wrapper.put("b", "C");
        Object newValue = values.get("b");
        Object originalValue = originals.get("b");
        assert (originalValue == wrapper.get("b"));
        assert (newValue == "C");
        assert ("B".equals(originalValue));
        System.out.println("wrapper: " + wrapper);
        System.out.println("originals: " + originals);
        System.out.println("values: " + values);
        key = "b";
        value = "D";
        LinkMap<String, String> wrapper2 = new LinkMap<String, String>(values, new HashMap(), Changes.SECOND);
        wrapper2.put("b", "D");
        Object newValue2 = wrapper2.get("b");
        Object oldValue = values.get("b");
        assert ("D" == newValue2);
        assert ("D".equals(newValue2));
        assert ("C".equals(oldValue));
        System.out.println("wrapper: " + wrapper2);
        System.out.println("values: " + values);
    }

    public static enum Changes {
        FIRST,
        SECOND,
        BOTH,
        CONSERVE,
        NONE;

    }
}

