/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;

public class LocalServletRequest
implements ServletRequest {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> parameters = new HashMap<String, String>();
    protected String charEncoding = "UTF-8";
    protected final String request;
    protected final ServletContext sx;

    public LocalServletRequest(ServletContext s, String r) {
        this.sx = s;
        this.request = r;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public int getContentLength() {
        return this.request.length();
    }

    public String getContentType() {
        return "text/html";
    }

    public ServletInputStream getInputStream() {
        return new ServletInputStream(){
            private InputStream is;
            {
                try {
                    this.is = new ByteArrayInputStream(LocalServletRequest.this.request.getBytes(LocalServletRequest.this.charEncoding));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }

            public int read() throws IOException {
                return this.is.read();
            }
        };
    }

    public String getLocalAddr() {
        return "localhost";
    }

    public Locale getLocale() {
        return Locale.US;
    }

    public Enumeration getLocales() {
        return Collections.enumeration(Collections.singletonList(Locale.US));
    }

    public String getLocalName() {
        return "localhost";
    }

    public int getLocalPort() {
        return -1;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return null;
    }

    public String getProtocol() {
        return "LOCAL/1";
    }

    public BufferedReader getReader() {
        return new BufferedReader(new StringReader(this.request));
    }

    @Deprecated
    public String getRealPath(String path) {
        return this.sx.getRealPath(path);
    }

    public String getRemoteAddr() {
        return "localhost";
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public int getRemotePort() {
        return 0;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.sx.getRequestDispatcher(path);
    }

    public String getScheme() {
        return "local";
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 0;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void setCharacterEncoding(String env) {
        this.charEncoding = env;
    }
}

