/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;

public class LocalServletResponse
implements ServletResponse {
    private final Writer writer;
    private final OutputStream output;
    private PrintWriter pwriter;
    private String characterEncoding = "UTF-8";
    private String contentType = "text/plain";
    private Locale locale = Locale.US;

    public LocalServletResponse(Writer w) {
        this.writer = w;
        this.output = new ByteArrayOutputStream();
    }

    public LocalServletResponse(OutputStream output) {
        this.output = output;
        this.writer = null;
    }

    public void flushBuffer() {
        if (this.writer != null) {
            try {
                this.writer.write(new String(((ByteArrayOutputStream)this.output).toByteArray(), this.characterEncoding));
                ((ByteArrayOutputStream)this.output).reset();
            }
            catch (Exception exception) {}
        } else {
            if (this.pwriter != null) {
                this.pwriter.flush();
            }
            try {
                this.output.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getBufferSize() {
        return 0;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() {
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
                LocalServletResponse.this.output.write(b);
            }

            public void flush() throws IOException {
                super.flush();
                LocalServletResponse.this.flushBuffer();
            }
        };
    }

    public PrintWriter getWriter() {
        if (this.pwriter == null) {
            this.pwriter = this.writer != null ? new PrintWriter(this.writer) : new PrintWriter(this.output, true);
        }
        return this.pwriter;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int size) {
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
    }

    public void setContentLength(int len) {
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }
}

