/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Locale;
import org.mmbase.util.LocalizedString;

public class LocaleCollator
extends Collator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Collator wrapped;
    private final Locale locale;

    public static Collator getInstance() {
        return new LocaleCollator(LocalizedString.getDefault());
    }

    public static Collator getInstance(String s) {
        String[] elements = s.split(":", -1);
        Locale locale = elements[0].equals("") ? LocalizedString.getDefault() : LocalizedString.getLocale(elements[0]);
        LocaleCollator collator = new LocaleCollator(locale);
        if (elements.length > 1) {
            ((Collator)collator).setStrength(Strength.valueOf(elements[1]).get());
        }
        if (elements.length > 2) {
            ((Collator)collator).setDecomposition(Decomposition.valueOf(elements[2]).get());
        }
        return collator;
    }

    private LocaleCollator(Locale loc) {
        this.locale = loc;
        this.wrapped = (Collator)Collator.getInstance(loc).clone();
    }

    public LocaleCollator(Locale loc, Collator col) {
        this.locale = loc;
        this.wrapped = col;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.wrapped.compare(o1, o2);
    }

    @Override
    public int compare(String source, String target) {
        return this.wrapped.compare(source, target);
    }

    @Override
    public boolean equals(Object that) {
        return this.wrapped.equals(that);
    }

    @Override
    public boolean equals(String source, String target) {
        return this.wrapped.equals(source, target);
    }

    @Override
    public CollationKey getCollationKey(String source) {
        return this.wrapped.getCollationKey(source);
    }

    @Override
    public int getDecomposition() {
        return this.wrapped.getDecomposition();
    }

    @Override
    public int getStrength() {
        return this.wrapped.getStrength();
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public void setDecomposition(int decompositionMode) {
        this.wrapped.setDecomposition(decompositionMode);
    }

    @Override
    public void setStrength(int newStrength) {
        this.wrapped.setStrength(newStrength);
    }

    public String toString() {
        return this.locale + ":" + (Object)((Object)Strength.valueOf(this.wrapped.getStrength())) + ":" + (Object)((Object)Decomposition.valueOf(this.wrapped.getDecomposition()));
    }

    public boolean matches(String s) {
        String[] elements = s.split(":", -1);
        if (elements[0].length() > 0) {
            Locale otherLocale = LocalizedString.getLocale(elements[0]);
            if (!otherLocale.getLanguage().equals(this.locale.getLanguage())) {
                return false;
            }
            if (otherLocale.getCountry().length() > 0 && this.locale.getCountry().length() > 0 && !otherLocale.getCountry().equals(this.locale.getCountry())) {
                return false;
            }
            if (otherLocale.getVariant().length() > 0 && this.locale.getVariant().length() > 0 && !otherLocale.getVariant().equals(this.locale.getVariant())) {
                return false;
            }
        }
        if (elements.length > 1 && Strength.valueOf(elements[1]).get() != this.getStrength()) {
            return false;
        }
        return elements.length <= 2 || Decomposition.valueOf(elements[2]).get() == this.getDecomposition();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.wrapped.getClass().getName());
        if (!(this.wrapped instanceof RuleBasedCollator)) {
            throw new IOException("Don't know how to serialize " + this.wrapped);
        }
        out.writeUTF(((RuleBasedCollator)this.wrapped).getRules());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String clazz = in.readUTF();
        try {
            this.wrapped = new RuleBasedCollator(in.readUTF());
        }
        catch (ParseException pe) {
            IOException e = new IOException(pe.getMessage());
            e.initCause(pe);
            throw e;
        }
    }

    public static void main(String[] argv) throws Exception {
        String[][] s;
        Collator col = LocaleCollator.getInstance(argv[0]);
        System.out.println("" + col);
        for (String[] pair : s = new String[][]{{"a", "A"}, {"a", "\u00ef\u00bf\u00bd"}, {"a", "\u00ef\u00bf\u00bd"}, {"a", "x"}, {"\u00ef\u00bf\u00bd", "z"}, {"\u00ef\u00bf\u00bd", "z"}}) {
            System.out.println("COMPARE " + pair[0] + "/" + pair[1] + ": " + col.compare(pair[0], pair[1]) + " " + col.equals(pair[0], pair[1]));
        }
    }

    public static enum Decomposition {
        CANONICAL(1),
        FULL(2),
        NO(0);

        private final int value;

        private Decomposition(int v) {
            this.value = v;
        }

        public int get() {
            return this.value;
        }

        public static Decomposition valueOf(int i) {
            for (Decomposition s : Decomposition.values()) {
                if (s.get() != i) continue;
                return s;
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum Strength {
        IDENTICAL(3),
        PRIMARY(0),
        SECONDARY(1),
        TERTIARY(2);

        private final int value;

        private Strength(int v) {
            this.value = v;
        }

        public int get() {
            return this.value;
        }

        public static Strength valueOf(int i) {
            for (Strength s : Strength.values()) {
                if (s.get() != i) continue;
                return s;
            }
            throw new IllegalArgumentException();
        }
    }
}

