/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.mmbase.core.event.SystemEvent;
import org.mmbase.core.event.SystemEventListener;
import org.mmbase.util.HashCodeUtil;
import org.mmbase.util.PublicCloneable;
import org.mmbase.util.ReadonlyLocalizedString;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.DocumentReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LocalizedString
implements Serializable,
PublicCloneable<LocalizedString> {
    private static final Logger LOG = Logging.getLoggerInstance(LocalizedString.class);
    private static final long serialVersionUID = 1L;
    public static final String FMT_DEFAULT_PARAM = "javax.servlet.jsp.jstl.fmt.locale";
    private static Locale defaultLocale = null;
    private String key;
    private Map<Locale, String> values = null;
    private String bundle = null;

    public static Locale setDefault(Locale locale) {
        Locale prev = defaultLocale;
        defaultLocale = locale;
        return prev;
    }

    public static Locale getDefault() {
        return defaultLocale != null ? defaultLocale : Locale.getDefault();
    }

    public static Collection<String> toStrings(Collection<LocalizedString> col, Locale locale) {
        ArrayList<String> res = new ArrayList<String>();
        for (LocalizedString s : col) {
            res.add(s.get(locale));
        }
        return res;
    }

    public LocalizedString(String k) {
        this.key = k;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String get(Locale locale) {
        block9: {
            if (locale == null) {
                locale = LocalizedString.getDefault();
            }
            if (this.values != null) {
                String result = this.values.get(locale);
                if (result != null) {
                    return result;
                }
                String variant = locale.getVariant();
                String country = locale.getCountry();
                String language = locale.getLanguage();
                if (!"".equals(variant) && (result = this.values.get(new Locale(language, country))) != null) {
                    return result;
                }
                if (!"".equals(country) && (result = this.values.get(new Locale(language))) != null) {
                    return result;
                }
                result = this.values.get(null);
                if (result != null) {
                    return result;
                }
            }
            if (this.bundle != null) {
                try {
                    return ResourceBundle.getBundle(this.bundle, locale).getString(this.key);
                }
                catch (MissingResourceException mre) {
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.debug("Cannot get resource from bundle: " + this.bundle + ", key: " + this.key);
                }
            }
        }
        return this.key;
    }

    public void set(String value, Locale locale) {
        if (this.key == null) {
            this.key = value;
        }
        if (this.values == null) {
            this.values = new HashMap<Locale, String>();
        }
        this.values.put(locale, value);
        if (locale != null) {
            Locale loc;
            String variant = locale.getVariant();
            String country = locale.getCountry();
            String language = locale.getLanguage();
            if (!"".equals(variant) && this.values.get(loc = new Locale(language, country)) == null) {
                this.values.put(loc, value);
            }
            if (!"".equals(country) && this.values.get(loc = new Locale(language)) == null) {
                this.values.put(loc, value);
            }
        }
    }

    public Map<Locale, String> asMap() {
        if (this.values == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.values);
    }

    protected Map<Locale, String> getValues() {
        return this.values;
    }

    protected String getBundle() {
        return this.bundle;
    }

    public void setBundle(String b) {
        this.bundle = b;
    }

    public String toString() {
        return this.get(null);
    }

    public String getDebugString() {
        return "k: " + this.getKey() + " values: " + this.getValues() + " b:" + this.getBundle() + " dl: " + defaultLocale;
    }

    public static Locale getLocale(Element element) {
        return LocalizedString.getLocale(element.getAttribute("xml:lang"));
    }

    public static Locale getLocale(String xmlLang) {
        Locale loc = null;
        if (xmlLang != null && !xmlLang.equals("")) {
            String[] split = xmlLang.split("[-_]", 3);
            loc = split.length == 1 ? new Locale(split[0]) : (split.length == 2 ? new Locale(split[0], split[1]) : new Locale(split[0], split[1], split[2]));
        }
        return loc;
    }

    public static Locale degrade(Locale locale, Locale originalLocale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (variant != null && !"".equals(variant)) {
            String[] var = variant.split("_");
            if (var.length > 1) {
                StringBuilder v = new StringBuilder(var[0]);
                for (int i = 1; i < var.length - 1; ++i) {
                    v.append('_');
                    v.append(var[i]);
                }
                return new Locale(language, country, v.toString());
            }
            return new Locale(language, country);
        }
        if (!"".equals(country)) {
            String originalVariant = originalLocale.getVariant();
            if (originalVariant != null && !"".equals(originalVariant)) {
                return new Locale(language, "", originalVariant);
            }
            return new Locale(language);
        }
        return null;
    }

    public static List<Locale> degrade(Locale locale) {
        ArrayList<Locale> result = new ArrayList<Locale>();
        while (locale != null) {
            result.add(locale);
            locale = LocalizedString.degrade(locale, (Locale)result.get(0));
        }
        return result;
    }

    public static String getXmlLang(Locale locale) {
        if (locale == null) {
            return null;
        }
        StringBuilder lang = new StringBuilder(locale.getLanguage());
        String country = locale.getCountry();
        if (country.length() > 0) {
            lang.append("-").append(country);
            String variant = locale.getVariant();
            if (variant != null && variant.length() > 0) {
                lang.append("-").append(variant);
            }
        }
        return lang.toString();
    }

    public static void setXmlLang(Element element, Locale locale) {
        String xmlLang = LocalizedString.getXmlLang(locale);
        if (xmlLang != null) {
            element.setAttribute("xml:lang", xmlLang);
        }
    }

    public void fillFromXml(String tagName, Element element) {
        if (element == null) {
            return;
        }
        NodeList childNodes = element.getChildNodes();
        for (int k = 0; k < childNodes.getLength(); ++k) {
            Element childElement;
            if (!(childNodes.item(k) instanceof Element) || !tagName.equals((childElement = (Element)childNodes.item(k)).getLocalName())) continue;
            Locale locale = LocalizedString.getLocale(childElement);
            String description = DocumentReader.getNodeTextValue(childElement);
            this.set(description, locale);
        }
    }

    public void toXml(String tagName, String ns, Element element, String path) {
        if (this.values != null) {
            NodeList nl = element.getElementsByTagName(tagName);
            for (Map.Entry<Locale, String> entry : this.values.entrySet()) {
                Locale loc = entry.getKey();
                String value = entry.getValue();
                String xmlLang = LocalizedString.getXmlLang(loc);
                Element child = null;
                for (int j = 0; j < nl.getLength(); ++j) {
                    Element cand = (Element)nl.item(j);
                    String l = cand.getAttribute("xml:lang");
                    if (!l.equals(xmlLang) && (!l.equals("") || xmlLang != null)) continue;
                    child = cand;
                    break;
                }
                if (child == null) {
                    child = ns != null ? element.getOwnerDocument().createElementNS(ns, tagName) : element.getOwnerDocument().createElement(tagName);
                    if (loc != null || value.length() > 0) {
                        DocumentReader.appendChild(element, child, path);
                    }
                    LocalizedString.setXmlLang(child, loc);
                }
                DocumentReader.setNodeTextValue(child, value);
            }
        }
    }

    @Override
    public LocalizedString clone() {
        try {
            LocalizedString clone = (LocalizedString)super.clone();
            if (this.values != null) {
                clone.values = (Map)((HashMap)this.values).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("Cannot clone this LocalizedString", cnse);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof LocalizedString) {
            LocalizedString os = (LocalizedString)o;
            return this.key.equals(os.getKey()) && (this.values == null ? os.getValues() == null : this.values.equals(os.getValues())) && (this.bundle == null ? os.getBundle() == null : this.bundle.equals(os.getBundle()));
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        result = HashCodeUtil.hashCode(result, this.key);
        result = HashCodeUtil.hashCode(result, this.values);
        result = HashCodeUtil.hashCode(result, this.bundle);
        return result;
    }

    public ReadonlyLocalizedString getReadonlyLocalizedString() {
        return new ReadonlyLocalizedString(this);
    }

    public static class DefaultFromServletContext
    implements SystemEventListener {
        @Override
        public void notify(SystemEvent se) {
            if (se instanceof SystemEvent.ServletContext) {
                ServletContext sx = ((SystemEvent.ServletContext)se).getServletContext();
                String fmtDefault = sx.getInitParameter(LocalizedString.FMT_DEFAULT_PARAM);
                if (fmtDefault != null) {
                    Locale prev = LocalizedString.setDefault(LocalizedString.getLocale(fmtDefault));
                    if (prev != null) {
                        LOG.warn("Reset " + prev + "  from " + LocalizedString.FMT_DEFAULT_PARAM + ": " + LocalizedString.getDefault());
                    } else {
                        LOG.service("Default from javax.servlet.jsp.jstl.fmt.locale: " + LocalizedString.getDefault());
                    }
                } else {
                    LOG.service("No javax.servlet.jsp.jstl.fmt.locale found");
                }
            }
        }

        @Override
        public int getWeight() {
            return -1000;
        }

        public boolean equals(Object o) {
            return o instanceof DefaultFromServletContext;
        }

        public int hashCode() {
            return 0;
        }
    }
}

