/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.Serializable;

public class MimeType
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final String STAR = "*";
    public static final MimeType ANY = new MimeType("*", "*");
    public static final MimeType OCTETSTREAM = new MimeType("application", "octet-stream");
    public static final MimeType UNDETERMINED = new MimeType("unknown", "unknown");
    private final String type;
    private final String subType;

    public MimeType(String s) {
        if (s != null && s.length() > 0) {
            String[] m = s.split("/", 2);
            this.type = m[0];
            this.subType = m.length > 1 ? m[1] : STAR;
        } else {
            this.type = STAR;
            this.subType = STAR;
        }
    }

    public MimeType(String t, String s) {
        this.type = t;
        this.subType = s;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public String toString() {
        return this.type + "/" + this.subType;
    }

    public boolean matches(MimeType mt) {
        return !(!this.type.equals(STAR) && !mt.type.equals(STAR) && !this.type.equals(mt.type) || !this.subType.equals(STAR) && !mt.subType.equals(STAR) && !this.subType.equals(mt.subType));
    }

    public int hashCode() {
        return this.type.hashCode() + 13 * this.subType.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MimeType) {
            MimeType m = (MimeType)o;
            return m.type.equals(this.type) && m.subType.equals(this.subType);
        }
        return false;
    }
}

