/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class RelativeTime {
    private static final int HOUR_POS = 0;
    private static final int MINUTE_POS = 1;
    private static final int SECOND_POS = 2;
    private static final int MILLI_POS = 3;
    private static final Logger log = Logging.getLoggerInstance(RelativeTime.class.getName());

    public static int getHours(int timeValue) {
        return RelativeTime.getTimeValue(timeValue, 0);
    }

    public static int getMinutes(int timeValue) {
        return RelativeTime.getTimeValue(timeValue, 1);
    }

    public static int getSeconds(int timeValue) {
        return RelativeTime.getTimeValue(timeValue, 2);
    }

    public static int getMillis(int timeValue) {
        return RelativeTime.getTimeValue(timeValue, 3);
    }

    private static int getTimeValue(int timeValue, int timePos) {
        int HOUR_IN_MILLIS = 3600000;
        int MINUTE_IN_MILLIS = 60000;
        int SECOND_IN_MILLIS = 1000;
        if (timeValue >= 0) {
            int timeLeft = timeValue;
            int hoursLeft = timeLeft / HOUR_IN_MILLIS;
            if (timePos == 0) {
                return hoursLeft;
            }
            int minutesLeft = (timeLeft -= hoursLeft * HOUR_IN_MILLIS) / MINUTE_IN_MILLIS;
            if (timePos == 1) {
                return minutesLeft;
            }
            int secondsLeft = (timeLeft -= minutesLeft * MINUTE_IN_MILLIS) / SECOND_IN_MILLIS;
            if (timePos == 2) {
                return secondsLeft;
            }
            int millisLeft = timeLeft -= secondsLeft * SECOND_IN_MILLIS;
            if (timePos == 3) {
                return millisLeft;
            }
            log.warn("Invalid timePos used -> timePos=" + timePos + " returning -1");
            return -1;
        }
        log.warn("Negative timeValue used at position " + timePos + " -> timeValue=" + timeValue + " returning -1");
        return -1;
    }

    public static String convertIntToTime(int timeValue) {
        int h = RelativeTime.getHours(timeValue);
        int m = RelativeTime.getMinutes(timeValue);
        int s = RelativeTime.getSeconds(timeValue);
        int ms = RelativeTime.getMillis(timeValue);
        if (!RelativeTime.testTimeValue(h, 0)) {
            h = -1;
        }
        if (!RelativeTime.testTimeValue(m, 1)) {
            m = -1;
        }
        if (!RelativeTime.testTimeValue(s, 2)) {
            s = -1;
        }
        if (!RelativeTime.testTimeValue(ms, 3)) {
            ms = -1;
        }
        if (ms < 0) {
            return h + ":" + m + ":" + s + "." + ms;
        }
        if ((double)ms / 100.0 >= 1.0) {
            return h + ":" + m + ":" + s + "." + ms;
        }
        if ((double)ms / 10.0 >= 1.0) {
            return h + ":" + m + ":" + s + ".0" + ms;
        }
        return h + ":" + m + ":" + s + ".00" + ms;
    }

    public static int convertTimeToInt(int h, int m, int s, int ms) {
        if (ms < 0) {
            return RelativeTime.convertTimeToInt(h + ":" + m + ":" + s + "." + ms);
        }
        if ((double)ms / 100.0 >= 1.0) {
            return RelativeTime.convertTimeToInt(h + ":" + m + ":" + s + "." + ms);
        }
        if ((double)ms / 10.0 >= 1.0) {
            return RelativeTime.convertTimeToInt(h + ":" + m + ":" + s + ".0" + ms);
        }
        return RelativeTime.convertTimeToInt(h + ":" + m + ":" + s + ".00" + ms);
    }

    public static int convertTimeToInt(String time) {
        int result = 0;
        String[] attrStrValues = new String[4];
        int timePos = 0;
        StringTokenizer st = new StringTokenizer(time, ":.");
        while (st.hasMoreTokens()) {
            attrStrValues[timePos] = new String(st.nextToken());
            ++timePos;
        }
        for (int i = 0; i < attrStrValues.length; ++i) {
            if (RelativeTime.testTimeValue(Integer.parseInt(attrStrValues[i]), i)) continue;
            return -1;
        }
        int attrIntValue = Integer.parseInt(attrStrValues[0]);
        result += attrIntValue * 3600 * 1000;
        attrIntValue = Integer.parseInt(attrStrValues[1]);
        result += attrIntValue * 60 * 1000;
        attrIntValue = Integer.parseInt(attrStrValues[2]);
        result += attrIntValue * 1000;
        attrIntValue = Integer.parseInt(attrStrValues[3]);
        if (attrStrValues[3].length() == 3) {
            result += attrIntValue;
        } else if (attrStrValues[3].length() == 2) {
            result += 10 * attrIntValue;
        } else if (attrStrValues[3].length() == 1) {
            result += 100 * attrIntValue;
        }
        return result;
    }

    private static boolean testTimeValue(int timeAttrValue, int timePos) {
        if (timeAttrValue < 0) {
            log.warn("Negative timeAttrValue used at position " + timePos + " -> timeAttrValue=" + timeAttrValue + " returning false");
            return false;
        }
        if (timePos == 0) {
            if (timeAttrValue > 23) {
                log.warn("Invalid timeAttrValue used at position " + timePos + " -> timeAttrValue=" + timeAttrValue + " returning false");
                return false;
            }
        } else if (timePos == 1) {
            if (timeAttrValue > 59) {
                log.warn("Invalid timeAttrValue used at position " + timePos + " -> timeAttrValue=" + timeAttrValue + " returning false");
                return false;
            }
        } else if (timePos == 2) {
            if (timeAttrValue > 59) {
                log.warn("Invalid timeAttrValue used at position " + timePos + " -> timeAttrValue=" + timeAttrValue + " returning false");
                return false;
            }
        } else if (timePos == 3) {
            if (timeAttrValue > 999) {
                log.warn("Invalid timeAttrValue used at position " + timePos + " -> timeAttrValue=" + timeAttrValue + " returning false");
                return false;
            }
        } else {
            log.warn("Invalid timePos provided -> timePos=" + timePos + " returning false");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Properties testProps = new Properties();
        testProps.put("23:59:59.999", (Object)86399999);
        testProps.put("0:0:0.0", (Object)0);
        testProps.put("23:0:0.0", (Object)82800000);
        testProps.put("0:59:0.0", (Object)3540000);
        testProps.put("0:0:59.0", (Object)59000);
        testProps.put("0:0:0.999", (Object)999);
        testProps.put("1:33:59.5", (Object)5639500);
        testProps.put("1:33:59.52", (Object)5639520);
        testProps.put("1:33:59.521", (Object)5639521);
        testProps.put("1:33:59.012", (Object)5639012);
        testProps.put("1:33:09.002", (Object)5589002);
        testProps.put("24:33:09.002", (Object)88389002);
        testProps.put("0:0:2.100", (Object)2100);
        testProps.put("0:0:2.010", (Object)2010);
        log.info("----------------------------------------");
        log.info("|Testing RelativeTime util class       |");
        log.info("----------------------------------------");
        if (args.length < 1 || args.length > 1) {
            log.info("Usage: RelativeTime methodName");
            log.info("Methods available: getHours,getMinutes,getSeconds,getMillis,convertIntToTime,convertTimeToInt,convertTimeToInt2");
        } else if (args[0].equals("getHours")) {
            log.info("Testing method: " + args[0]);
            Enumeration<Object> e = testProps.keys();
            while (e.hasMoreElements()) {
                String timeKey = (String)e.nextElement();
                int timeValue = (Integer)testProps.get(timeKey);
                log.info("getHours using time = " + timeKey + " ->" + RelativeTime.getHours(timeValue));
            }
        } else if (args[0].equals("getMinutes")) {
            log.info("Testing method: " + args[0]);
            Enumeration<Object> e = testProps.keys();
            while (e.hasMoreElements()) {
                String timeKey = (String)e.nextElement();
                int timeValue = (Integer)testProps.get(timeKey);
                log.info("getMinutes using time = " + timeKey + " ->" + RelativeTime.getMinutes(timeValue));
            }
        } else if (args[0].equals("getSeconds")) {
            log.info("Testing method: " + args[0]);
            Enumeration<Object> e = testProps.keys();
            while (e.hasMoreElements()) {
                String timeKey = (String)e.nextElement();
                int timeValue = (Integer)testProps.get(timeKey);
                log.info("getSeconds using time = " + timeKey + " ->" + RelativeTime.getSeconds(timeValue));
            }
        } else if (args[0].equals("getMillis")) {
            log.info("Testing method: " + args[0]);
            Enumeration<Object> e = testProps.keys();
            while (e.hasMoreElements()) {
                String timeKey = (String)e.nextElement();
                int timeValue = (Integer)testProps.get(timeKey);
                log.info("getMillis using time  = " + timeKey + " ->" + RelativeTime.getMillis(timeValue));
            }
        } else if (args[0].equals("convertIntToTime")) {
            log.info("Testing method: " + args[0]);
            Enumeration<Object> e = testProps.elements();
            while (e.hasMoreElements()) {
                int timeValue = (Integer)e.nextElement();
                log.info("convertIntToTime using timeValue = " + timeValue + " ->" + RelativeTime.convertIntToTime(timeValue));
            }
        } else if (args[0].equals("convertTimeToInt")) {
            log.info("Testing method: " + args[0]);
            Enumeration<Object> e = testProps.keys();
            while (e.hasMoreElements()) {
                String timeKey = (String)e.nextElement();
                int timeValue = RelativeTime.convertTimeToInt(timeKey);
                log.info("convertTimeToInt using timeKey=" + timeKey + " , timeValue=" + timeValue + " in testProps? " + testProps.contains(timeValue));
            }
        } else if (args[0].equals("convertTimeToInt2")) {
            log.info("Testing method: " + args[0]);
            int timeValue = RelativeTime.convertTimeToInt(4, 33, 9, 32);
            log.info("convertTimeToInt2 using 4:33:9:32 , timeValue=" + timeValue);
        }
    }
}

