/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.mmbase.util.Entry;
import org.mmbase.util.LocalizedString;
import org.mmbase.util.WrappedLocalizedString;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class ReplacingLocalizedString
extends WrappedLocalizedString {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logging.getLoggerInstance(ReplacingLocalizedString.class);
    private List<Map.Entry<String, String>> replacements = new ArrayList<Map.Entry<String, String>>();

    public ReplacingLocalizedString(LocalizedString s) {
        super(s);
    }

    public void replaceAll(String regexp, String replacement) {
        this.replacements.add(new Entry<String, String>(regexp, replacement));
    }

    protected String replace(String input) {
        String output = input;
        for (Map.Entry<String, String> entry : this.replacements) {
            try {
                output = output.replaceAll(entry.getKey(), entry.getValue());
            }
            catch (Throwable t) {
                log.warn("Could not replace " + entry + " in " + input + " because " + t);
            }
        }
        return output;
    }

    @Override
    public String get(Locale locale) {
        return this.replace(super.get(locale));
    }

    @Override
    public Map<Locale, String> asMap() {
        final Map<Locale, String> map = super.asMap();
        return new AbstractMap<Locale, String>(){

            @Override
            public Set<Map.Entry<Locale, String>> entrySet() {
                return new AbstractSet<Map.Entry<Locale, String>>(){

                    @Override
                    public int size() {
                        return map.size();
                    }

                    @Override
                    public Iterator<Map.Entry<Locale, String>> iterator() {
                        final Iterator it = map.entrySet().iterator();
                        return new Iterator<Map.Entry<Locale, String>>(){

                            @Override
                            public boolean hasNext() {
                                return it.hasNext();
                            }

                            @Override
                            public Map.Entry<Locale, String> next() {
                                final Map.Entry value = (Map.Entry)it.next();
                                return new Map.Entry<Locale, String>(){

                                    @Override
                                    public Locale getKey() {
                                        return (Locale)value.getKey();
                                    }

                                    @Override
                                    public String getValue() {
                                        return ReplacingLocalizedString.this.replace((String)value.getValue());
                                    }

                                    @Override
                                    public String setValue(String v) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }
        };
    }

    @Override
    public ReplacingLocalizedString clone() {
        ReplacingLocalizedString clone = (ReplacingLocalizedString)super.clone();
        clone.replacements = (List)((ArrayList)this.replacements).clone();
        return clone;
    }

    public static String makeLiteral(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\\\", "\\\\\\\\");
        s = s.replaceAll("\\.", "\\\\.");
        s = s.replaceAll("\\+", "\\\\+");
        return s.replaceAll("\\$", "\\\\\\$");
    }

    public static void main(String[] argv) {
        ReplacingLocalizedString s = new ReplacingLocalizedString(new LocalizedString("abcd"));
        s.replaceAll("b", ReplacingLocalizedString.makeLiteral(argv[0]));
        System.out.println(s.get(null));
    }
}

