/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.fileupload.FileItem;
import org.mmbase.util.IOUtil;
import org.mmbase.util.MimeType;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.magicfile.MagicFile;

public class SerializableInputStream
extends InputStream
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger log = Logging.getLoggerInstance(SerializableInputStream.class);
    private long size;
    private File file = null;
    private long fileMark = 0L;
    private boolean tempFile = true;
    private String name;
    private MimeType contentType = null;
    private transient InputStream wrapped;
    private boolean used = false;

    public static byte[] toByteArray(InputStream stream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int n;
            byte[] buf = new byte[1024];
            while ((n = stream.read(buf)) > -1) {
                bos.write(buf, 0, n);
            }
        }
        catch (IOException ioe) {
            log.error(ioe);
        }
        return bos.toByteArray();
    }

    public SerializableInputStream(InputStream wrapped, long s) {
        this.wrapped = wrapped;
        this.size = s;
        this.name = null;
        if (wrapped == null) {
            throw new NullPointerException();
        }
        if (wrapped.markSupported()) {
            wrapped.mark(Integer.MAX_VALUE);
        }
    }

    public SerializableInputStream(File tempFile, String name) throws IOException {
        this.file = tempFile;
        this.wrapped = new FileInputStream(tempFile);
        this.size = tempFile.length();
        this.name = name;
        if (tempFile.length() > 0L) {
            String ct = MagicFile.getInstance().getMimeType(tempFile);
            if ("Failed to determine type".equals(ct)) {
                log.warn("Failed to determin type of " + tempFile);
                this.contentType = MimeType.UNDETERMINED;
            } else {
                this.contentType = new MimeType(ct);
            }
        }
    }

    public SerializableInputStream(File tempFile) throws IOException {
        this(tempFile, tempFile.getName());
    }

    public SerializableInputStream(byte[] array) {
        this.wrapped = new ByteArrayInputStream(array);
        this.size = array.length;
        this.name = null;
        if (array.length > 0) {
            try {
                String ct = MagicFile.getInstance().getMimeType(array);
                if ("Failed to determine type".equals(ct)) {
                    log.warn("Failed to determin type of byte array");
                    this.contentType = MimeType.UNDETERMINED;
                } else {
                    this.contentType = new MimeType(ct);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SerializableInputStream(FileItem fi) throws IOException {
        this.size = fi.getSize();
        this.name = fi.getName();
        this.contentType = new MimeType(fi.getContentType());
        this.file = new File(System.getProperty("java.io.tmpdir"), this.getClass().getName() + UUID.randomUUID() + this.name);
        this.file.deleteOnExit();
        try {
            fi.write(this.file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.wrapped = new FileInputStream(this.file);
    }

    SerializableInputStream(SerializableInputStream is) throws IOException {
        if (is.file == null) {
            is.supportMark();
        }
        this.size = is.size;
        this.tempFile = is.tempFile;
        this.name = is.name;
        this.contentType = is.contentType;
        this.used = is.used;
        if (this.tempFile) {
            this.file = File.createTempFile(this.getClass().getName(), this.name);
            this.file.deleteOnExit();
            FileOutputStream os = new FileOutputStream(this.file);
            FileInputStream in = new FileInputStream(is.file);
            IOUtil.copy(in, os);
            os.close();
            is.close();
            this.wrapped = in;
            this.reset();
        } else {
            this.file = is.file;
            this.wrapped = is.wrapped;
        }
    }

    private synchronized void use() {
        if (!this.used) {
            if (log.isTraceEnabled()) {
                log.trace("Using " + this + " because ", new Exception());
            }
            this.used = true;
            if (!this.wrapped.markSupported() && this.file == null) {
                this.supportMark();
            }
        }
    }

    public long getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType == null || MimeType.UNDETERMINED.equals(this.contentType) ? null : this.contentType.toString();
    }

    public void setContentType(MimeType ct) {
        this.contentType = ct;
    }

    public synchronized byte[] get() throws IOException {
        if (this.wrapped == null) {
            throw new IllegalStateException();
        }
        if (this.file != null || this.wrapped.markSupported()) {
            log.debug("Making byte array of " + this.wrapped);
            this.reset();
            byte[] b = SerializableInputStream.toByteArray(this.wrapped);
            log.debug("Resetting");
            this.reset();
            return b;
        }
        log.debug("Making byte array of " + this.wrapped);
        byte[] b = SerializableInputStream.toByteArray(this.wrapped);
        this.wrapped = new ByteArrayInputStream(b);
        log.debug("Converted to bytearray" + this.wrapped);
        return b;
    }

    public synchronized void moveTo(File f) {
        if (this.name == null) {
            this.name = f.getName();
        }
        log.debug("Moving " + (this.file == null ? "" + this : "" + this.file) + " to " + f);
        if (this.file != null) {
            if (this.file.equals(f)) {
                log.debug("File is already there " + f);
                return;
            }
            if (this.file.renameTo(f)) {
                try {
                    log.debug("Renamed " + this.file + " to " + f);
                    this.file = f;
                    this.wrapped = new FileInputStream(this.file);
                    this.tempFile = false;
                    return;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            log.debug("Could not rename " + this.file + " to " + f + " will copy/delete in stead");
        }
        try {
            FileOutputStream os = new FileOutputStream(f);
            IOUtil.copy(this.wrapped, (OutputStream)os);
            os.close();
            this.wrapped = new FileInputStream(f);
            if (this.file != null) {
                this.file.delete();
            }
            this.file = f;
            this.tempFile = false;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected void _writeObject(ObjectOutputStream out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Serializing " + this);
        }
        if (this.file == null) {
            this.supportMark();
        }
        this.reset();
        out.writeObject(this.get());
        out.writeObject(this.name);
        out.writeObject(this.contentType);
        this.reset();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this._writeObject(out);
    }

    protected void _readObject(ObjectInputStream oin) throws IOException, ClassNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("DeSerializing " + this);
        }
        byte[] b = (byte[])oin.readObject();
        this.wrapped = new ByteArrayInputStream(b);
        this.size = b.length;
        this.name = (String)oin.readObject();
        this.contentType = (MimeType)oin.readObject();
    }

    private void readObject(ObjectInputStream oin) throws IOException, ClassNotFoundException {
        this._readObject(oin);
    }

    private synchronized FileInputStream supportMark() {
        try {
            assert (this.file == null);
            this.file = File.createTempFile(this.getClass().getName(), this.name);
            this.file.deleteOnExit();
            FileOutputStream os = new FileOutputStream(this.file);
            IOUtil.copy(this.wrapped, (OutputStream)os);
            os.close();
            FileInputStream fis = new FileInputStream(this.file);
            this.wrapped = fis;
            if (log.isDebugEnabled()) {
                log.debug("Created " + fis + "" + this.file.length());
            }
            return fis;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.file != null && this.tempFile) {
            log.debug("Deleting " + this.file);
            this.file.delete();
        }
    }

    @Override
    public void close() throws IOException {
        this.use();
        this.wrapped.close();
    }

    @Override
    public void mark(int readlimit) {
        log.debug("Marking" + this.wrapped, new Exception());
        if (this.wrapped.markSupported()) {
            this.wrapped.mark(readlimit);
            return;
        }
        try {
            FileInputStream fis = this.file != null ? (FileInputStream)this.wrapped : this.supportMark();
            this.fileMark = fis.getChannel().position();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        this.use();
        return this.wrapped.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.use();
        return this.wrapped.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.use();
        int res = this.wrapped.read(b, off, len);
        if (log.isTraceEnabled()) {
            log.trace("Reading  " + res + "/" + len + " offset " + off + " from " + this.wrapped, new Exception());
        }
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        this.use();
        log.trace("Skipping " + n + " from " + this.wrapped);
        return this.wrapped.skip(n);
    }

    @Override
    public final void reset() throws IOException {
        if (this.wrapped.markSupported()) {
            log.debug("" + this.wrapped + " supports mark, using it");
            this.wrapped.reset();
        } else if (this.file != null) {
            if (log.isDebugEnabled()) {
                log.debug("Resetting " + this + " to " + this.fileMark + " (" + this.file + ")");
            }
            if (this.wrapped != null) {
                this.wrapped.close();
            }
            this.wrapped = new FileInputStream(this.file);
            if (this.fileMark > 0L) {
                this.wrapped.skip(this.fileMark);
            }
        } else {
            log.debug("No file yet");
            this.supportMark();
        }
    }

    public String toString() {
        String filePos;
        try {
            FileChannel chan;
            filePos = this.wrapped instanceof FileInputStream ? ((chan = ((FileInputStream)this.wrapped).getChannel()).isOpen() ? "" + chan.position() : "close") : "?";
        }
        catch (IOException ioe) {
            filePos = ioe.getMessage();
        }
        return "SERIALIZABLE " + this.wrapped + (this.tempFile ? " (tempfile: " + this.file + ") " : (this.file != null ? "(" + this.file + ")" : "")) + " (" + this.size + " byte, " + (this.name == null ? "[no name]" : this.name) + ", " + (this.contentType == null ? "[no contenttype]" : this.contentType) + (this.fileMark > 0L ? " mark: " + this.fileMark : "") + (filePos.equals("0") ? "" : " position: " + filePos) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean inputStreamEquals(SerializableInputStream in1, SerializableInputStream in2) throws IOException {
        in1.mark(Integer.MAX_VALUE);
        in2.mark(Integer.MAX_VALUE);
        try {
            byte[] buffer1 = new byte[1024];
            byte[] buffer2 = new byte[1024];
            while (true) {
                int n2;
                int n1;
                if ((n1 = in1.read(buffer1)) != (n2 = in2.read(buffer2))) {
                    boolean bl = false;
                    return bl;
                }
                if (n1 == -1) break;
                if (Arrays.equals(buffer1, buffer2)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            in1.reset();
            in2.reset();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof SerializableInputStream) {
            SerializableInputStream s = (SerializableInputStream)o;
            try {
                return this.getSize() == s.getSize() && (this.getName() == null ? s.getName() == null : this.getName().equals(s.getName())) && (this.getContentType() == null ? s.getContentType() == null : this.getContentType().equals(s.getContentType())) && this.fileMark == s.fileMark && (this.file != null && this.file.equals(s.file) || SerializableInputStream.inputStreamEquals(this, s));
            }
            catch (IOException ioe) {
                log.error(ioe);
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (int)(this.size ^ this.size >>> 32);
        hash = 43 * hash + (this.wrapped != null ? this.wrapped.hashCode() : 0);
        hash = 43 * hash + (this.file != null ? this.file.hashCode() : 0);
        hash = 43 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 43 * hash + (this.contentType != null ? this.contentType.hashCode() : 0);
        return hash;
    }

    File getFile() {
        return this.file;
    }

    public String getFileName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.name;
    }
}

