/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import org.mmbase.util.Casting;
import org.mmbase.util.HashCodeUtil;
import org.mmbase.util.LocalizedString;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class SortedBundle {
    private static final Logger log = Logging.getLoggerInstance(SortedBundle.class);
    public static final Class<?> NO_WRAPPER = null;
    public static final Comparator<? super Object> NO_COMPARATOR = null;
    public static final HashMap<String, Object> NO_CONSTANTSPROVIDER = null;

    public static <C> SortedMap<C, String> getResource(String baseName, Locale locale, ClassLoader loader, Map<String, Object> constantsProvider, Class<?> wrapper, Comparator<? super Object> comparator) {
        SortedMap<Object, String> m = null;
        if (locale == null) {
            locale = LocalizedString.getDefault();
        }
        if (m == null) {
            ResourceBundle bundle = loader == null ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName, locale, loader);
            if (comparator == null && wrapper != null && !Comparable.class.isAssignableFrom(wrapper)) {
                throw new IllegalArgumentException("Key wrapper " + wrapper + " is not Comparable");
            }
            m = new TreeMap(comparator);
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String value;
                String bundleKey = keys.nextElement();
                Object key = SortedBundle.castKey(bundleKey, value = bundle.getString(bundleKey), constantsProvider, wrapper, locale);
                if (key == null) continue;
                m.put(key, value);
            }
            m = Collections.unmodifiableSortedMap(m);
        }
        return m;
    }

    public static Object castKey(String bundleKey, Object value, Map<String, Object> constantsProvider, Class<?> wrapper) {
        return SortedBundle.castKey(bundleKey, value, constantsProvider, wrapper, null);
    }

    protected static Object castKey(String bundleKey, Object value, Map<String, Object> constantsProvider, Class<?> wrapper, Locale locale) {
        Object key;
        Map<String, Object> provider;
        block28: {
            if (bundleKey == null) {
                return null;
            }
            provider = constantsProvider;
            int lastDot = bundleKey.lastIndexOf(46);
            if (lastDot > 0) {
                String className = bundleKey.substring(0, lastDot);
                try {
                    Class<?> providerClass = Class.forName(className);
                    provider = SortedBundle.getConstantsProvider(providerClass);
                }
                catch (ClassNotFoundException cnfe) {
                    if (!log.isDebugEnabled()) break block28;
                    log.debug("No class found with name " + className + " found from " + bundleKey);
                }
            }
        }
        if (provider != null) {
            key = provider.get(bundleKey.toUpperCase());
            if (key == null) {
                log.debug("Could not find " + bundleKey.toUpperCase() + " in " + constantsProvider);
                key = bundleKey;
            }
        } else {
            key = bundleKey;
        }
        if (wrapper != null && !wrapper.isAssignableFrom(key.getClass())) {
            try {
                Constructor<?> c;
                if (ValueWrapper.class.isAssignableFrom(wrapper)) {
                    if (locale == null) {
                        c = wrapper.getConstructor(Object.class, Comparable.class);
                        key = c.newInstance(key, value);
                    } else {
                        c = wrapper.getConstructor(Object.class, Object.class, Comparator.class);
                        Collator comp = Collator.getInstance(locale);
                        comp.setStrength(0);
                        key = c.newInstance(key, value, comp);
                    }
                } else if (Number.class.isAssignableFrom(wrapper)) {
                    if (key instanceof String) {
                        if (Casting.DOUBLE_PATTERN.matcher((String)key).matches()) {
                            key = Casting.toType(wrapper, key);
                        }
                    } else {
                        key = Casting.toType(wrapper, key);
                        log.debug("wrapper is a Number, that can simply be cast " + value + " --> " + key + "(" + wrapper + ")");
                    }
                } else if (Boolean.class.isAssignableFrom(wrapper)) {
                    if (key instanceof String) {
                        if (Casting.BOOLEAN_PATTERN.matcher((String)key).matches()) {
                            key = Casting.toType(wrapper, key);
                        }
                    } else {
                        key = Casting.toType(wrapper, key);
                        log.debug("wrapper is a Boolean, that can simply be cast " + value + " --> " + key + "(" + wrapper + ")");
                    }
                } else {
                    log.debug("wrapper is unrecognized, suppose constructor " + key.getClass());
                    c = wrapper.getConstructor(key.getClass());
                    key = c.newInstance(key);
                }
            }
            catch (NoSuchMethodException nsme) {
                log.warn(nsme.getClass().getName() + ". Could not convert " + key.getClass().getName() + " " + key + " to " + wrapper.getName() + " : " + nsme.getMessage() + " locale " + locale, nsme);
            }
            catch (SecurityException se) {
                log.error(se.getClass().getName() + ". Could not convert " + key.getClass().getName() + " " + key + " to " + wrapper.getName() + " : " + se.getMessage());
            }
            catch (InstantiationException ie) {
                log.error(ie.getClass().getName() + ". Could not convert " + key.getClass().getName() + " " + key + " to " + wrapper.getName() + " : " + ie.getMessage());
            }
            catch (InvocationTargetException ite) {
                log.debug(ite.getClass().getName() + ". Could not convert " + key.getClass().getName() + " " + key + " to " + wrapper.getName() + " : " + ite.getMessage());
            }
            catch (IllegalAccessException iae) {
                log.error(iae.getClass().getName() + ". Could not convert " + key.getClass().getName() + " " + key + " to " + wrapper.getName() + " : " + iae.getMessage());
            }
        }
        return key;
    }

    public static HashMap<String, Object> getConstantsProvider(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        SortedBundle.fillConstantsProvider(clazz, map);
        return map;
    }

    private static void fillConstantsProvider(Class<?> clazz, Map<String, Object> map) {
        while (clazz != null) {
            Class<?>[] interfaces;
            Field[] fields;
            for (Field constant : fields = clazz.getDeclaredFields()) {
                String key;
                if (!Modifier.isStatic(constant.getModifiers()) || map.containsKey(key = constant.getName().toUpperCase())) continue;
                try {
                    Object value = constant.get(null);
                    try {
                        Method keyMethod = value.getClass().getMethod("getValue", new Class[0]);
                        value = "" + keyMethod.invoke(value, new Object[0]);
                    }
                    catch (NoSuchMethodException nsme) {
                        log.debug("" + nsme);
                        try {
                            Method keyMethod = value.getClass().getMethod("ordinal", new Class[0]);
                            value = "" + keyMethod.invoke(value, new Object[0]);
                        }
                        catch (Exception e1) {
                            log.debug("" + e1);
                        }
                    }
                    catch (Exception e2) {
                        log.debug("" + e2);
                    }
                    map.put(key, value);
                }
                catch (IllegalAccessException ieae) {
                    log.debug("The java constant with name " + key + " is not accessible");
                }
            }
            for (Class<?> element : interfaces = clazz.getInterfaces()) {
                SortedBundle.fillConstantsProvider(element, map);
            }
            clazz = clazz.getSuperclass();
        }
    }

    private SortedBundle() {
    }

    public static class ValueWrapper
    implements Comparable<ValueWrapper> {
        private final Object key;
        private final Object value;
        private final Comparator<Object> com;

        public ValueWrapper(Object k, Comparable<Object> v) {
            this.key = k;
            this.value = v;
            this.com = null;
        }

        public ValueWrapper(Object k, Object v, Comparator<Object> c) {
            this.key = k;
            this.value = v;
            this.com = c;
        }

        @Override
        public int compareTo(ValueWrapper other) {
            int result;
            int n = result = this.com != null ? this.com.compare(this.value, other.value) : ((Comparable)this.value).compareTo(other.value);
            if (result != 0) {
                return result;
            }
            if (this.key instanceof Comparable) {
                return ((Comparable)this.key).compareTo(other.key);
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() == o.getClass()) {
                ValueWrapper other = (ValueWrapper)o;
                return this.key.equals(other.key) && (this.value == null ? other.value == null : this.value.equals(other.value));
            }
            return false;
        }

        public String toString() {
            return Casting.toString(this.key);
        }

        public Object getKey() {
            return this.key;
        }

        public int hashCode() {
            int result = 0;
            result = HashCodeUtil.hashCode(result, this.key);
            result = HashCodeUtil.hashCode(result, this.value);
            result = HashCodeUtil.hashCode(result, this.com);
            return result;
        }
    }
}

