/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class SqlExecutor
implements Runnable {
    private static final Logger LOG = Logging.getLoggerInstance(SqlExecutor.class);
    private String query;
    private String update;
    private String onlyIfQuery;
    private Pattern ignore = Pattern.compile("");
    protected DataSource dataSource;
    protected String prefix;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setPrefix(String pref) {
        this.prefix = pref;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            return "$PREFIX";
        }
        return this.prefix;
    }

    public void setIgnoreException(String e) {
        this.ignore = Pattern.compile(e);
    }

    public void setQuery(String q) {
        if (this.update != null) {
            throw new IllegalStateException();
        }
        this.query = q;
    }

    public void setUpdate(String u) {
        if (this.query != null) {
            throw new IllegalStateException();
        }
        this.update = u;
    }

    public void setOnlyIf(String q) {
        this.onlyIfQuery = q;
    }

    protected void executeQuery(Statement stmt, String q) throws SQLException {
        boolean valid;
        q = q.replace("$PREFIX", this.getPrefix());
        LOG.info(" Executing " + q);
        ResultSet rs = stmt.executeQuery(q);
        StringBuilder header = new StringBuilder();
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            if (i > 1) {
                header.append("|");
            }
            header.append(rs.getMetaData().getColumnName(i));
        }
        LOG.info(header);
        int seq = 0;
        while (valid = rs.next()) {
            ++seq;
            StringBuilder line = new StringBuilder();
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                if (i > 1) {
                    line.append("|");
                }
                line.append(rs.getString(i));
            }
            LOG.info(seq + ":" + line);
        }
    }

    protected void executeUpdate(Statement stmt, String u) throws SQLException {
        u = u.replace("$PREFIX", this.getPrefix());
        LOG.info(" Executing update " + u);
        int result = stmt.executeUpdate(u);
        LOG.service("Result :" + result);
    }

    protected boolean executeOnlyIf(Connection con, String q) throws SQLException {
        if (q == null) {
            return true;
        }
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            q = q.replace("$PREFIX", this.getPrefix());
            LOG.debug(" Executing query " + q);
            ResultSet rs = stmt.executeQuery(q);
            rs.next();
            boolean res = rs.getBoolean(1);
            LOG.debug("Result: " + res);
            boolean bl = res;
            return bl;
        }
        catch (SQLException sqe) {
            LOG.error(sqe.getMessage() + " from " + q);
            throw sqe;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Connection con = null;
        Statement stmt = null;
        try {
            DataSource ds = this.getDataSource();
            con = ds.getConnection();
            if (this.executeOnlyIf(con, this.onlyIfQuery)) {
                stmt = con.createStatement();
                if (this.query != null) {
                    this.executeQuery(stmt, this.query);
                    return;
                } else {
                    if (this.update == null) throw new IllegalStateException("Both query and update properties are unset");
                    this.executeUpdate(stmt, this.update);
                }
                return;
            } else {
                LOG.debug("Skipped because of " + this.onlyIfQuery);
            }
            return;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            if (!this.ignore.matcher(t.getMessage()).matches()) throw new RuntimeException(t.getMessage(), t);
            LOG.info("Ignoring " + t.getMessage());
            return;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String toString() {
        if (this.update != null) {
            return this.update;
        }
        if (this.query != null) {
            return this.query;
        }
        return "No query yet";
    }
}

