/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.IOException;
import java.io.Writer;

public class StringBuilderWriter
extends Writer {
    protected StringBuilder buffer;

    public StringBuilderWriter(StringBuilder buffer) {
        if (buffer == null) {
            throw new NullPointerException("Buffer may not be null");
        }
        this.buffer = buffer;
        this.lock = buffer;
    }

    @Override
    public void write(int c) {
        this.buffer.append((char)c);
    }

    @Override
    public void write(char[] charArray, int offset, int length) {
        if (offset < 0 || offset > charArray.length || length < 0 || offset + length > charArray.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        this.buffer.append(charArray, offset, length);
    }

    @Override
    public void write(String str) {
        this.buffer.append(str);
    }

    @Override
    public void write(String str, int offset, int length) {
        this.buffer.append(str.substring(offset, offset + length));
    }

    public String toString() {
        return this.buffer.toString();
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

