/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.File;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class UriParser {
    private static final Logger log = Logging.getLoggerInstance(UriParser.class);
    static final char SEPARATOR = File.separator.charAt(0);

    public static String makeRelative(String basePath, String path) {
        return UriParser.makeRelative(basePath, path, SEPARATOR);
    }

    public static String makeRelative(String basePath, String path, char separatorChar) {
        int pos;
        if (log.isDebugEnabled()) {
            log.debug("converting:  " + path);
            log.debug("relative to: " + basePath);
        }
        int basePathLen = basePath.length();
        int pathLen = path.length();
        if (basePathLen == 1 && pathLen == 1) {
            return ".";
        }
        if (basePathLen == 1) {
            return path.substring(1);
        }
        int maxlen = Math.min(basePathLen, pathLen);
        for (pos = 0; pos < maxlen && basePath.charAt(pos) == path.charAt(pos); ++pos) {
        }
        if (pos == basePathLen && pos == pathLen) {
            return ".";
        }
        if (pos == basePathLen && pos < pathLen && path.charAt(pos) == separatorChar) {
            return path.substring(pos + 1);
        }
        StringBuilder buffer = new StringBuilder();
        if (pathLen > 1 && (pos < pathLen || basePath.charAt(pos) != separatorChar)) {
            pos = basePath.lastIndexOf(separatorChar, pos);
            buffer.append(path.substring(pos));
        }
        buffer.insert(0, "..");
        pos = basePath.indexOf(separatorChar, pos + 1);
        while (pos != -1) {
            buffer.insert(0, "../");
            pos = basePath.indexOf(separatorChar, pos + 1);
        }
        if (log.isDebugEnabled()) {
            log.debug("is: " + buffer);
        }
        return buffer.toString();
    }
}

