/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.mmbase.cache.xslt.FactoryCache;
import org.mmbase.cache.xslt.TemplateCache;
import org.mmbase.util.SizeOf;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.EntityResolver;
import org.mmbase.util.xml.ErrorHandler;
import org.mmbase.util.xml.URIResolver;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XSLTransformer {
    private static final Logger log = Logging.getLoggerInstance(XSLTransformer.class);
    public static final String NS_AWARE = "org.mmbase.util.XSLTransformer.namespaceAware";

    public static String transform(String xmlPath, String xslPath) {
        return XSLTransformer.transform(xmlPath, xslPath, false);
    }

    public static String transform(String xmlPath, String xslPath, boolean cutXML) {
        try {
            StringWriter res = new StringWriter();
            XSLTransformer.transform(new File(xmlPath), new File(xslPath), (Result)new StreamResult(res), null, true);
            String s = res.toString();
            int n = s.indexOf("\n");
            if (cutXML && s.length() > n) {
                s = s.substring(n + 1);
            }
            return s;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.error(Logging.stackTrace(e));
            return "Error during XSLT tranformation: " + e.getMessage();
        }
    }

    public static void transform(Source xml, File xslFile, Result result, Map<String, Object> params) throws TransformerException {
        XSLTransformer.transform(xml, xslFile, result, params, true);
    }

    public static void transform(Source xml, File xslFile, Result result, Map<String, Object> params, boolean considerDir) throws TransformerException {
        try {
            XSLTransformer.transform(xml, xslFile.toURL(), result, params, considerDir);
        }
        catch (MalformedURLException mfe) {
            throw new TransformerException(mfe.getMessage(), mfe);
        }
    }

    public static void transform(Source xml, URL xslFile, Result result, Map<String, Object> params) throws TransformerException {
        XSLTransformer.transform(xml, xslFile, result, params, true);
    }

    public static void transform(Source xml, URL xslFile, Result result, Map<String, Object> params, boolean considerDir) throws TransformerException {
        URIResolver uri;
        StreamSource xsl;
        TemplateCache cache = TemplateCache.getCache();
        try {
            xsl = new StreamSource(xslFile.openStream());
        }
        catch (IOException ioe) {
            throw new TransformerException(ioe.getMessage(), ioe);
        }
        try {
            xsl.setSystemId(xslFile.toString());
        }
        catch (Exception ioe) {
            // empty catch block
        }
        if (considerDir) {
            try {
                uri = new URIResolver(new URL(xslFile, "."));
            }
            catch (MalformedURLException mfe) {
                throw new TransformerException(mfe.getMessage(), mfe);
            }
        } else {
            uri = new URIResolver();
        }
        Templates cachedXslt = cache.getTemplates(xsl, uri);
        if (log.isDebugEnabled()) {
            log.debug("Size of URIResolver " + SizeOf.getByteSize(uri) + " bytes");
            log.debug("template cache sze " + cache.size() + " entries");
        }
        if (cachedXslt == null) {
            TransformerFactory tf = FactoryCache.getCache().getFactory(uri);
            cachedXslt = tf.newTemplates(xsl);
            cache.put(xsl, cachedXslt, uri);
        } else if (log.isDebugEnabled()) {
            log.debug("Used xslt from cache with " + xsl.getSystemId());
        }
        Transformer transformer = cachedXslt.newTransformer();
        if (log.isDebugEnabled()) {
            log.debug("Size of transformer " + SizeOf.getByteSize(transformer) + " bytes");
        }
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (log.isDebugEnabled()) {
                    log.debug("setting param " + entry.getKey() + " to " + entry.getValue());
                }
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
        }
        transformer.transform(xml, result);
    }

    public static void transform(File xmlFile, File xslFile, Result result, Map<String, Object> params, boolean considerDir) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        boolean validation;
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        boolean bl = validation = !"false".equals(System.getProperty("org.mmbase.XSLTransformer.validation"));
        if (!validation) {
            log.service("disabled validation");
        }
        EntityResolver resolver = new EntityResolver(validation);
        dfactory.setNamespaceAware(true);
        if (params != null && Boolean.FALSE.equals(params.get(NS_AWARE))) {
            dfactory.setNamespaceAware(false);
        }
        DocumentBuilder db = dfactory.newDocumentBuilder();
        ErrorHandler handler = new ErrorHandler();
        db.setErrorHandler(handler);
        db.setEntityResolver(resolver);
        Document xmlDoc = db.parse(xmlFile);
        DOMSource s = new DOMSource(xmlDoc);
        s.setSystemId(xmlFile.toURL().toString());
        XSLTransformer.transform((Source)s, xslFile, result, params, considerDir);
    }

    public static void transform(File xmlDir, File xslFile, File resultDir, boolean recurse, Map<String, Object> params, boolean considerDir) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        File[] files;
        if (!xmlDir.isDirectory()) {
            throw new TransformerException("" + xmlDir + " is not a directory");
        }
        if (!resultDir.exists()) {
            resultDir.mkdir();
        }
        if (!resultDir.isDirectory()) {
            throw new TransformerException("" + resultDir + " is not a directory");
        }
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        List exclude = (List)params.get("exclude");
        for (File element : files = xmlDir.listFiles()) {
            File resultFile;
            if (exclude.contains(element.getName())) continue;
            if (recurse && element.isDirectory()) {
                if ("CVS".equals(element.getName())) continue;
                File resultSubDir = new File(resultDir, element.getName());
                HashMap<Object, Object> myParams = params == null ? new HashMap() : new HashMap<String, Object>(params);
                if (myParams.get("root") == null) {
                    myParams.put("root", "../");
                } else if ("./".equals(myParams.get("root"))) {
                    myParams.put("root", "../");
                } else {
                    myParams.put("root", myParams.get("root") + "../");
                }
                log.info("Transforming directory " + element + " (root is " + myParams.get("root") + ")");
                XSLTransformer.transform(element, xslFile, resultSubDir, recurse, myParams, considerDir);
                continue;
            }
            if (!element.getName().endsWith(".xml")) continue;
            String fileName = element.getName();
            fileName = fileName.substring(0, fileName.length() - 4);
            params.put("filename", fileName);
            String extension = (String)params.get("extension");
            if (extension == null) {
                extension = "html";
            }
            if ((resultFile = new File(resultDir, fileName + "." + extension)).lastModified() > element.lastModified()) {
                log.info("Not transforming " + element + " because " + resultFile + " is up to date");
                continue;
            }
            log.info("Transforming file " + element + " to " + resultFile);
            try {
                StreamResult res = "true".equals(params.get("dontopenfile")) ? new StreamResult(System.out) : new StreamResult(resultFile);
                XSLTransformer.transform(element, xslFile, (Result)res, params, considerDir);
            }
            catch (Exception e) {
                log.error(e.toString());
                log.error(Logging.stackTrace(e));
            }
        }
    }

    public static Result getResult(String[] argv) throws Exception {
        if (argv.length > 2) {
            FileOutputStream stream = new FileOutputStream(argv[2]);
            OutputStreamWriter f = new OutputStreamWriter((OutputStream)stream, "utf-8");
            return new StreamResult(f);
        }
        return new StreamResult(new OutputStreamWriter((OutputStream)System.out, "utf-8"));
    }

    public static void main(String[] argv) {
        block17: {
            if (argv.length < 2) {
                log.info("Use with two arguments: <xslt-file>|SER <xml-inputfile|node-number> [xml-outputfile]");
                log.info("Use with tree arguments: xslt-file xml-inputdir xml-outputdir [key=value options]");
                log.info("special options can be:");
                log.info("   usecache=true:     Use the Template cache or not (to speed up)");
                log.info("   namespaceaware=true:   ");
                log.info("   exclude=<filename>:  File/directory name to exclude (can be used multiple times");
                log.info("   extension=<file extensions>:  File extensions to use in transformation results (defaults to html)");
                log.info("Other options are passed to XSL-stylesheet as parameters.");
            } else {
                boolean namespaceaware = true;
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (argv.length > 3) {
                    for (int i = 3; i < argv.length; ++i) {
                        String key = argv[i];
                        String value = "";
                        int p = key.indexOf("=");
                        if (p > 0) {
                            if (p < key.length() - 1) {
                                value = key.substring(p + 1);
                            }
                            key = key.substring(0, p);
                        }
                        if (key.equals("namespaceaware")) {
                            namespaceaware = value.equals("true");
                            params.put(NS_AWARE, namespaceaware);
                            continue;
                        }
                        if (key.equals("usecache")) {
                            TemplateCache.getCache().setActive(value.equals("true"));
                            continue;
                        }
                        if (key.equals("exclude")) {
                            if (params.get("exclude") == null) {
                                params.put("exclude", new ArrayList());
                            }
                            List excludes = (List)params.get("exclude");
                            excludes.add(value);
                            continue;
                        }
                        params.put(key, value);
                    }
                }
                try {
                    File in = new File(argv[1]);
                    if (in.exists()) {
                        if (in.isDirectory()) {
                            log.info("Transforming directory " + in);
                            long start = System.currentTimeMillis();
                            try {
                                XSLTransformer.transform(in, new File(argv[0]), new File(argv[2]), true, params, true);
                            }
                            catch (Exception e) {
                                log.error("Error: " + e.toString());
                            }
                            log.info("Transforming took " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds");
                            break block17;
                        }
                        log.info("Transforming file " + argv[1]);
                        XSLTransformer.transform(new File(argv[1]), new File(argv[0]), XSLTransformer.getResult(argv), params, true);
                        break block17;
                    }
                    log.debug("" + in + " does not exist, interpreting it as a node, connecting using RMMCI");
                    Result result = XSLTransformer.getResult(argv);
                    Class<?> generatorClass = Class.forName("org.mmbase.util.xml.Generator");
                    Method m = generatorClass.getMethod("getDocument", String[].class, Map.class, Boolean.TYPE);
                    Document doc = (Document)m.invoke(null, new Object[0]);
                    log.debug("transforming");
                    XSLTransformer.transform((Source)new DOMSource(doc), new File(argv[0]), result, params, true);
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), ex);
                    for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                        log.error("CAUSE" + cause.getMessage(), cause);
                    }
                }
            }
        }
    }
}

