/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.dateparser;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import org.mmbase.util.dateparser.DateParserConstants;
import org.mmbase.util.dateparser.DateParserTokenManager;
import org.mmbase.util.dateparser.ParseException;
import org.mmbase.util.dateparser.SimpleCharStream;
import org.mmbase.util.dateparser.Token;

public class DateParser
implements DateParserConstants {
    private static Random random = new Random();
    public static TimeZone defaultTimeZone = TimeZone.getDefault();
    private boolean dynamic = true;
    private long prev = 0L;
    private int amount = 0;
    private int factor = 1;
    private int field = 0;
    private int monthorday = -1;
    private int week = -1;
    private boolean positive = true;
    private Calendar cal = Calendar.getInstance(defaultTimeZone);
    public DateParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns;
    private boolean jj_rescan;
    private int jj_gc;
    private final LookaheadSuccess jj_ls;
    private List<int[]> jj_expentries;
    private int[] jj_expentry;
    private int jj_kind;
    private int[] jj_lasttokens;
    private int jj_endpos;

    public static void setDefault(TimeZone tz) {
        defaultTimeZone = tz;
    }

    public static void main(String[] argv) throws ParseException, InterruptedException {
        DateParser parser = new DateParser(new StringReader(argv[0]));
        parser.start();
        System.out.println("" + parser.toDate());
    }

    public Date toDate() {
        return this.cal.getTime();
    }

    public boolean dynamic() {
        return this.dynamic;
    }

    protected void beginOfMinute() {
        this.cal.set(13, 0);
        this.cal.set(14, 0);
    }

    protected void beginOfHour() {
        this.cal.set(12, 0);
        this.beginOfMinute();
    }

    protected void beginOfDay() {
        this.cal.set(11, 0);
        this.beginOfHour();
    }

    protected void beginOfWeek() {
        this.beginOfDay();
        this.cal.set(7, this.cal.getFirstDayOfWeek());
    }

    protected void beginOfMonth() {
        this.cal.set(5, 1);
        this.beginOfDay();
    }

    protected void beginOfYear() {
        this.cal.set(2, 0);
        this.beginOfMonth();
    }

    protected void beginOfCentury(boolean pedantic) {
        this.beginOfYear();
        int year = this.cal.get(1);
        year -= year % 100;
        this.cal.set(1, year + (pedantic ? 1 : 0));
    }

    protected void beginOfEra() {
        this.beginOfYear();
        this.cal.set(1, this.cal.getActualMinimum(1));
    }

    protected Calendar getInstance() {
        Calendar c = Calendar.getInstance(this.cal.getTimeZone());
        c.setFirstDayOfWeek(2);
        return c;
    }

    public final void start() throws ParseException {
        if (this.jj_2_1(2)) {
            this.time_zone();
        }
        if (this.jj_2_4(2)) {
            this.date();
            if (this.jj_2_3(2)) {
                if (this.jj_2_2(2)) {
                    this.jj_consume_token(12);
                }
                this.time();
            }
        }
        while (this.jj_2_5(2)) {
            if (this.jj_2_6(2)) {
                this.increment();
                continue;
            }
            if (this.jj_2_7(2)) {
                this.decrement();
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (this.jj_2_8(2)) {
            this.time_zone();
        }
        this.jj_consume_token(0);
    }

    public final void time() throws ParseException {
        if (this.jj_2_11(2)) {
            this.hour_number();
            this.jj_consume_token(13);
            this.minute_number();
            if (this.jj_2_10(2)) {
                this.jj_consume_token(13);
                this.second_number();
                if (this.jj_2_9(2)) {
                    this.millisecond_number();
                }
            }
        } else if (this.jj_2_12(2)) {
            this.jj_consume_token(14);
            this.beginOfHour();
            this.cal.set(11, 12);
        } else if (this.jj_2_13(2)) {
            this.jj_consume_token(15);
            this.beginOfHour();
            this.cal.set(11, 0);
        } else if (this.jj_2_14(2)) {
            this.jj_consume_token(16);
            this.beginOfHour();
            this.cal.set(11, 16);
        } else if (this.jj_2_15(2)) {
            this.hour_number();
            this.jj_consume_token(17);
            this.cal.set(12, 0);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void date() throws ParseException {
        if (this.jj_2_17(6)) {
            this.year_number();
            this.jj_consume_token(18);
            this.month_or_day_or_week_number();
            if (this.jj_2_16(2)) {
                this.jj_consume_token(18);
                this.day_of_month_or_week_number();
            }
            if (this.monthorday > 0) {
                this.cal.set(6, this.monthorday);
            }
            if (this.week >= 0) {
                this.cal.set(3, this.week);
                this.cal.set(7, 2);
                this.week = -1;
            }
            this.beginOfDay();
            this.dynamic = false;
        } else if (this.jj_2_18(2)) {
            this.day_of_week();
            this.beginOfDay();
        } else if (this.jj_2_19(2)) {
            this.month_of_year();
            this.beginOfMonth();
        } else if (this.jj_2_20(2)) {
            this.jj_consume_token(19);
            this.cal = this.getInstance();
        } else if (this.jj_2_21(2)) {
            this.seconds();
        } else if (this.jj_2_22(2)) {
            this.jj_consume_token(8);
            this.to_period();
        } else if (this.jj_2_23(2)) {
            this.jj_consume_token(20);
            this.cal = this.getInstance();
            this.cal.add(6, 1);
            this.beginOfDay();
        } else if (this.jj_2_24(2)) {
            this.jj_consume_token(21);
            this.cal = this.getInstance();
            this.cal.add(6, -1);
            this.beginOfDay();
        } else if (this.jj_2_25(2)) {
            this.jj_consume_token(22);
            this.cal = this.getInstance();
            this.cal.add(2, -1);
            this.beginOfMonth();
        } else if (this.jj_2_26(2)) {
            this.jj_consume_token(23);
            this.cal = this.getInstance();
            this.cal.add(1, -1);
            this.beginOfYear();
        } else if (this.jj_2_27(2)) {
            this.jj_consume_token(24);
            this.beginOfYear();
            this.cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cal.set(1, 1970);
        } else if (this.jj_2_28(2)) {
            this.jj_consume_token(25);
            this.beginOfHour();
            this.cal.set(11, 17);
            this.cal.set(7, 6);
            if (Calendar.getInstance(this.cal.getTimeZone()).after(this.cal)) {
                this.cal.add(3, 1);
            }
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void time_zone() throws ParseException {
        if (this.jj_2_29(2)) {
            this.jj_consume_token(11);
            this.cal.setTimeZone(TimeZone.getTimeZone(this.token.toString().substring(2).trim()));
        } else if (this.jj_2_30(2)) {
            this.jj_consume_token(26);
            this.cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void unary() throws ParseException {
        if (this.jj_2_31(2)) {
            this.jj_consume_token(18);
            this.positive = false;
        } else if (this.jj_2_32(2)) {
            this.jj_consume_token(27);
            this.positive = true;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void integer() throws ParseException {
        if (this.jj_2_33(2)) {
            this.unary();
            this.jj_consume_token(9);
        } else if (this.jj_2_34(2)) {
            this.jj_consume_token(9);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void seconds() throws ParseException {
        this.integer();
        this.cal.setTimeInMillis((long)(this.positive ? 1 : -1) * Long.parseLong(this.token.toString()) * 1000L);
        this.dynamic = false;
        this.positive = true;
    }

    public final void year_number() throws ParseException {
        this.integer();
        this.cal.set(1, (this.positive ? 1 : -1) * Integer.parseInt(this.token.toString()));
        this.positive = true;
    }

    public final void week_number() throws ParseException {
        this.jj_consume_token(9);
        this.cal.set(3, Integer.parseInt(this.token.toString()));
    }

    public final void inc_number() throws ParseException {
        this.jj_consume_token(9);
        this.amount = Integer.parseInt(this.token.toString());
    }

    public final void month_or_day_or_week_number() throws ParseException {
        if (this.jj_2_35(2)) {
            this.jj_consume_token(9);
            this.monthorday = Integer.parseInt(this.token.toString());
            this.week = -1;
        } else if (this.jj_2_36(2)) {
            this.jj_consume_token(28);
            this.jj_consume_token(9);
            this.monthorday = -1;
            this.week = Integer.parseInt(this.token.toString());
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void day_of_month_or_week_number() throws ParseException {
        this.jj_consume_token(9);
        if (this.monthorday > 0) {
            this.cal.set(2, this.monthorday - 1);
            this.monthorday = -1;
            this.cal.set(5, Integer.parseInt(this.token.toString()));
        } else {
            this.cal.set(3, this.week);
            this.week = -1;
            int day = (Integer.parseInt(this.token.toString()) + 1) % 7;
            if (day == 0) {
                day = 7;
            }
            this.cal.set(7, day);
        }
    }

    public final void day_of_year_number() throws ParseException {
        this.jj_consume_token(9);
        this.cal.set(6, Integer.parseInt(this.token.toString()));
    }

    public final void day_of_week_number() throws ParseException {
        this.jj_consume_token(9);
        this.cal.set(7, Integer.parseInt(this.token.toString()));
    }

    public final void hour_number() throws ParseException {
        this.jj_consume_token(9);
        this.cal.set(11, Integer.parseInt(this.token.toString()));
    }

    public final void minute_number() throws ParseException {
        this.jj_consume_token(9);
        this.cal.set(12, Integer.parseInt(this.token.toString()));
        this.cal.set(13, 0);
        this.cal.set(14, 0);
    }

    public final void second_number() throws ParseException {
        this.jj_consume_token(9);
        this.cal.set(13, Integer.parseInt(this.token.toString()));
        this.cal.set(14, 0);
    }

    public final void millisecond_number() throws ParseException {
        this.jj_consume_token(10);
        this.cal.set(14, Integer.parseInt(this.token.toString().substring(1)));
    }

    public final void increment() throws ParseException {
        if (this.jj_2_37(2)) {
            this.jj_consume_token(27);
            this.inc_number();
            this.inc_period();
            this.cal.add(this.field, this.amount * this.factor);
            this.factor = 1;
        } else if (this.jj_2_38(2)) {
            this.jj_consume_token(5);
            this.inc_period();
            this.cal.add(this.field, 1 * this.factor);
            this.factor = 1;
        } else if (this.jj_2_39(2)) {
            this.jj_consume_token(6);
            this.inc_period();
            this.cal.add(this.field, -1 * this.factor);
            this.factor = 1;
        } else if (this.jj_2_40(2)) {
            this.next();
            this.day_of_week();
            this.beginOfDay();
            if (this.cal.getTime().getTime() < this.prev) {
                this.cal.add(6, 7);
            }
        } else if (this.jj_2_41(2)) {
            this.previous();
            this.day_of_week();
            this.beginOfDay();
            if (this.cal.getTime().getTime() > this.prev) {
                this.cal.add(6, -7);
            }
        } else if (this.jj_2_42(2)) {
            this.jj_consume_token(7);
            this.day_of_week();
            this.beginOfDay();
        } else if (this.jj_2_43(2)) {
            this.next();
            this.month_of_year();
            this.beginOfMonth();
            if (this.cal.getTime().getTime() < this.prev) {
                this.cal.add(1, 1);
            }
        } else if (this.jj_2_44(2)) {
            this.previous();
            this.month_of_year();
            this.beginOfMonth();
            if (this.cal.getTime().getTime() > this.prev) {
                this.cal.add(1, -1);
            }
        } else if (this.jj_2_45(2)) {
            this.jj_consume_token(7);
            this.month_of_year();
            this.beginOfMonth();
        } else if (this.jj_2_46(2)) {
            this.jj_consume_token(7);
            this.to_period();
        } else if (this.jj_2_47(2)) {
            this.jj_consume_token(29);
            this.cal.add(14, (int)(random.nextGaussian() * 1200000.0) + 300000);
            this.dynamic = true;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void decrement() throws ParseException {
        this.jj_consume_token(18);
        this.inc_number();
        this.inc_period();
        this.cal.add(this.field, -1 * this.amount * this.factor);
        this.factor = 1;
    }

    public final void to_period() throws ParseException {
        this.cal = this.getInstance();
        this.this_period();
    }

    public final void inc_period() throws ParseException {
        if (this.jj_2_48(2)) {
            this.jj_consume_token(30);
            this.field = 13;
        } else if (this.jj_2_49(2)) {
            this.jj_consume_token(31);
            this.field = 12;
        } else if (this.jj_2_50(2)) {
            this.jj_consume_token(32);
            this.field = 10;
        } else if (this.jj_2_51(2)) {
            this.jj_consume_token(33);
            this.field = 6;
        } else if (this.jj_2_52(2)) {
            this.jj_consume_token(34);
            this.field = 3;
        } else if (this.jj_2_53(2)) {
            this.jj_consume_token(35);
            this.field = 2;
        } else if (this.jj_2_54(2)) {
            this.jj_consume_token(36);
            this.field = 1;
        } else if (this.jj_2_55(2)) {
            this.jj_consume_token(37);
            this.field = 1;
            this.factor = 100;
        } else if (this.jj_2_56(2)) {
            this.jj_consume_token(38);
            this.field = 14;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void this_period() throws ParseException {
        if (this.jj_2_57(2)) {
            this.jj_consume_token(30);
            this.cal.set(14, 0);
        } else if (this.jj_2_58(2)) {
            this.jj_consume_token(31);
            this.beginOfMinute();
        } else if (this.jj_2_59(2)) {
            this.jj_consume_token(32);
            this.beginOfHour();
        } else if (this.jj_2_60(2)) {
            this.jj_consume_token(33);
            this.beginOfDay();
        } else if (this.jj_2_61(2)) {
            this.jj_consume_token(34);
            this.beginOfWeek();
        } else if (this.jj_2_62(2)) {
            this.jj_consume_token(35);
            this.beginOfMonth();
        } else if (this.jj_2_63(2)) {
            this.jj_consume_token(36);
            this.beginOfYear();
        } else if (this.jj_2_64(2)) {
            this.jj_consume_token(37);
            this.beginOfCentury(false);
        } else if (this.jj_2_65(2)) {
            this.jj_consume_token(39);
            this.beginOfCentury(true);
        } else if (this.jj_2_66(2)) {
            this.jj_consume_token(40);
            this.beginOfEra();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void day_of_week() throws ParseException {
        this.cal.getTime();
        if (this.jj_2_67(2)) {
            this.jj_consume_token(41);
            this.cal.set(7, 1);
        } else if (this.jj_2_68(2)) {
            this.jj_consume_token(42);
            this.cal.set(7, 2);
        } else if (this.jj_2_69(2)) {
            this.jj_consume_token(43);
            this.cal.set(7, 3);
        } else if (this.jj_2_70(2)) {
            this.jj_consume_token(44);
            this.cal.set(7, 4);
        } else if (this.jj_2_71(2)) {
            this.jj_consume_token(45);
            this.cal.set(7, 5);
        } else if (this.jj_2_72(2)) {
            this.jj_consume_token(46);
            this.cal.set(7, 6);
        } else if (this.jj_2_73(2)) {
            this.jj_consume_token(47);
            this.cal.set(7, 7);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void month_of_year() throws ParseException {
        if (this.jj_2_74(2)) {
            this.jj_consume_token(48);
            this.cal.set(2, 0);
        } else if (this.jj_2_75(2)) {
            this.jj_consume_token(49);
            this.cal.set(2, 1);
        } else if (this.jj_2_76(2)) {
            this.jj_consume_token(50);
            this.cal.set(2, 2);
        } else if (this.jj_2_77(2)) {
            this.jj_consume_token(51);
            this.cal.set(2, 3);
        } else if (this.jj_2_78(2)) {
            this.jj_consume_token(52);
            this.cal.set(2, 4);
        } else if (this.jj_2_79(2)) {
            this.jj_consume_token(53);
            this.cal.set(2, 5);
        } else if (this.jj_2_80(2)) {
            this.jj_consume_token(54);
            this.cal.set(2, 6);
        } else if (this.jj_2_81(2)) {
            this.jj_consume_token(55);
            this.cal.set(2, 7);
        } else if (this.jj_2_82(2)) {
            this.jj_consume_token(56);
            this.cal.set(2, 8);
        } else if (this.jj_2_83(2)) {
            this.jj_consume_token(57);
            this.cal.set(2, 9);
        } else if (this.jj_2_84(2)) {
            this.jj_consume_token(58);
            this.cal.set(2, 10);
        } else if (this.jj_2_85(2)) {
            this.jj_consume_token(59);
            this.cal.set(2, 11);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void next() throws ParseException {
        this.jj_consume_token(5);
        this.prev = this.cal.getTime().getTime();
    }

    public final void previous() throws ParseException {
        this.jj_consume_token(6);
        this.prev = this.cal.getTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_69(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_69();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(68, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_70(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_70();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(69, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_71(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_71();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(70, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_72(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_72();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(71, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_73(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_73();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(72, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_74(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_74();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(73, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_75(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_75();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(74, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_76(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_76();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(75, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_77(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_77();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(76, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_78(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_78();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(77, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_79(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_79();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(78, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_80(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_80();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(79, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_81(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_81();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(80, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_82(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_82();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(81, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_83(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_83();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(82, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_84(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_84();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(83, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_85(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_85();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(84, xla);
        }
    }

    private boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_34()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_34() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_33() {
        if (this.jj_3R_17()) {
            return true;
        }
        return this.jj_scan_token(9);
    }

    private boolean jj_3_32() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_32()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_31() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3_30() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3_6() {
        return this.jj_3R_5();
    }

    private boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_7()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_8();
    }

    private boolean jj_3R_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_29()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_30()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_29() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3_28() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3_27() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3_26() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3_25() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3_24() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3_23() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3_22() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_16();
    }

    private boolean jj_3_21() {
        return this.jj_3R_15();
    }

    private boolean jj_3_20() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3_19() {
        return this.jj_3R_14();
    }

    private boolean jj_3_18() {
        return this.jj_3R_13();
    }

    private boolean jj_3_2() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_3();
    }

    private boolean jj_3R_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_18()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_19()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_20()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_21()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_22()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_23()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_24()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_25()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_26()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_27()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3_28()) {
                                                        return true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_3R_4()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_17() {
        if (this.jj_3R_11()) {
            return true;
        }
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_3R_12()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_15() {
        if (this.jj_3R_9()) {
            return true;
        }
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_21() {
        return this.jj_scan_token(6);
    }

    private boolean jj_3_14() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3_13() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3_12() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_20() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_12()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_13()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_14()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_15()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_11() {
        if (this.jj_3R_9()) {
            return true;
        }
        return this.jj_scan_token(13);
    }

    private boolean jj_3_85() {
        return this.jj_scan_token(59);
    }

    private boolean jj_3_1() {
        return this.jj_3R_2();
    }

    private boolean jj_3_84() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3_83() {
        return this.jj_scan_token(57);
    }

    private boolean jj_3_82() {
        return this.jj_scan_token(56);
    }

    private boolean jj_3_81() {
        return this.jj_scan_token(55);
    }

    private boolean jj_3_80() {
        return this.jj_scan_token(54);
    }

    private boolean jj_3_79() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3_78() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3_77() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3_76() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3_75() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_74()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_75()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_76()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_77()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_78()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_79()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_80()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_81()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_82()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_83()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_84()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3_85()) {
                                                        return true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_74() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3_73() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3_72() {
        return this.jj_scan_token(46);
    }

    private boolean jj_3_71() {
        return this.jj_scan_token(45);
    }

    private boolean jj_3_68() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3_70() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3_69() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_68()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_69()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_70()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_71()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_72()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_73()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_67() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3_66() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3_65() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3_63() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3_64() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3_62() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3_61() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3_60() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3_59() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3_58() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_57()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_58()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_59()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_60()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_61()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_62()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_63()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_64()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_65()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_66()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_57() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_55() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3_56() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3_54() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3_53() {
        return this.jj_scan_token(35);
    }

    private boolean jj_3_52() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3_51() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3_50() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3_49() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_49()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_50()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_51()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_52()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_53()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_54()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_55()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_56()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_48() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_16() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_6() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_18();
    }

    private boolean jj_3_47() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3_46() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_16();
    }

    private boolean jj_3_45() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3_44() {
        if (this.jj_3R_21()) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3_43() {
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3_41() {
        if (this.jj_3R_21()) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3_42() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3_40() {
        if (this.jj_3R_20()) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3_39() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_19();
    }

    private boolean jj_3_38() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_19();
    }

    private boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_37()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_38()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_39()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_40()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_41()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_42()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_43()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3_44()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3_45()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3_46()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3_47()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_37() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_18();
    }

    private boolean jj_3R_7() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_8() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_9() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_10() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_36() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_35()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_36()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_35() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_8() {
        return this.jj_3R_2();
    }

    private boolean jj_3_16() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private boolean jj_3R_11() {
        return this.jj_3R_22();
    }

    private boolean jj_3_9() {
        return this.jj_3R_7();
    }

    private boolean jj_3R_15() {
        return this.jj_3R_22();
    }

    private boolean jj_3_7() {
        return this.jj_3R_6();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[0];
    }

    public DateParser(InputStream stream) {
        this(stream, null);
    }

    public DateParser(InputStream stream, String encoding) {
        int i;
        this.cal.setFirstDayOfWeek(2);
        this.cal.setMinimalDaysInFirstWeek(4);
        this.jj_la1 = new int[0];
        this.jj_2_rtns = new JJCalls[85];
        this.jj_rescan = false;
        this.jj_gc = 0;
        this.jj_ls = new LookaheadSuccess();
        this.jj_expentries = new ArrayList<int[]>();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new DateParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DateParser(Reader stream) {
        int i;
        this.cal.setFirstDayOfWeek(2);
        this.cal.setMinimalDaysInFirstWeek(4);
        this.jj_la1 = new int[0];
        this.jj_2_rtns = new JJCalls[85];
        this.jj_rescan = false;
        this.jj_gc = 0;
        this.jj_ls = new LookaheadSuccess();
        this.jj_expentries = new ArrayList<int[]>();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new DateParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DateParser(DateParserTokenManager tm) {
        int i;
        this.cal.setFirstDayOfWeek(2);
        this.cal.setMinimalDaysInFirstWeek(4);
        this.jj_la1 = new int[0];
        this.jj_2_rtns = new JJCalls[85];
        this.jj_rescan = false;
        this.jj_gc = 0;
        this.jj_ls = new LookaheadSuccess();
        this.jj_expentries = new ArrayList<int[]>();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(DateParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[60];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 60; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 85; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                            break;
                        }
                        case 52: {
                            this.jj_3_53();
                            break;
                        }
                        case 53: {
                            this.jj_3_54();
                            break;
                        }
                        case 54: {
                            this.jj_3_55();
                            break;
                        }
                        case 55: {
                            this.jj_3_56();
                            break;
                        }
                        case 56: {
                            this.jj_3_57();
                            break;
                        }
                        case 57: {
                            this.jj_3_58();
                            break;
                        }
                        case 58: {
                            this.jj_3_59();
                            break;
                        }
                        case 59: {
                            this.jj_3_60();
                            break;
                        }
                        case 60: {
                            this.jj_3_61();
                            break;
                        }
                        case 61: {
                            this.jj_3_62();
                            break;
                        }
                        case 62: {
                            this.jj_3_63();
                            break;
                        }
                        case 63: {
                            this.jj_3_64();
                            break;
                        }
                        case 64: {
                            this.jj_3_65();
                            break;
                        }
                        case 65: {
                            this.jj_3_66();
                            break;
                        }
                        case 66: {
                            this.jj_3_67();
                            break;
                        }
                        case 67: {
                            this.jj_3_68();
                            break;
                        }
                        case 68: {
                            this.jj_3_69();
                            break;
                        }
                        case 69: {
                            this.jj_3_70();
                            break;
                        }
                        case 70: {
                            this.jj_3_71();
                            break;
                        }
                        case 71: {
                            this.jj_3_72();
                            break;
                        }
                        case 72: {
                            this.jj_3_73();
                            break;
                        }
                        case 73: {
                            this.jj_3_74();
                            break;
                        }
                        case 74: {
                            this.jj_3_75();
                            break;
                        }
                        case 75: {
                            this.jj_3_76();
                            break;
                        }
                        case 76: {
                            this.jj_3_77();
                            break;
                        }
                        case 77: {
                            this.jj_3_78();
                            break;
                        }
                        case 78: {
                            this.jj_3_79();
                            break;
                        }
                        case 79: {
                            this.jj_3_80();
                            break;
                        }
                        case 80: {
                            this.jj_3_81();
                            break;
                        }
                        case 81: {
                            this.jj_3_82();
                            break;
                        }
                        case 82: {
                            this.jj_3_83();
                            break;
                        }
                        case 83: {
                            this.jj_3_84();
                            break;
                        }
                        case 84: {
                            this.jj_3_85();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        DateParser.jj_la1_init_0();
        DateParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

