/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.externalprocess;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.mmbase.util.externalprocess.IProgressMonitor;
import org.mmbase.util.externalprocess.ProcessClosure;
import org.mmbase.util.externalprocess.ProcessException;
import org.mmbase.util.externalprocess.ProcessFactory;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class CommandLauncher {
    private static final Logger log = Logging.getLoggerInstance(CommandLauncher.class);
    private static final int BUFFER_SIZE = 1024;
    protected static final long DELAY = 50L;
    private static int counter = 0;
    protected Process process = null;
    protected String[] commandArgs;
    protected String name = "";
    private String lineSeparator;

    public CommandLauncher(String name) {
        this.name = counter++ + " " + name;
        this.lineSeparator = System.getProperty("line.separator", "\n");
    }

    public String[] getCommandArgs() {
        return this.commandArgs;
    }

    protected String[] constructCommandArray(String command, String[] commandArgs) {
        String[] args = new String[1 + commandArgs.length];
        args[0] = command;
        System.arraycopy(commandArgs, 0, args, 1, commandArgs.length);
        return args;
    }

    public void execute(String command) throws ProcessException {
        if (log.isDebugEnabled()) {
            this.printCommandLine(new String[]{command});
        }
        try {
            this.process = ProcessFactory.getFactory().exec(command);
        }
        catch (IOException e) {
            throw new ProcessException("An I/O error occured: " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new ProcessException("A security manager exists and its checkExec method doesn't allow creation of a subprocess.", e);
        }
        catch (NullPointerException e) {
            throw new ProcessException("Command is null.", e);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessException("Command is empty.", e);
        }
    }

    public void execute(String[] commandArgs) throws ProcessException {
        if (log.isDebugEnabled()) {
            this.printCommandLine(commandArgs);
        }
        try {
            this.process = ProcessFactory.getFactory().exec(commandArgs);
        }
        catch (IOException e) {
            throw new ProcessException("An I/O error occured: " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new ProcessException("A security manager exists and its checkExec method doesn't allow creation of a subprocess.", e);
        }
        catch (NullPointerException e) {
            throw new ProcessException("Command is null.", e);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessException("Command is empty.", e);
        }
    }

    public void execute(String commandPath, String[] args) throws ProcessException {
        this.commandArgs = this.constructCommandArray(commandPath, args);
        this.execute(this.commandArgs);
    }

    public void execute(String[] commandArgs, String[] env) throws ProcessException {
        if (log.isDebugEnabled()) {
            this.printCommandLine(commandArgs);
        }
        try {
            this.process = ProcessFactory.getFactory().exec(commandArgs, env);
        }
        catch (IOException e) {
            throw new ProcessException("An I/O error occured: " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new ProcessException("A security manager exists and its checkExec method doesn't allow creation of a subprocess.", e);
        }
        catch (NullPointerException e) {
            throw new ProcessException("Command is null.", e);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessException("Command is empty.", e);
        }
    }

    public void execute(String commandPath, String[] args, String[] env) throws ProcessException {
        this.commandArgs = this.constructCommandArray(commandPath, args);
        this.execute(this.commandArgs, env);
    }

    public void execute(String[] commandArgs, String[] env, String changeToDirectory) throws ProcessException {
        if (log.isDebugEnabled()) {
            this.printCommandLine(commandArgs);
        }
        try {
            this.process = ProcessFactory.getFactory().exec(commandArgs, env, changeToDirectory);
        }
        catch (IOException e) {
            throw new ProcessException("An I/O error occured: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new ProcessException("A security manager exists and its checkExec method doesn't allow creation of a subprocess.");
        }
        catch (NullPointerException e) {
            throw new ProcessException("Command is null.");
        }
        catch (IllegalArgumentException e) {
            throw new ProcessException("Command is empty.");
        }
    }

    public void execute(String commandPath, String[] args, String[] env, String changeToDirectory) throws ProcessException {
        this.commandArgs = this.constructCommandArray(commandPath, args);
        this.execute(this.commandArgs, env, changeToDirectory);
    }

    public void waitAndRead(OutputStream out, OutputStream err) throws ProcessException {
        if (this.process == null) {
            throw new ProcessException("Process not yet executed");
        }
        ProcessClosure reader = new ProcessClosure(this.name, this.process, null, out, err);
        reader.readBlocking();
    }

    public void waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) throws ProcessException {
        PipedInputStream inputPipe;
        PipedInputStream errInPipe;
        if (this.process == null) {
            throw new ProcessException("Process not yet executed");
        }
        PipedOutputStream errOutPipe = new PipedOutputStream();
        PipedOutputStream outputPipe = new PipedOutputStream();
        try {
            errInPipe = new PipedInputStream(errOutPipe);
            inputPipe = new PipedInputStream(outputPipe);
        }
        catch (IOException e) {
            throw new ProcessException("Command canceled");
        }
        ProcessClosure closure = new ProcessClosure(this.name, this.process, null, outputPipe, errOutPipe);
        closure.readNonBlocking();
        this.processStreams(closure, output, inputPipe, err, errInPipe, monitor);
    }

    public ProcessClosure waitAndWrite(InputStream in, OutputStream out, OutputStream err) throws ProcessException {
        if (this.process == null) {
            throw new ProcessException("Process not yet executed");
        }
        ProcessClosure reader = new ProcessClosure(this.name, this.process, in, out, err);
        reader.writeBlocking();
        return reader;
    }

    public void waitAndWrite(InputStream in, OutputStream output, OutputStream err, IProgressMonitor monitor) throws ProcessException {
        PipedInputStream inputPipe;
        PipedInputStream errInPipe;
        if (this.process == null) {
            throw new ProcessException("Process not yet executed");
        }
        PipedOutputStream errOutPipe = new PipedOutputStream();
        PipedOutputStream outputPipe = new PipedOutputStream();
        try {
            errInPipe = new PipedInputStream(errOutPipe);
            inputPipe = new PipedInputStream(outputPipe);
        }
        catch (IOException e) {
            throw new ProcessException("Command canceled");
        }
        ProcessClosure closure = new ProcessClosure(this.name, this.process, in, outputPipe, errOutPipe);
        closure.readNonBlocking();
        closure.writeNonBlocking();
        this.processStreams(closure, output, inputPipe, err, errInPipe, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStreams(ProcessClosure closure, OutputStream output, PipedInputStream inputPipe, OutputStream err, PipedInputStream errInPipe, IProgressMonitor monitor) throws ProcessException {
        int nbytes;
        monitor.begin();
        byte[] buffer = new byte[1024];
        while (!monitor.isCanceled() && closure.isAlive()) {
            nbytes = 0;
            try {
                if (errInPipe.available() > 0) {
                    nbytes = errInPipe.read(buffer);
                    err.write(buffer, 0, nbytes);
                    err.flush();
                }
                if (inputPipe.available() > 0) {
                    nbytes = inputPipe.read(buffer);
                    output.write(buffer, 0, nbytes);
                    output.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (nbytes == 0) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
            monitor.worked();
        }
        if (monitor.isCanceled()) {
            closure.terminate();
            throw new ProcessException("Command canceled");
        }
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            monitor.setCanceled(true);
            log.service("Interrupted");
        }
        try {
            while (errInPipe.available() > 0 || inputPipe.available() > 0) {
                if (monitor.isCanceled()) {
                    closure.terminate();
                    throw new ProcessException("Command canceled");
                }
                nbytes = 0;
                if (errInPipe.available() > 0) {
                    nbytes = errInPipe.read(buffer);
                    err.write(buffer, 0, nbytes);
                    err.flush();
                }
                if (inputPipe.available() > 0) {
                    nbytes = inputPipe.read(buffer);
                    output.write(buffer, 0, nbytes);
                    output.flush();
                }
                if (nbytes == 0) continue;
                monitor.worked();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                errInPipe.close();
            }
            catch (IOException iOException) {}
            try {
                inputPipe.close();
            }
            catch (IOException iOException) {}
        }
        monitor.done();
    }

    public void printCommandLine(String[] commandArgs) {
        StringBuilder buf = new StringBuilder();
        for (String element : commandArgs) {
            buf.append(element);
            buf.append(' ');
        }
        buf.append(this.lineSeparator);
        log.debug(buf.toString());
    }

    public Process getProcess() {
        return this.process;
    }
}

