/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.externalprocess;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mmbase.util.externalprocess.CommandLauncher;
import org.mmbase.util.externalprocess.ProcessException;

public class EnvironmentReader {
    private static Properties envVars = null;
    private static Vector<String> rawVars = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getEnvVars() {
        if (null != envVars) {
            return envVars;
        }
        envVars = new Properties();
        rawVars = new Vector(32);
        String lineSeparator = System.getProperty("line.separator");
        String command = EnvironmentReader.getEnvCommand();
        CommandLauncher launcher = new CommandLauncher("EnvironmentReader");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            launcher.execute(command);
            launcher.waitAndRead(outputStream, null);
            String envStr = outputStream.toString();
            StringTokenizer strTokens = new StringTokenizer(envStr, lineSeparator);
            while (strTokens.hasMoreTokens()) {
                String line = strTokens.nextToken();
                rawVars.add(line);
                int idx = line.indexOf(61);
                if (idx != -1) {
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    envVars.setProperty(key, value);
                    continue;
                }
                envVars.setProperty(line, "");
            }
        }
        catch (ProcessException processException) {
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        rawVars.trimToSize();
        return envVars;
    }

    public static String getEnvCommand() {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("windows 9") > -1) {
            return "command.com /c set";
        }
        if (OS.indexOf("nt") > -1 || OS.indexOf("windows 2000") > -1 || OS.indexOf("windows xp") > -1) {
            return "cmd.exe /c set";
        }
        throw new UnsupportedOperationException("OS not supported yet");
    }

    public static String getEnvVar(String key) {
        Properties p = EnvironmentReader.getEnvVars();
        return p.getProperty(key);
    }

    public static String[] getRawEnvVars() {
        EnvironmentReader.getEnvVars();
        return rawVars.toArray(new String[rawVars.size()]);
    }
}

