/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.externalprocess;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

class StreamCopyThread
extends Thread {
    private static final Logger log = Logging.getLoggerInstance(StreamCopyThread.class);
    protected static final long WAIT_DELAY = 25L;
    public static final int BUFFER_SIZE = 1024;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean processInput = false;
    private boolean finished = false;
    private long count = 0L;

    public StreamCopyThread(String name, InputStream in, OutputStream out, boolean pInput) {
        this(null, name, in, out, pInput);
    }

    public StreamCopyThread(ThreadGroup group, String name, InputStream in, OutputStream out, boolean pInput) {
        super(group, name);
        this.processInput = pInput;
        this.outputStream = out;
        this.inputStream = in;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedInputStream reader = new BufferedInputStream(this.inputStream);
        BufferedOutputStream writer = null;
        if (this.outputStream != null) {
            writer = new BufferedOutputStream(this.outputStream);
        }
        try {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                log.info("Interrupted");
                if (this.processInput) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.complete();
                return;
            }
            this.count = 0L;
            int size = 0;
            byte[] buffer = new byte[1024];
            while ((size = reader.read(buffer)) != -1) {
                if (writer != null) {
                    writer.write(buffer, 0, size);
                    writer.flush();
                }
                this.count += (long)size;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (this.processInput) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            } else {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
            this.complete();
        }
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public long getCount() {
        return this.count;
    }

    public synchronized void waitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void complete() {
        this.finished = true;
        this.notify();
        log.debug("StreamCopy " + this.getName() + " finished.");
    }
}

