/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.mmbase.util.ThreadPools;
import org.mmbase.util.logging.AbstractSimpleImpl;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.logging.WriterLogger;

public class BufferedLogger
extends AbstractSimpleImpl {
    private static final Logger LOG = Logging.getLoggerInstance(BufferedLogger.class);
    protected static List<WeakReference<BufferedLogger>> instances = new CopyOnWriteArrayList<WeakReference<BufferedLogger>>();
    private final List<LogEntry> history = Collections.synchronizedList(new LinkedList());
    private long maxAge = Long.MAX_VALUE;
    private int maxSize = Integer.MAX_VALUE;

    public BufferedLogger() {
        instances.add(new WeakReference<BufferedLogger>(this));
    }

    public void setMaxAge(long ma) {
        this.maxAge = ma;
    }

    public void setMaxSize(int ms) {
        this.maxSize = ms;
    }

    protected int cleanup() {
        int tot = 0;
        while (this.history.size() > this.maxSize) {
            this.history.remove(0);
            ++tot;
        }
        long deleteStamp = System.currentTimeMillis() - this.maxAge;
        while (this.history.get((int)0).timeStamp.getTime() < deleteStamp) {
            this.history.remove(0);
            ++tot;
        }
        return tot;
    }

    @Override
    protected void log(String s, Level level) {
        LOG.debug("buffering " + level + " " + s);
        this.history.add(new LogEntry(s, level));
        if (this.history.size() > this.maxSize) {
            this.history.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reLog(Logger log, boolean clear, Date after) {
        List<LogEntry> list = this.history;
        synchronized (list) {
            Iterator<LogEntry> i = this.history.iterator();
            while (i.hasNext()) {
                LogEntry entry = i.next();
                if (clear) {
                    i.remove();
                }
                if (entry.timeStamp.after(after)) {
                    LOG.debug("Relogging " + log);
                    Logging.log(entry.level, log, entry.line);
                    continue;
                }
                LOG.debug("Not relogging " + log + " (too old)");
            }
        }
    }

    public String getList(Level l) {
        StringWriter w = new StringWriter();
        this.reLog(new WriterLogger(w, l), false, new Date(0L));
        return w.toString();
    }

    public String getDebugList() {
        return this.getList(Level.DEBUG);
    }

    static {
        ThreadPools.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (WeakReference<BufferedLogger> ref : instances) {
                    BufferedLogger buffer = (BufferedLogger)ref.get();
                    if (buffer == null) continue;
                    int cleaned = buffer.cleanup();
                    LOG.debug("Cleaned up " + cleaned + " log entry from " + buffer);
                }
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    protected class LogEntry {
        final Date timeStamp = new Date();
        final String line;
        final Level level;

        public LogEntry(String line, Level level) {
            this.level = level;
            this.line = line;
        }
    }
}

